/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ManualArrayCopyInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            ManualArrayCopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayCopyVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ManualArrayCopyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayCopyInspection", "buildErrorString"));
    }

    private static class ManualArrayCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayCopyVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            CountingLoop countingLoop = CountingLoop.from(statement);
            if (countingLoop == null) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayCopyVisitor.bodyIsArrayCopy(body, (PsiVariable)countingLoop.getCounter())) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean bodyIsArrayCopy(PsiStatement body, PsiVariable variable) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement exp = (PsiExpressionStatement)body;
                PsiExpression expression = exp.getExpression();
                return ManualArrayCopyVisitor.expressionIsArrayCopy(expression, variable);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[0], variable);
                }
                if (statements.length == 2) {
                    PsiStatement statement = statements[0];
                    if (!(statement instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer, variable)) {
                        return false;
                    }
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[1], variable);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayCopy(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
            PsiExpression strippedRhs;
            PsiExpression strippedLhs;
            PsiExpression strippedExpression;
            if (variable == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(1);
            }
            if ((strippedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
                return false;
            }
            if (!(strippedExpression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)strippedExpression;
            IElementType tokenType = assignment.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQ)) {
                return false;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return false;
            }
            if (!ExpressionUtils.isOffsetArrayAccess(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(rhs)) {
                return false;
            }
            if (!ManualArrayCopyVisitor.areExpressionsCopyable(lhs, rhs)) {
                return false;
            }
            PsiType type = lhs.getType();
            if (type instanceof PsiPrimitiveType && !ManualArrayCopyVisitor.areExpressionsCopyable(strippedLhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs), strippedRhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs))) {
                return false;
            }
            if (!ExpressionUtils.isOffsetArrayAccess(rhs, variable)) {
                return false;
            }
            return !ManualArrayCopyVisitor.isSameSourceAndDestination(lhs, rhs);
        }

        private static boolean isSameSourceAndDestination(PsiExpression lhs, PsiExpression rhs) {
            lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs);
            rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs);
            assert (lhs != null && rhs != null);
            PsiArrayAccessExpression left = (PsiArrayAccessExpression)lhs;
            PsiArrayAccessExpression right = (PsiArrayAccessExpression)rhs;
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left.getArrayExpression(), right.getArrayExpression());
        }

        private static boolean areExpressionsCopyable(@Nullable PsiExpression lhs, @Nullable PsiExpression rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            return !(lhsType instanceof PsiPrimitiveType ? !lhsType.equals(rhsType) : !lhsType.isAssignableFrom(rhsType) || rhsType instanceof PsiPrimitiveType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expressionIsArrayCopy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ManualArrayCopyFix
    extends PsiUpdateModCommandQuickFix {
        private ManualArrayCopyFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"System.arraycopy()"});
            if (string == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement forElement, @NotNull ModPsiUpdater updater) {
            CommentTracker commentTracker;
            PsiForStatement forStatement;
            String newExpression;
            if (project == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(1);
            }
            if (forElement == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(3);
            }
            if ((newExpression = ManualArrayCopyFix.buildSystemArrayCopyText(forStatement = (PsiForStatement)forElement.getParent(), commentTracker = new CommentTracker())) == null) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)commentTracker.replaceAndRestoreComments((PsiElement)forStatement, newExpression);
            if (Boolean.TRUE.equals(DfaUtil.evaluateCondition(ifStatement.getCondition()))) {
                PsiStatement copyStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                assert (copyStatement != null);
                new CommentTracker().replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)copyStatement);
            }
        }

        @Nullable
        @NonNls
        private static String buildSystemArrayCopyText(PsiForStatement forStatement, CommentTracker commentTracker) {
            String lengthText;
            CountingLoop countingLoop = CountingLoop.from(forStatement);
            if (countingLoop == null) {
                return null;
            }
            PsiExpression limit = countingLoop.getBound();
            PsiExpression initializer = countingLoop.getInitializer();
            String string = lengthText = countingLoop.isDescending() ? ManualArrayCopyFix.buildLengthText(initializer, limit, countingLoop.isIncluding(), commentTracker) : ManualArrayCopyFix.buildLengthText(limit, initializer, countingLoop.isIncluding(), commentTracker);
            if (lengthText == null) {
                return null;
            }
            PsiArrayAccessExpression lhs = ManualArrayCopyFix.getLhsArrayAccessExpression(forStatement);
            if (lhs == null) {
                return null;
            }
            PsiExpression lArray = lhs.getArrayExpression();
            String toArrayText = commentTracker.text((PsiElement)lArray);
            PsiArrayAccessExpression rhs = ManualArrayCopyFix.getRhsArrayAccessExpression(forStatement);
            if (rhs == null) {
                return null;
            }
            PsiExpression rArray = rhs.getArrayExpression();
            String fromArrayText = commentTracker.text((PsiElement)rArray);
            PsiExpression rhsIndexExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs.getIndexExpression());
            PsiExpression limitExpression = countingLoop.isDescending() ? limit : initializer;
            String fromOffsetText = ManualArrayCopyFix.buildOffsetText(rhsIndexExpression, countingLoop.getCounter(), limitExpression, countingLoop.isDescending() && !countingLoop.isIncluding(), commentTracker);
            PsiExpression lhsIndexExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs.getIndexExpression());
            String toOffsetText = ManualArrayCopyFix.buildOffsetText(lhsIndexExpression, countingLoop.getCounter(), limitExpression, countingLoop.isDescending() && !countingLoop.isIncluding(), commentTracker);
            return "if(" + lengthText + ">=0)System.arraycopy(" + fromArrayText + "," + fromOffsetText + "," + toArrayText + "," + toOffsetText + "," + lengthText + ");";
        }

        @Nullable
        private static PsiArrayAccessExpression getLhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression deparenthesizedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs);
            if (!(deparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)deparenthesizedExpression;
        }

        @Nullable
        private static PsiArrayAccessExpression getRhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiExpression arrayAccessExpression;
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1 || statements.length == 2) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (body instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                if (declaredElements.length != 1) {
                    return null;
                }
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                arrayAccessExpression = variable.getInitializer();
            } else if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return null;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                arrayAccessExpression = assignmentExpression.getRExpression();
            } else {
                return null;
            }
            PsiExpression unparenthesizedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arrayAccessExpression);
            if (!(unparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)unparenthesizedExpression;
        }

        @NonNls
        @Nullable
        private static String buildLengthText(PsiExpression max, PsiExpression min, boolean plusOne, CommentTracker commentTracker) {
            if ((max = PsiUtil.skipParenthesizedExprDown((PsiExpression)max)) == null) {
                return null;
            }
            if ((min = PsiUtil.skipParenthesizedExprDown((PsiExpression)min)) == null) {
                return ManualArrayCopyFix.buildExpressionText(max, plusOne, commentTracker);
            }
            Object minConstant = ExpressionUtils.computeConstantExpression(min);
            if (minConstant instanceof Number) {
                Object maxConstant;
                int minValue;
                Number minNumber = (Number)minConstant;
                int n = minValue = plusOne ? minNumber.intValue() - 1 : minNumber.intValue();
                if (minValue == 0) {
                    return ManualArrayCopyFix.buildExpressionText(max, false, commentTracker);
                }
                if (max instanceof PsiLiteralExpression && (maxConstant = ExpressionUtils.computeConstantExpression(max)) instanceof Number) {
                    Number number = (Number)maxConstant;
                    return String.valueOf(number.intValue() - minValue);
                }
                String maxText = ManualArrayCopyFix.buildExpressionText(max, false, commentTracker);
                return minValue > 0 ? maxText + "-" + minValue : maxText + "+" + -minValue;
            }
            String minText = commentTracker.text(min, 5);
            String maxText = ManualArrayCopyFix.buildExpressionText(max, plusOne, commentTracker);
            return maxText + "-" + minText;
        }

        private static String buildExpressionText(PsiExpression expression, boolean plusOne, CommentTracker commentTracker) {
            return plusOne ? JavaPsiMathUtil.add(expression, 1, commentTracker) : commentTracker.text(expression, 6);
        }

        @NonNls
        @Nullable
        private static String buildOffsetText(PsiExpression expression, PsiLocalVariable variable, PsiExpression limitExpression, boolean plusOne, CommentTracker commentTracker) {
            String variableName;
            if (expression == null) {
                return null;
            }
            String expressionText = commentTracker.text((PsiElement)expression);
            if (expressionText.equals(variableName = variable.getName())) {
                PsiExpression initialValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)limitExpression);
                if (initialValue == null) {
                    return null;
                }
                return ManualArrayCopyFix.buildExpressionText(initialValue, plusOne, commentTracker);
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayCopyFix.buildOffsetText(rhs, variable, limitExpression, plusOne, commentTracker);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    return tokenType.equals(JavaTokenType.MINUS) ? "-" + rhsText : rhsText;
                }
                if (plusOne && tokenType.equals(JavaTokenType.MINUS) && ExpressionUtils.isOne(rhs)) {
                    return ManualArrayCopyFix.buildOffsetText(lhs, variable, limitExpression, false, commentTracker);
                }
                String lhsText = ManualArrayCopyFix.buildOffsetText(lhs, variable, limitExpression, plusOne, commentTracker);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayCopyFix.collapseConstant(lhsText + sign.getText() + rhsText, (PsiElement)variable);
            }
            return ManualArrayCopyFix.collapseConstant(commentTracker.text((PsiElement)expression), (PsiElement)variable);
        }

        private static String collapseConstant(@NonNls String expressionText, PsiElement context) {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            Object fromOffsetConstant = ExpressionUtils.computeConstantExpression(fromOffsetExpression);
            if (fromOffsetConstant != null) {
                return fromOffsetConstant.toString();
            }
            return expressionText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

