/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ManualArrayToCollectionCopyInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            ManualArrayToCollectionCopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ManualArrayToCollectionCopyFix();
    }

    static PsiArrayAccessExpression getArrayAccessExpression(PsiForStatement forStatement) {
        PsiExpression arrayAccessExpression;
        PsiStatement body = ManualArrayToCollectionCopyInspection.getBody((PsiLoopStatement)forStatement);
        if (body == null) {
            return null;
        }
        if (body instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            arrayAccessExpression = expressions.length == 0 ? null : expressions[0];
        } else if (body instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            arrayAccessExpression = variable.getInitializer();
        } else {
            return null;
        }
        PsiExpression deparenthesizedArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arrayAccessExpression);
        if (!(deparenthesizedArgument instanceof PsiArrayAccessExpression)) {
            return null;
        }
        return (PsiArrayAccessExpression)deparenthesizedArgument;
    }

    @Nullable
    private static PsiStatement getBody(PsiLoopStatement forStatement) {
        PsiStatement body = forStatement.getBody();
        while (body instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            body = statements.length == 0 ? null : statements[0];
        }
        return body;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayToCollectionCopyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection", "buildErrorString"));
    }

    private static class ManualArrayToCollectionCopyFix
    extends PsiUpdateModCommandQuickFix {
        private ManualArrayToCollectionCopyFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Collections.addAll(...,...)"});
            if (string == null) {
                ManualArrayToCollectionCopyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ManualArrayToCollectionCopyFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ManualArrayToCollectionCopyFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ManualArrayToCollectionCopyFix.$$$reportNull$$$0(3);
            }
            PsiLoopStatement loop = (PsiLoopStatement)ObjectUtils.tryCast((Object)startElement.getParent(), PsiLoopStatement.class);
            String newExpression = null;
            if (loop instanceof PsiForStatement) {
                newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText((PsiForStatement)loop);
            } else if (loop instanceof PsiForeachStatement) {
                newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText((PsiForeachStatement)loop);
            }
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)loop, newExpression);
        }

        @Nullable
        @NonNls
        private static String getCollectionsAddAllText(PsiForeachStatement foreachStatement) {
            PsiStatement body = ManualArrayToCollectionCopyInspection.getBody((PsiLoopStatement)foreachStatement);
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expressionStatement.getExpression();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression collection = ExpressionUtils.getEffectiveQualifier(methodExpression);
            if (collection == null) {
                return null;
            }
            PsiExpression iteratedValue = foreachStatement.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            String arrayText = iteratedValue.getText();
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)foreachStatement)) {
                return "java.util.Collections.addAll(" + collection.getText() + "," + arrayText + ");";
            }
            String collectionText = ParenthesesUtils.getText(collection, 2);
            return collectionText + ".addAll(java.util.Arrays.asList(" + arrayText + "));";
        }

        @Nullable
        @NonNls
        private static String getCollectionsAddAllText(PsiForStatement forStatement) {
            PsiExpression expression = forStatement.getCondition();
            PsiBinaryExpression condition = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiBinaryExpression.class);
            if (condition == null) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forStatement.getInitialization(), PsiDeclarationStatement.class);
            if (declaration == null) {
                return null;
            }
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
            if (variable == null) {
                return null;
            }
            String collectionText = ManualArrayToCollectionCopyFix.buildCollectionText(forStatement);
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(forStatement);
            if (arrayAccessExpression == null) {
                return null;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String arrayText = arrayExpression.getText();
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            String indexOffset = ManualArrayToCollectionCopyFix.getIndexOffset(indexExpression, variable);
            if (indexOffset == null) {
                return null;
            }
            String fromOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(variable.getInitializer(), indexOffset, false);
            if (fromOffsetText == null) {
                return null;
            }
            IElementType tokenType = condition.getOperationTokenType();
            PsiExpression limit = tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE ? condition.getROperand() : condition.getLOperand();
            String toOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(limit, indexOffset, tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GE);
            if (toOffsetText == null) {
                return null;
            }
            if (fromOffsetText.equals("0") && toOffsetText.equals(arrayText + ".length") && PsiUtil.isLanguageLevel5OrHigher((PsiElement)forStatement)) {
                return "java.util.Collections.addAll(" + collectionText + "," + arrayText + ");";
            }
            @NonNls StringBuilder buffer = new StringBuilder();
            buffer.append(collectionText);
            buffer.append('.');
            buffer.append("addAll(java.util.Arrays.asList(");
            buffer.append(arrayText);
            buffer.append(')');
            if (!fromOffsetText.equals("0") || !toOffsetText.equals(arrayText + ".length")) {
                buffer.append(".subList(");
                buffer.append(fromOffsetText);
                buffer.append(", ");
                buffer.append(toOffsetText);
                buffer.append(')');
            }
            buffer.append(");");
            return buffer.toString();
        }

        public static String buildCollectionText(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpressionStatement)body).getExpression());
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
            return qualifier != null ? qualifier.getText() : null;
        }

        @Nullable
        private static String getIndexOffset(PsiExpression expression, PsiLocalVariable variable) {
            String variableName;
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
                return null;
            }
            if (ExpressionUtils.isZero(expression)) {
                return "0";
            }
            String expressionText = expression.getText();
            if (expressionText.equals(variableName = variable.getName())) {
                return "0";
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayToCollectionCopyFix.getIndexOffset(rhs, variable);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return "-" + rhsText;
                    }
                    return rhsText;
                }
                String lhsText = ManualArrayToCollectionCopyFix.getIndexOffset(lhs, variable);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayToCollectionCopyFix.collapseConstant(lhsText + " " + sign.getText() + " " + rhsText, (PsiElement)variable);
            }
            return ManualArrayToCollectionCopyFix.collapseConstant(expressionText, (PsiElement)variable);
        }

        private static String addIndexOffset(PsiExpression expression, String indexOffset, boolean plusOne) {
            if (expression == null) {
                return null;
            }
            if (plusOne) {
                indexOffset = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") + 1", (PsiElement)expression);
            }
            String expressionText = expression.getText();
            if ("0".equals(indexOffset)) {
                return expressionText;
            }
            if (expression instanceof PsiBinaryExpression) {
                Object lhConstant;
                Object rhConstant;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (tokenType == JavaTokenType.PLUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant(String.valueOf(rhConstant) + " + (" + indexOffset + ")", (PsiElement)expression);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, (PsiElement)expression);
                }
                if (tokenType == JavaTokenType.MINUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") - " + String.valueOf(rhConstant), (PsiElement)expression);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, (PsiElement)expression);
                }
                if (rhs != null && (tokenType == JavaTokenType.PLUS || tokenType == JavaTokenType.MINUS) && (lhConstant = ExpressionUtils.computeConstantExpression(lhs)) != null) {
                    String lhText = ManualArrayToCollectionCopyFix.collapseConstant(String.valueOf(lhConstant) + " + (" + indexOffset + ")", (PsiElement)expression);
                    if ("0".equals(lhText)) {
                        return tokenType == JavaTokenType.MINUS ? "-" + rhs.getText() : rhs.getText();
                    }
                    return lhText + (tokenType == JavaTokenType.MINUS ? " - " : " + ") + rhs.getText();
                }
            }
            String addendum = ManualArrayToCollectionCopyFix.getAddendum(indexOffset, (PsiElement)expression);
            int precedence = ParenthesesUtils.getPrecedence(expression);
            String text = precedence > 6 ? "(" + expressionText + ")" + addendum : expressionText + addendum;
            return ManualArrayToCollectionCopyFix.collapseConstant(text, (PsiElement)expression);
        }

        private static String getAddendum(String expressionText, PsiElement context) {
            if (expressionText.startsWith("-")) {
                String negatedExpressionText = expressionText.substring(1);
                Object lhConstant = ManualArrayToCollectionCopyFix.computeConstant(negatedExpressionText, context);
                if (lhConstant != null) {
                    return " - " + lhConstant.toString();
                }
                return " + (" + expressionText + ")";
            }
            return " + " + expressionText;
        }

        private static String collapseConstant(String expressionText, PsiElement context) {
            Object fromOffsetConstant = ManualArrayToCollectionCopyFix.computeConstant(expressionText, context);
            return fromOffsetConstant != null ? fromOffsetConstant.toString() : expressionText;
        }

        private static Object computeConstant(String expressionText, PsiElement context) {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            return ExpressionUtils.computeConstantExpression(fromOffsetExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ManualArrayToCollectionCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayToCollectionCopyVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ManualArrayToCollectionCopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            PsiStatement initialization = statement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (!ExpressionUtils.isVariableLessThanComparison(condition, (PsiVariable)variable)) {
                return;
            }
            PsiStatement update = statement.getUpdate();
            if (!VariableAccessUtils.variableIsIncremented((PsiVariable)variable, update)) {
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(statement);
            if (arrayAccessExpression == null) {
                return;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type = arrayExpression.getType();
            if (!(type instanceof PsiArrayType) || type.getDeepComponentType() instanceof PsiPrimitiveType) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, (PsiVariable)variable, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                ManualArrayToCollectionCopyVisitor.$$$reportNull$$$0(1);
            }
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType type = iteratedValue.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, (PsiVariable)parameter, false)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean bodyIsArrayToCollectionCopy(PsiStatement body, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression = expressionStatement.getExpression();
                return ManualArrayToCollectionCopyVisitor.expressionIsArrayToCollectionCopy(expression, variable, shouldBeOffsetArrayAccess);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[0], variable, shouldBeOffsetArrayAccess);
                }
                if (statements.length == 2) {
                    PsiStatement statement = statements[0];
                    if (!(statement instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer, variable)) {
                        return false;
                    }
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[1], localVariable, false);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayToCollectionCopy(PsiExpression expression, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
                return false;
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)qualifier)) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType instanceof PsiPrimitiveType) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(argument)) {
                return false;
            }
            if (shouldBeOffsetArrayAccess ? !ExpressionUtils.isOffsetArrayAccess(argument, variable) : !ExpressionUtils.isReferenceTo(argument, variable)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            @NonNls String name = method.getName();
            if (!name.equals("add")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

