/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public final class ObjectAllocationInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Kind kind = (Kind)((Object)infos[0]);
        String string = kind.toString();
        if (string == null) {
            ObjectAllocationInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectAllocationInLoopsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectAllocationInLoopInspection", "buildErrorString"));
    }

    static enum Kind {
        NEW_OPERATOR("object.allocation.in.loop.new.descriptor"),
        METHOD_CALL("object.allocation.in.loop.problem.call.descriptor"),
        METHOD_REFERENCE("object.allocation.in.loop.problem.methodref.descriptor"),
        CAPTURING_LAMBDA("object.allocation.in.loop.problem.lambda.descriptor"),
        STRING_CONCAT("object.allocation.in.loop.problem.string.concat"),
        ARRAY_INITIALIZER("object.allocation.in.loop.problem.array.initializer.descriptor");

        @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle")
        private final @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle") String myMessage;

        private Kind(String message) {
            this.myMessage = message;
        }

        @InspectionMessage
        public String toString() {
            return InspectionGadgetsBundle.message(this.myMessage, new Object[0]);
        }
    }

    private static class ObjectAllocationInLoopsVisitor
    extends BaseInspectionVisitor {
        private ObjectAllocationInLoopsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                List<StandardMethodContract> contracts = JavaMethodContractUtil.getMethodContracts(method);
                ContractReturnValue value = JavaMethodContractUtil.getNonFailingReturnValue(contracts);
                if (ContractReturnValue.returnNew().equals(value) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)call)) {
                    this.registerMethodCallError(call, new Object[]{Kind.METHOD_CALL});
                }
            }
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
            if (expression == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(1);
            }
            if (!(expression.getParent() instanceof PsiNewExpression) && !(expression.getParent() instanceof PsiArrayInitializerExpression) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression)) {
                this.registerError((PsiElement)expression, new Object[]{Kind.ARRAY_INITIALIZER});
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(2);
            }
            super.visitMethodReferenceExpression(expression);
            if (!PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression)) {
                this.registerError((PsiElement)expression, new Object[]{Kind.METHOD_REFERENCE});
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
            if (lambda == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(3);
            }
            super.visitLambdaExpression(lambda);
            if (ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)lambda) && LambdaUtil.isCapturingLambda((PsiLambdaExpression)lambda)) {
                this.registerError((PsiElement)lambda.getParameterList(), new Object[]{Kind.CAPTURING_LAMBDA});
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(4);
            }
            super.visitNewExpression(expression);
            if (ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression)) {
                this.registerNewExpressionError(expression, new Object[]{expression.isArrayCreation() ? Kind.ARRAY_INITIALIZER : Kind.NEW_OPERATOR});
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            IElementType type;
            if (expression == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(5);
            }
            if (JavaTokenType.PLUS.equals(type = expression.getOperationTokenType()) && TypeUtils.isJavaLangString(expression.getType()) && !PsiUtil.isConstantExpression((PsiExpression)expression) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression)) {
                this.registerError((PsiElement)expression, new Object[]{Kind.STRING_CONCAT});
            }
            super.visitPolyadicExpression(expression);
        }

        private static boolean isPerformedRepeatedlyInLoop(@NotNull PsiExpression expression) {
            if (expression == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(6);
            }
            if (!ControlFlowUtils.isInLoop((PsiElement)expression)) {
                return false;
            }
            if (ControlFlowUtils.isInExitStatement(expression)) {
                return false;
            }
            PsiStatement newExpressionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
            if (newExpressionStatement == null) {
                return false;
            }
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            if (!ControlFlowUtils.statementMayCompleteNormally(parentStatement)) {
                return false;
            }
            return !ObjectAllocationInLoopsVisitor.isAllocatedOnlyOnce(expression);
        }

        private static boolean isAllocatedOnlyOnce(PsiExpression expression) {
            boolean equals;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssignmentExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (assignment == null) {
                return false;
            }
            PsiReferenceExpression assignedRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (assignedRef == null) {
                return false;
            }
            if (assignment.getRExpression() != expression && NullabilityUtil.getExpressionNullability(assignment.getRExpression()) != Nullability.NOT_NULL) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)assignment, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = true;
            } else if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = false;
            } else {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            PsiReferenceExpression nullCheckedRef = ExpressionUtils.getReferenceExpressionFromNullComparison(condition, equals);
            return nullCheckedRef != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullCheckedRef, (PsiElement)assignedRef);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/ObjectAllocationInLoopInspection$ObjectAllocationInLoopsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPerformedRepeatedlyInLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

