/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringConcatenationInLoopsInspection
extends BaseInspection {
    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "StringConcatenationInLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    private static PsiLoopStatement getOutermostCommonLoop(@NotNull PsiExpression expression, @NotNull PsiVariable variable) {
        Object ref;
        if (expression == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(1);
        }
        if (variable == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(2);
        }
        PsiElement stopAt = null;
        PsiCodeBlock block = StringConcatenationInLoopsVisitor.getSurroundingBlock((PsiElement)expression);
        if (block != null && (ref = expression instanceof PsiAssignmentExpression ? expression : (PsiElement)ContainerUtil.getFirstItem(VariableAccessUtils.getVariableReferences(variable))) != null) {
            PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)expression)).prepend((Object)expression).toArray(PsiElement[]::new);
            stopAt = PsiTreeUtil.findCommonParent((PsiElement[])elements);
        }
        PsiLoopStatement commonLoop = null;
        for (PsiElement parent = expression.getParent(); !(parent == null || parent == stopAt || parent instanceof PsiMethod || parent instanceof PsiClass || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            if (!(parent instanceof PsiLoopStatement)) continue;
            commonLoop = (PsiLoopStatement)parent;
        }
        return commonLoop;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getAppendedVariable(PsiExpression expression) {
        PsiReferenceExpression lhs = StringConcatenationInLoopsInspection.getAppendedExpression(expression);
        if (lhs == null) {
            return null;
        }
        return (PsiVariable)ObjectUtils.tryCast((Object)lhs.resolve(), PsiVariable.class);
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiReferenceExpression getAppendedExpression(PsiExpression expression) {
        PsiExpression parent = expression;
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getLExpression()), PsiReferenceExpression.class);
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        PsiExpression expression = (PsiExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])infos), PsiExpression.class);
        PsiVariable var = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
        if (var == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                StringConcatenationInLoopsInspection.$$$reportNull$$$0(3);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        boolean needNullSafe = StringConcatenationInLoopsInspection.canBeNull(var);
        ArrayList<PsiUpdateModCommandQuickFix> fixes = new ArrayList<PsiUpdateModCommandQuickFix>();
        if (var instanceof PsiLocalVariable) {
            fixes.add(new ReplaceWithStringBuilderFix(var, false));
            if (needNullSafe) {
                fixes.add(new ReplaceWithStringBuilderFix(var, true));
            }
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, var);
            if (VariableAccessUtils.getVariableReferences(var).stream().filter(e -> !PsiTreeUtil.isAncestor((PsiElement)loop, (PsiElement)e, (boolean)true)).limit(2L).count() > 1L) {
                fixes.add(new IntroduceStringBuilderFix(var, false));
                if (needNullSafe) {
                    fixes.add(new IntroduceStringBuilderFix(var, true));
                }
            }
        } else if (var instanceof PsiParameter) {
            fixes.add(new IntroduceStringBuilderFix(var, false));
            if (needNullSafe) {
                fixes.add(new IntroduceStringBuilderFix(var, true));
            }
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static boolean canBeNull(PsiVariable var) {
        PsiExpression initializer = var.getInitializer();
        if (initializer != null && NullabilityUtil.getExpressionNullability(initializer, true) != Nullability.NOT_NULL) {
            return true;
        }
        Predicate<PsiReference> isPossiblyNullableWrite = ref -> {
            if (!(ref instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expression = (PsiExpression)ref;
            if (!PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssignmentExpression.class);
            if (assignment == null || assignment.getOperationTokenType() != JavaTokenType.EQ) {
                return false;
            }
            PsiExpression rExpression = assignment.getRExpression();
            return rExpression != null && NullabilityUtil.getExpressionNullability(rExpression, true) != Nullability.NOT_NULL;
        };
        return ReferencesSearch.search((PsiElement)var).anyMatch(isPossiblyNullableWrite);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostCommonLoop";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                StringConcatenationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            PsiExpression[] operands = expression.getOperands();
            if (operands.length <= 1) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression((PsiExpression)expression)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.isAppendedRepeatedly((PsiExpression)expression)) {
                return;
            }
            PsiJavaToken sign = expression.getTokenBeforeOperand(operands[1]);
            assert (sign != null);
            this.registerError((PsiElement)sign, expression);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                StringConcatenationInLoopsVisitor.$$$reportNull$$$0(1);
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)sign, expression);
        }

        private static boolean checkExpression(PsiExpression expression) {
            if (!TypeUtils.isJavaLangString(expression.getType()) || ControlFlowUtils.isInExitStatement(expression) || !ControlFlowUtils.isInLoop((PsiElement)expression)) {
                return false;
            }
            PsiExpression parent = expression;
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (parent != expression && parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                return false;
            }
            if (parent instanceof PsiAssignmentExpression) {
                expression = parent;
                PsiReferenceExpression lhs = StringConcatenationInLoopsInspection.getAppendedExpression(expression);
                if (lhs == null) {
                    return false;
                }
                PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)lhs.resolve(), PsiVariable.class);
                if (variable != null) {
                    PsiLoopStatement commonLoop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, variable);
                    return commonLoop != null && !ControlFlowUtils.isExecutedOnceInLoop((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class), commonLoop) && !StringConcatenationInLoopsVisitor.isUsedCompletely(variable, commonLoop) && StringConcatenationInLoopsVisitor.checkQualifier(lhs, commonLoop);
                }
            }
            return false;
        }

        private static boolean checkQualifier(PsiReferenceExpression lhs, PsiLoopStatement commonLoop) {
            PsiExpression qualifierExpression;
            while ((qualifierExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs.getQualifierExpression())) != null && !(qualifierExpression instanceof PsiQualifiedExpression)) {
                PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression, PsiReferenceExpression.class);
                if (ref == null) {
                    return false;
                }
                PsiVariable varRef = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
                if (varRef == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)commonLoop, (PsiElement)varRef, (boolean)true) || VariableAccessUtils.variableIsAssigned(varRef, (PsiElement)commonLoop)) {
                    return false;
                }
                lhs = ref;
            }
            return true;
        }

        private static boolean isUsedCompletely(PsiVariable variable, PsiLoopStatement loop) {
            return ContainerUtil.exists(VariableAccessUtils.getVariableReferences(variable, (PsiElement)loop), expression -> {
                PsiElement parent = ExpressionUtils.getPassThroughParent((PsiExpression)expression);
                if (parent instanceof PsiExpressionList || parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiAssignmentExpression)parent).getRExpression(), (PsiElement)expression, (boolean)false)) {
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class);
                    return !ControlFlowUtils.isExecutedOnceInLoop(statement, loop) && !ControlFlowUtils.isVariableReassigned(statement, variable);
                }
                return false;
            });
        }

        @Nullable
        private static PsiCodeBlock getSurroundingBlock(PsiElement expression) {
            PsiElement body;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class});
            if (parent instanceof PsiMethod) {
                return ((PsiMethod)parent).getBody();
            }
            if (parent instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)parent).getBody();
            }
            if (parent instanceof PsiLambdaExpression && (body = ((PsiLambdaExpression)parent).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)body;
            }
            return null;
        }

        private static boolean isAppendedRepeatedly(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            return StringConcatenationInLoopsVisitor.isAppended(referenceExpression, rhs);
        }

        private static boolean isAppended(PsiReferenceExpression otherRef, PsiExpression expression) {
            PsiPolyadicExpression polyadicExpression;
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!StringConcatenationInLoopsVisitor.isSameReference(operand, otherRef) && !StringConcatenationInLoopsVisitor.isAppended(otherRef, operand)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSameReference(PsiExpression operand, PsiReferenceExpression ref) {
            PsiReferenceExpression other = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand), PsiReferenceExpression.class);
            if (other == null) {
                return false;
            }
            String name = other.getReferenceName();
            if (name == null || !name.equals(ref.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = ref.getQualifierExpression();
            PsiExpression otherQualifier = other.getQualifierExpression();
            if (qualifier == null && otherQualifier == null) {
                return true;
            }
            if (qualifier == null && ref.resolve() instanceof PsiField) {
                qualifier = ExpressionUtils.getEffectiveQualifier(ref);
            }
            if (otherQualifier == null && other.resolve() instanceof PsiField) {
                otherQualifier = ExpressionUtils.getEffectiveQualifier(other);
            }
            if (qualifier == null || otherQualifier == null) {
                return false;
            }
            if (qualifier instanceof PsiReferenceExpression) {
                return StringConcatenationInLoopsVisitor.isSameReference(otherQualifier, (PsiReferenceExpression)qualifier);
            }
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)otherQualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReplaceWithStringBuilderFix
    extends PsiUpdateModCommandQuickFix {
        final String myName;
        final String myTargetType;
        final boolean myNullSafe;

        ReplaceWithStringBuilderFix(@NotNull PsiVariable variable, boolean nullSafe) {
            if (variable == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(0);
            }
            this.myName = variable.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable) ? "java.lang.StringBuilder" : "java.lang.StringBuffer";
            this.myNullSafe = nullSafe;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiStatement commentPlace;
            PsiExpression expression;
            if (project == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class)) == null) {
                return;
            }
            PsiVariable psiVariable = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
            if (!(psiVariable instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)psiVariable;
            variable.normalizeDeclaration();
            PsiTypeElement typeElement = variable.getTypeElement();
            CommentTracker ct = new CommentTracker();
            StringBuilderReplacer replacer = new StringBuilderReplacer(this.myTargetType, this.myNullSafe);
            replacer.replaceAll((PsiVariable)variable, (PsiVariable)variable, null, ct);
            ct.replace((PsiElement)typeElement, this.myTargetType);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(ct.replace((PsiElement)initializer, replacer.generateNewStringBuilder(initializer, ct)));
            }
            ct.insertCommentsBefore((PsiElement)((commentPlace = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class)) == null ? variable : commentPlace));
        }

        @Nls
        @NotNull
        public String getName() {
            String introduce = StringUtil.getShortName((String)this.myTargetType);
            if (this.myNullSafe) {
                String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name.null.safe", this.myName, introduce);
                if (string == null) {
                    ReplaceWithStringBuilderFix.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name", this.myName, introduce);
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix", new Object[0]);
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    static class IntroduceStringBuilderFix
    extends PsiUpdateModCommandQuickFix {
        final String myName;
        final String myTargetType;
        final boolean myNullSafe;

        IntroduceStringBuilderFix(@NotNull PsiVariable variable, boolean nullSafe) {
            if (variable == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(0);
            }
            this.myName = variable.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable) ? "java.lang.StringBuilder" : "java.lang.StringBuffer";
            this.myNullSafe = nullSafe;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            if (project == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class)) == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression);
            if (variable == null) {
                return;
            }
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression, variable);
            if (loop == null) {
                return;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(variable, (PsiStatement)loop);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String newName = javaCodeStyleManager.suggestUniqueVariableName(variable.getName() + "Builder", (PsiElement)loop, true);
            String newStringBuilder = this.myTargetType + " " + newName + "=new " + this.myTargetType + "(" + variable.getName() + ");";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)loop, (Object)marker);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)BlockUtils.addBefore((PsiStatement)loop, (PsiStatement[])new PsiStatement[]{factory.createStatementFromText(newStringBuilder, (PsiElement)loop)});
            if (!loop.isValid() && (loop = (PsiLoopStatement)PsiTreeUtil.releaseMark((PsiElement)declaration.getParent(), (Object)marker)) == null) {
                return;
            }
            PsiVariable builderVariable = (PsiVariable)declaration.getDeclaredElements()[0];
            PsiExpression builderInitializer = Objects.requireNonNull(builderVariable.getInitializer());
            CommentTracker ct = new CommentTracker();
            StringBuilderReplacer replacer = new StringBuilderReplacer(this.myTargetType, this.myNullSafe);
            replacer.replaceAll(variable, builderVariable, (PsiElement)loop, ct);
            String convertToString = this.myNullSafe ? "java.lang.String.valueOf(" + newName + ")" : newName + ".toString()";
            @NonNls Object toString = variable.getName() + " = " + convertToString + ";";
            PsiExpression initializer = variable.getInitializer();
            switch (status) {
                case DECLARED_JUST_BEFORE: {
                    PsiTypeElement typeElement = variable.getTypeElement();
                    if (typeElement == null || initializer == null) break;
                    javaCodeStyleManager.shortenClassReferences(ct.replace((PsiElement)builderInitializer, replacer.generateNewStringBuilder(initializer, ct)));
                    ct.replace((PsiElement)initializer, convertToString);
                    toString = variable.getText();
                    ct.delete((PsiElement)variable);
                    break;
                }
                case AT_WANTED_PLACE_ONLY: {
                    if (initializer == null) break;
                    javaCodeStyleManager.shortenClassReferences(ct.replace((PsiElement)builderInitializer, replacer.generateNewStringBuilder(initializer, ct)));
                    initializer.delete();
                    break;
                }
                case AT_WANTED_PLACE: {
                    if (!ExpressionUtils.isSafelyRecomputableExpression(initializer)) break;
                    javaCodeStyleManager.shortenClassReferences(ct.replace((PsiElement)builderInitializer, replacer.generateNewStringBuilder(initializer, ct)));
                    break;
                }
                case UNKNOWN: {
                    PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)declaration);
                    PsiExpression prevAssignment = ExpressionUtils.getAssignmentTo(prevStatement, variable);
                    if (prevAssignment == null) break;
                    javaCodeStyleManager.shortenClassReferences(ct.replace((PsiElement)builderInitializer, replacer.generateNewStringBuilder(prevAssignment, ct)));
                    ct.delete(prevStatement);
                }
            }
            BlockUtils.addAfter((PsiStatement)loop, (PsiStatement)factory.createStatementFromText((String)toString, (PsiElement)loop));
            ct.insertCommentsBefore((PsiElement)loop);
        }

        @Nls
        @NotNull
        public String getName() {
            String introduce = StringUtil.getShortName((String)this.myTargetType);
            if (this.myNullSafe) {
                String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix.name.null.safe", this.myName, introduce);
                if (string == null) {
                    IntroduceStringBuilderFix.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix.name", this.myName, introduce);
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix", new Object[0]);
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class StringBuilderReplacer {
        static final Pattern PRINT_OR_PRINTLN = Pattern.compile("print|println");
        Set<PsiExpression> myNullables = Collections.emptySet();
        final String myTargetType;
        final boolean myNullSafe;

        private StringBuilderReplacer(String type, boolean safe) {
            this.myTargetType = type;
            this.myNullSafe = safe;
        }

        @NonNls
        @NotNull
        String generateNewStringBuilder(PsiExpression initializer, CommentTracker ct) {
            if (ExpressionUtils.isNullLiteral(initializer)) {
                String string = ct.text((PsiElement)initializer);
                if (string == null) {
                    StringBuilderReplacer.$$$reportNull$$$0(0);
                }
                return string;
            }
            String text = initializer == null || ExpressionUtils.isLiteral((PsiElement)initializer, "") ? "" : ct.text((PsiElement)initializer);
            String stringBuilderText = "new " + this.myTargetType + "(" + text + ")";
            if (this.myNullables.contains(initializer)) {
                if (ExpressionUtils.isSafelyRecomputableExpression(initializer)) {
                    String string = initializer.getText() + "==null?null:" + stringBuilderText;
                    if (string == null) {
                        StringBuilderReplacer.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                if (PsiUtil.isAvailable((JavaFeature)JavaFeature.STREAM_OPTIONAL, (PsiElement)initializer)) {
                    String string = "java.util.Optional.ofNullable(" + initializer.getText() + ").map(" + this.myTargetType + "::new).orElse(null)";
                    if (string == null) {
                        StringBuilderReplacer.$$$reportNull$$$0(2);
                    }
                    return string;
                }
            }
            String string = stringBuilderText;
            if (string == null) {
                StringBuilderReplacer.$$$reportNull$$$0(3);
            }
            return string;
        }

        void replaceAll(PsiVariable variable, PsiVariable builderVariable, PsiElement scope, CommentTracker ct) {
            this.replaceAll(variable, builderVariable, scope, ct, ref -> false);
        }

        void replaceAll(PsiVariable variable, PsiVariable builderVariable, PsiElement scope, CommentTracker ct, Predicate<? super PsiReferenceExpression> skip) {
            if (scope == null) {
                scope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            }
            List<PsiReferenceExpression> refs = VariableAccessUtils.getVariableReferences(variable, scope);
            if (this.myNullSafe) {
                this.fillNullables(variable, refs);
            }
            for (PsiReferenceExpression target : refs) {
                if (!target.isValid() || skip.test((PsiReferenceExpression)target)) continue;
                this.replace(variable, builderVariable, target, ct);
            }
        }

        private void fillNullables(PsiVariable variable, Collection<PsiReferenceExpression> refs) {
            if (this.myNullables instanceof HashSet) {
                return;
            }
            this.myNullables = new HashSet<PsiExpression>();
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && NullabilityUtil.getExpressionNullability(initializer, true) != Nullability.NOT_NULL) {
                this.myNullables.add(initializer);
            }
            for (PsiReferenceExpression refExpr : refs) {
                PsiExpression rExpr;
                if (NullabilityUtil.getExpressionNullability((PsiExpression)refExpr, true) != Nullability.NOT_NULL) {
                    this.myNullables.add((PsiExpression)refExpr);
                }
                if (!PsiUtil.isOnAssignmentLeftHand((PsiExpression)refExpr) || (rExpr = ExpressionUtils.getAssignmentTo(PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiAssignmentExpression.class), variable)) == null || NullabilityUtil.getExpressionNullability(rExpr, true) == Nullability.NOT_NULL) continue;
                this.myNullables.add(rExpr);
            }
        }

        private void replace(PsiVariable variable, PsiVariable builderVariable, PsiReferenceExpression ref, CommentTracker ct) {
            PsiBinaryExpression binOp;
            PsiMethodCallExpression call;
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()) == ref) {
                    this.replaceInAssignment(variable, builderVariable, assignment, ct);
                    return;
                }
                if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                    return;
                }
            }
            if (variable != builderVariable) {
                ExpressionUtils.bindReferenceTo(ref, Objects.requireNonNull(builderVariable.getName()));
            }
            if ((methodCallExpression = ExpressionUtils.getCallForQualifier((PsiExpression)ref)) != null) {
                StringBuilderReplacer.replaceInCallQualifier(builderVariable, methodCallExpression, ct);
                return;
            }
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && (expressions = ((PsiExpressionList)parent).getExpressions()).length == 1 && expressions[0] == ref && StringBuilderReplacer.canAcceptBuilderInsteadOfString(call = (PsiMethodCallExpression)parent.getParent())) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull(binOp = (PsiBinaryExpression)parent) != null) {
                return;
            }
            if (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = ((PsiPolyadicExpression)parent).getOperands()) {
                    if (operand == ref) break;
                    if (!TypeUtils.isJavaLangString(operand.getType())) continue;
                    return;
                }
                if (operands.length > 1 && operands[0] == ref && TypeUtils.isJavaLangString(operands[1].getType())) {
                    return;
                }
            }
            @NonNls String text = builderVariable.getName() + ".toString()";
            if (this.myNullables.contains(ref) && !StringBuilderReplacer.isNotNullContext((PsiExpression)ref)) {
                text = builderVariable.getName() + "==null?null:" + text;
                if (parent instanceof PsiExpression) {
                    text = "(" + text + ")";
                }
            }
            ct.replace((PsiElement)ref, text);
        }

        private static boolean isNotNullContext(PsiExpression ref) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) {
                return false;
            }
            int argIndex = IntStreamEx.ofIndices((Object[])((PsiExpressionList)parent).getExpressions(), arg -> PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)ref, (boolean)false)).findFirst().orElse(-1);
            if (argIndex < 0) {
                return false;
            }
            PsiMethod method = ((PsiMethodCallExpression)parent.getParent()).resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            return parameters.length > argIndex && NullableNotNullManager.isNotNull((PsiModifierListOwner)parameters[argIndex]);
        }

        private static boolean canAcceptBuilderInsteadOfString(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.lang.StringBuilder", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.lang.StringBuffer", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintStream", null, PRINT_OR_PRINTLN, (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintWriter", null, PRINT_OR_PRINTLN, (PsiType[])null);
        }

        private static void replaceInCallQualifier(PsiVariable variable, PsiMethodCallExpression call, CommentTracker ct) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                String name;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name = method.getName()) {
                    case "length": 
                    case "chars": 
                    case "codePoints": 
                    case "charAt": 
                    case "codePointAt": 
                    case "codePointBefore": 
                    case "codePointAfter": 
                    case "codePointCount": 
                    case "offsetByCodePoints": 
                    case "substring": 
                    case "subSequence": {
                        return;
                    }
                    case "getChars": {
                        if (args.length != 4) break;
                        return;
                    }
                    case "indexOf": 
                    case "lastIndexOf": {
                        if (args.length < 1 || args.length > 2 || !TypeUtils.isJavaLangString(args[0].getType())) break;
                        return;
                    }
                    case "isEmpty": {
                        String sign = "==";
                        PsiExpression negation = BoolUtils.findNegation((PsiExpression)call);
                        PsiMethodCallExpression toReplace = call;
                        if (negation != null) {
                            sign = ">";
                            toReplace = negation;
                        }
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
                        PsiExpression emptyCheck = factory.createExpressionFromText(variable.getName() + ".length()" + sign + "0", (PsiElement)call);
                        PsiElement callParent = toReplace.getParent();
                        if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(emptyCheck, (PsiExpression)callParent, true)) {
                            emptyCheck = factory.createExpressionFromText("(" + emptyCheck.getText() + ")", (PsiElement)call);
                        }
                        ct.replace((PsiElement)toReplace, (PsiElement)emptyCheck);
                        return;
                    }
                }
            }
            PsiExpression qualifier = Objects.requireNonNull(call.getMethodExpression().getQualifierExpression());
            ct.replace((PsiElement)qualifier, variable.getName() + ".toString()");
        }

        private void replaceInAssignment(PsiVariable variable, PsiVariable builderVariable, PsiAssignmentExpression assignment, CommentTracker ct) {
            PsiExpression[] operands;
            PsiPolyadicExpression concat;
            PsiExpression rValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
            String builderName = Objects.requireNonNull(builderVariable.getName());
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ) && rValue instanceof PsiPolyadicExpression && (concat = (PsiPolyadicExpression)rValue).getOperationTokenType().equals(JavaTokenType.PLUS) && (operands = concat.getOperands()).length > 1) {
                if (ExpressionUtils.isReferenceTo(operands[0], variable)) {
                    StreamEx.iterate((Object)operands[1], (Predicate)Predicates.nonNull(), PsiElement::getNextSibling).forEach(ct::markUnchanged);
                    this.replaceAll(variable, builderVariable, (PsiElement)rValue, ct, arg_0 -> ((PsiExpression)operands[0]).equals(arg_0));
                    StringBuilder replacement = ChangeToAppendUtil.buildAppendExpression(rValue, false, new StringBuilder(builderName));
                    if (replacement != null) {
                        PsiMethodCallExpression result = (PsiMethodCallExpression)ct.replace((PsiElement)assignment, replacement.toString());
                        PsiMethodCallExpression append = StringBuilderReplacer.getDeepestQualifierCall(result);
                        PsiExpression qualifier = append.getMethodExpression().getQualifierExpression();
                        if (qualifier != null) {
                            append.replace((PsiElement)qualifier);
                        }
                        this.makeNullSafe(operands[0], result);
                    }
                    return;
                }
                PsiExpression lastOp = operands[operands.length - 1];
                if (ExpressionUtils.isReferenceTo(lastOp, variable)) {
                    ct.delete(new PsiElement[]{concat.getTokenBeforeOperand(lastOp), lastOp});
                    this.replaceAll(variable, builderVariable, (PsiElement)rValue, ct);
                    this.makeNullSafe(lastOp, (PsiMethodCallExpression)ct.replace((PsiElement)assignment, builderName + ".insert(0," + ct.text((PsiElement)rValue) + ")"));
                    return;
                }
            }
            if (rValue != null) {
                this.replaceAll(variable, builderVariable, (PsiElement)rValue, ct);
                rValue = assignment.getRExpression();
            }
            if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                StringBuilder sb;
                String replacement = "";
                if (rValue != null && (sb = ChangeToAppendUtil.buildAppendExpression(ct.markUnchanged(rValue), false, new StringBuilder(builderName))) != null) {
                    replacement = sb.toString();
                }
                this.makeNullSafe(assignment.getLExpression(), (PsiMethodCallExpression)ct.replace((PsiElement)assignment, replacement));
            } else if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                JavaCodeStyleManager.getInstance((Project)variable.getProject()).shortenClassReferences(ct.replace((PsiElement)assignment, builderName + "=" + this.generateNewStringBuilder(rValue, ct)));
            }
        }

        @NotNull
        private static PsiMethodCallExpression getDeepestQualifierCall(PsiMethodCallExpression result) {
            PsiMethodCallExpression qualifierCall;
            PsiMethodCallExpression append = result;
            while ((qualifierCall = MethodCallUtils.getQualifierMethodCall(append)) != null) {
                append = qualifierCall;
            }
            PsiMethodCallExpression psiMethodCallExpression = append;
            if (psiMethodCallExpression == null) {
                StringBuilderReplacer.$$$reportNull$$$0(4);
            }
            return psiMethodCallExpression;
        }

        private void makeNullSafe(PsiExpression expression, PsiMethodCallExpression result) {
            if (!this.myNullables.contains(expression)) {
                return;
            }
            PsiExpression qualifier = StringBuilderReplacer.getDeepestQualifierCall(result).getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String builder = qualifier.getText();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)result.getProject());
            qualifier.replace((PsiElement)factory.createExpressionFromText("(" + builder + "==null?new " + this.myTargetType + "(\"null\"):" + builder + ")", (PsiElement)qualifier));
            result.replace((PsiElement)factory.createExpressionFromText(builder + "=" + result.getText(), (PsiElement)result));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringBuilderReplacer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateNewStringBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeepestQualifierCall";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

