/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class StringConcatenationInsideStringBufferAppendInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.problem.descriptor", className);
        if (string == null) {
            StringConcatenationInsideStringBufferAppendInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInsideStringBufferAppendVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceWithChainedAppendFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection", "buildErrorString"));
    }

    private static class StringConcatenationInsideStringBufferAppendVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInsideStringBufferAppendVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                StringConcatenationInsideStringBufferAppendVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!ExpressionUtils.isStringConcatenation((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)argument)) || PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                this.registerMethodCallError(expression, containingClass);
                return;
            }
            Project project = containingClass.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass appendableClass = psiFacade.findClass("java.lang.Appendable", GlobalSearchScope.allScope((Project)project));
            if (appendableClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)appendableClass, (boolean)true)) {
                return;
            }
            this.registerMethodCallError(expression, containingClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$StringConcatenationInsideStringBufferAppendVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ReplaceWithChainedAppendFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithChainedAppendFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithChainedAppendFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameElement, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression methodExpression;
            if (project == null) {
                ReplaceWithChainedAppendFix.$$$reportNull$$$0(1);
            }
            if (methodNameElement == null) {
                ReplaceWithChainedAppendFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithChainedAppendFix.$$$reportNull$$$0(3);
            }
            if ((methodExpression = (PsiReferenceExpression)methodNameElement.getParent()) == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
            if (methodCallExpression == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = ct.markUnchanged(arguments[0]);
            PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(qualifier, argument);
            if (appendExpression == null) {
                return;
            }
            ct.replaceAndRestoreComments((PsiElement)methodCallExpression, (PsiElement)appendExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$ReplaceWithChainedAppendFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$ReplaceWithChainedAppendFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

