/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryTemporaryOnConversionToStringInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiNewExpression)infos[0], new CommentTracker());
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.to.string.display.name", replacementString);
        if (string == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(@NotNull PsiNewExpression expression, @NotNull CommentTracker commentTracker) {
        PsiExpressionList argumentList;
        if (expression == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(1);
        }
        if (commentTracker == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(2);
        }
        if ((argumentList = expression.getArgumentList()) == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        String argumentText = commentTracker.text((PsiElement)arguments[0]);
        String qualifierType = type.getPresentableText();
        return qualifierType + ".toString(" + argumentText + ")";
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        String replacement = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiNewExpression)infos[0], new CommentTracker());
        String name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{replacement});
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class UnnecessaryTemporaryObjectFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(@IntentionName String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            CommentTracker commentTracker;
            PsiNewExpression expression;
            String newExpression;
            if (project == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(4);
            }
            if ((newExpression = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression(expression = (PsiNewExpression)startElement.getParent(), commentTracker = new CommentTracker())) == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> s_basicTypes = new HashSet<String>(8);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                UnnecessaryTemporaryObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = PsiUtil.deparenthesizeExpression((PsiExpression)methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType != null && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            String typeName = type.getCanonicalText();
            if (!s_basicTypes.contains(typeName)) {
                return;
            }
            this.registerNewExpressionError(newExpression, newExpression);
        }

        static {
            s_basicTypes.add("java.lang.Boolean");
            s_basicTypes.add("java.lang.Byte");
            s_basicTypes.add("java.lang.Character");
            s_basicTypes.add("java.lang.Double");
            s_basicTypes.add("java.lang.Float");
            s_basicTypes.add("java.lang.Integer");
            s_basicTypes.add("java.lang.Long");
            s_basicTypes.add("java.lang.Short");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
        }
    }
}

