/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class HardcodedLineSeparatorsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "HardcodedLineSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("hardcoded.line.separator.problem.descriptor", new Object[0]);
        if (string == null) {
            HardcodedLineSeparatorsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedLineSeparatorsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection", "buildErrorString"));
    }

    private static class HardcodedLineSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedLineSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            int[] offsets;
            if (expression == null) {
                HardcodedLineSeparatorsVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null || !TypeUtils.isJavaLangString(type) && !type.equals(PsiTypes.charType())) {
                return;
            }
            String text = expression.getText();
            CharSequence result = CodeInsightUtilCore.parseStringCharacters((String)text, (int[])(offsets = new int[text.length() + 1]));
            if (result != null) {
                int max = result.length();
                for (int i = 0; i < max; ++i) {
                    int offset;
                    int length;
                    char c = result.charAt(i);
                    if (c != '\n' && c != '\r' || (length = offsets[i + 1] - (offset = offsets[i])) <= 1) continue;
                    this.registerErrorAtOffset((PsiElement)expression, offset, length, new Object[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/portability/HardcodedLineSeparatorsInspection$HardcodedLineSeparatorsVisitor", "visitLiteralExpression"));
        }
    }
}

