/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoolUtils {
    private static final CallMatcher STREAM_ANY_MATCH = CallMatcher.instanceCall("java.util.stream.Stream", "anyMatch");
    private static final CallMatcher STREAM_NONE_MATCH = CallMatcher.instanceCall("java.util.stream.Stream", "noneMatch");
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isPresent").parameterCount(0));
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isEmpty").parameterCount(0));
    private static final List<PredicatedReplacement> ourReplacements = List.of(new PredicatedReplacement("isPresent", OPTIONAL_IS_EMPTY), new PredicatedReplacement("isEmpty", OPTIONAL_IS_PRESENT.withLanguageLevelAtLeast(LanguageLevel.JDK_11)), new PredicatedReplacement("nonNull", CallMatcher.staticCall("java.util.Objects", "isNull")), new PredicatedReplacement("isNull", CallMatcher.staticCall("java.util.Objects", "nonNull")), new PredicatedReplacement("noneMatch", STREAM_ANY_MATCH), new PredicatedReplacement("anyMatch", STREAM_NONE_MATCH));

    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (expression == null) {
            BoolUtils.$$$reportNull$$$0(0);
        }
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand = prefixExpression.getOperand();
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
        return stripped == null ? operand : stripped;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        return BoolUtils.getNegatedExpressionText(condition, new CommentTracker());
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition, CommentTracker tracker) {
        return BoolUtils.getNegatedExpressionText(condition, 18, tracker);
    }

    public static int getLogicalOperandCount(@Nullable PsiExpression condition) {
        PsiExpression unparenthesizedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition);
        if (!(unparenthesizedExpression instanceof PsiPolyadicExpression)) {
            return 1;
        }
        PsiPolyadicExpression infixExpression = (PsiPolyadicExpression)unparenthesizedExpression;
        if (!(JavaTokenType.ANDAND.equals(infixExpression.getOperationTokenType()) || JavaTokenType.OROR.equals(infixExpression.getOperationTokenType()) || !PsiTypes.booleanType().equals((Object)infixExpression.getOperands()[0].getType()) && !PsiTypes.booleanType().equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)infixExpression.getOperands()[0].getType())) && Arrays.asList(JavaTokenType.AND, JavaTokenType.OR).contains(infixExpression.getOperationTokenType()))) {
            return 1;
        }
        int nbOperands = 0;
        for (PsiExpression operand : infixExpression.getOperands()) {
            nbOperands += BoolUtils.getLogicalOperandCount(operand);
        }
        return nbOperands;
    }

    private static String findSmartMethodNegation(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        PsiMethodCallExpression copy = (PsiMethodCallExpression)call.copy();
        for (PredicatedReplacement predicatedReplacement : ourReplacements) {
            if (!predicatedReplacement.predicate.test((PsiMethodCallExpression)call)) continue;
            ExpressionUtils.bindCallTo(copy, predicatedReplacement.name);
            return copy.getText();
        }
        return null;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression, int precedence, CommentTracker tracker) {
        Object value;
        PsiExpression negated;
        IElementType tokenType;
        PsiParenthesizedExpression parenthesizedExpression;
        PsiExpression operand;
        String smartNegation;
        if (expression == null) {
            return "";
        }
        if (expression instanceof PsiMethodCallExpression && (smartNegation = BoolUtils.findSmartMethodNegation(expression)) != null) {
            String string = smartNegation;
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (expression instanceof PsiParenthesizedExpression && (operand = (parenthesizedExpression = (PsiParenthesizedExpression)expression).getExpression()) != null) {
            String string = "(" + BoolUtils.getNegatedExpressionText(operand, tracker) + ")";
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (expression instanceof PsiAssignmentExpression && expression.getParent() instanceof PsiExpressionStatement) {
            String newOp = null;
            tokenType = ((PsiAssignmentExpression)expression).getOperationTokenType();
            if (tokenType == JavaTokenType.ANDEQ) {
                newOp = "|=";
            } else if (tokenType == JavaTokenType.OREQ) {
                newOp = "&=";
            }
            if (newOp != null) {
                String string = tracker.text((PsiElement)((PsiAssignmentExpression)expression).getLExpression()) + newOp + BoolUtils.getNegatedExpressionText(((PsiAssignmentExpression)expression).getRExpression());
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            boolean needParenthesis = ParenthesesUtils.getPrecedence((PsiExpression)conditionalExpression) >= precedence;
            String text = tracker.text((PsiElement)conditionalExpression.getCondition()) + "?" + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression(), tracker) + ":" + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression(), tracker);
            String string = needParenthesis ? "(" + text + ")" : text;
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (BoolUtils.isNegation(expression) && (negated = BoolUtils.getNegated(expression)) != null) {
            String string = ParenthesesUtils.getText(tracker.markUnchanged(negated), precedence);
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            tokenType = polyadicExpression.getOperationTokenType();
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (ComparisonUtils.isComparison((PsiExpression)polyadicExpression)) {
                String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
                StringBuilder result = new StringBuilder();
                boolean isEven = (operands.length & 1) != 1;
                int length = operands.length;
                for (int i = 0; i < length; ++i) {
                    PsiExpression operand2 = operands[i];
                    if (TypeUtils.hasFloatingPointType(operand2) && !ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                        String string = "!(" + polyadicExpression.getText() + ")";
                        if (string == null) {
                            BoolUtils.$$$reportNull$$$0(6);
                        }
                        return string;
                    }
                    if (i > 0) {
                        if (isEven && (i & 1) != 1) {
                            PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand2);
                            if (token != null) {
                                result.append(token.getText());
                            }
                        } else {
                            result.append(negatedComparison);
                        }
                    }
                    result.append(tracker.text((PsiElement)operand2));
                }
                String string = result.toString();
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
                int newPrecedence;
                String targetToken;
                if (tokenType.equals(JavaTokenType.ANDAND)) {
                    targetToken = "||";
                    newPrecedence = 14;
                } else {
                    targetToken = "&&";
                    newPrecedence = 13;
                }
                Function replacer = child -> {
                    if (child instanceof PsiExpression) {
                        return BoolUtils.getNegatedExpressionText((PsiExpression)child, newPrecedence, tracker);
                    }
                    return child instanceof PsiJavaToken ? targetToken : tracker.text((PsiElement)child);
                };
                String join = StringUtil.join((Object[])polyadicExpression.getChildren(), (Function)replacer, (String)"");
                Object object = newPrecedence > precedence ? "(" + join + ")" : join;
                if (object == null) {
                    BoolUtils.$$$reportNull$$$0(8);
                }
                return object;
            }
        }
        if (expression instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)expression).getValue()) instanceof Boolean) {
            String string = String.valueOf((Boolean)value == false);
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = "!" + ParenthesesUtils.getText(tracker.markUnchanged(expression), 3);
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isBooleanLiteral(PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        @NonNls String text = literalExpression.getText();
        return "true".equals(text) || "false".equals(text);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return false;
        }
        return "true".equals(expression.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return false;
        }
        return "false".equals(expression.getText());
    }

    @Contract(value="null, _ -> false; _, null -> false", pure=true)
    public static boolean areExpressionsOpposite(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression1);
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (expression1 == null || expression2 == null) {
            return false;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (BoolUtils.isNegation(expression1)) {
            return equivalence.expressionsAreEquivalent(BoolUtils.getNegated(expression1), expression2);
        }
        if (BoolUtils.isNegation(expression2)) {
            return equivalence.expressionsAreEquivalent(BoolUtils.getNegated(expression2), expression1);
        }
        if (expression1 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp1 = (PsiBinaryExpression)expression1;
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp2 = (PsiBinaryExpression)expression2;
                RelationType rel1 = DfaPsiUtil.getRelationByToken(binOp1.getOperationTokenType());
                RelationType rel2 = DfaPsiUtil.getRelationByToken(binOp2.getOperationTokenType());
                if (rel1 == null || rel2 == null) {
                    return false;
                }
                PsiType type = binOp1.getLOperand().getType();
                if (type == null || type.equals(PsiTypes.floatType()) || type.equals(PsiTypes.doubleType())) {
                    return false;
                }
                if (rel1 == rel2.getNegated()) {
                    return equivalence.expressionsAreEquivalent(binOp1.getLOperand(), binOp2.getLOperand()) && equivalence.expressionsAreEquivalent(binOp1.getROperand(), binOp2.getROperand());
                }
                if (rel1.getFlipped() == rel2.getNegated()) {
                    return equivalence.expressionsAreEquivalent(binOp1.getLOperand(), binOp2.getROperand()) && equivalence.expressionsAreEquivalent(binOp1.getROperand(), binOp2.getLOperand());
                }
            }
        }
        return false;
    }

    @Nullable
    public static Boolean fromBoxedConstantReference(@NotNull PsiExpression expression) {
        PsiExpression unparenthesizedExpression;
        if (expression == null) {
            BoolUtils.$$$reportNull$$$0(11);
        }
        if (!((unparenthesizedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)unparenthesizedExpression;
        PsiElement psiElement = referenceExpression.resolve();
        if (!(psiElement instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)psiElement;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if ("java.lang.Boolean".equals(field.getContainingClass().getQualifiedName())) {
            return switch (field.getName()) {
                case "TRUE" -> true;
                case "FALSE" -> false;
                default -> null;
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegatedExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNegation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromBoxedConstantReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static final class PredicatedReplacement {
        Predicate<? super PsiMethodCallExpression> predicate;
        String name;

        private PredicatedReplacement(@NonNls String name, Predicate<? super PsiMethodCallExpression> predicate) {
            this.predicate = predicate;
            this.name = name;
        }
    }
}

