/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakConverter {
    private final PsiSwitchBlock mySwitchBlock;
    private final String myReplacement;

    public BreakConverter(PsiSwitchBlock switchBlock, String replacement) {
        this.mySwitchBlock = switchBlock;
        this.myReplacement = replacement;
    }

    public void process() {
        List<PsiBreakStatement> breaks = this.collectBreaks();
        Map groups = StreamEx.of(breaks).partitioningBy(breakStatement -> BreakConverter.isRemovable(this.mySwitchBlock, (PsiStatement)breakStatement));
        List removableBreaks = (List)groups.get(true);
        removableBreaks.forEach(DeleteUnnecessaryStatementFix::deleteUnnecessaryStatement);
        List replaceableBreaks = (List)groups.get(false);
        if (!replaceableBreaks.isEmpty()) {
            assert (this.myReplacement != null);
            for (PsiBreakStatement breakStatement2 : replaceableBreaks) {
                new CommentTracker().replaceAndRestoreComments((PsiElement)breakStatement2, this.myReplacement);
            }
        }
    }

    @NotNull
    private List<PsiBreakStatement> collectBreaks() {
        final ArrayList<PsiBreakStatement> breaks = new ArrayList<PsiBreakStatement>();
        this.mySwitchBlock.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitBreakStatement(statement);
                if (statement.findExitedStatement() == BreakConverter.this.mySwitchBlock) {
                    breaks.add(statement);
                }
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/BreakConverter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBreakStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PsiBreakStatement> arrayList = breaks;
        if (arrayList == null) {
            BreakConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    @NonNls
    private static String getReplacement(PsiStatement statement) {
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLabeledStatement) {
            return BreakConverter.getReplacement((PsiStatement)parent);
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (nextStatement != null) {
            if (nextStatement instanceof PsiContinueStatement || nextStatement instanceof PsiBreakStatement || nextStatement instanceof PsiReturnStatement || nextStatement instanceof PsiThrowStatement) {
                return nextStatement.getText();
            }
            return null;
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof PsiLoopStatement) {
            return "continue;";
        }
        if (parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethod && PsiTypes.voidType().equals((Object)((PsiMethod)grandParent).getReturnType()) || grandParent instanceof PsiLambdaExpression && PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)grandParent)))) {
                return "return;";
            }
            if (grandParent instanceof PsiBlockStatement) {
                return BreakConverter.getReplacement((PsiStatement)grandParent);
            }
        }
        return null;
    }

    private static boolean isRemovable(PsiSwitchBlock switchStatement, PsiStatement statement) {
        if (switchStatement instanceof PsiSwitchExpression) {
            return false;
        }
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiSwitchLabeledRuleStatement) {
            return true;
        }
        if (parent instanceof PsiIfStatement || parent instanceof PsiLabeledStatement) {
            return BreakConverter.isRemovable(switchStatement, (PsiStatement)parent);
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (nextStatement == null && parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            return grandParent == switchStatement || grandParent instanceof PsiBlockStatement && BreakConverter.isRemovable(switchStatement, (PsiStatement)grandParent);
        }
        if (nextStatement instanceof PsiSwitchLabelStatement) {
            return ((PsiSwitchLabelStatement)nextStatement).getEnclosingSwitchBlock() == switchStatement && !ControlFlowUtils.statementMayCompleteNormally(statement);
        }
        if (nextStatement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)nextStatement).findExitedStatement() == switchStatement;
        }
        return false;
    }

    @Nullable
    public static BreakConverter from(PsiSwitchBlock switchStatement) {
        String replacement;
        String string = replacement = switchStatement instanceof PsiSwitchStatement ? BreakConverter.getReplacement((PsiStatement)switchStatement) : null;
        if (replacement == null) {
            class Visitor
            extends JavaRecursiveElementWalkingVisitor {
                boolean hasNonRemovableBreak;
                final /* synthetic */ PsiSwitchBlock val$switchStatement;

                Visitor(PsiSwitchBlock psiSwitchBlock) {
                    this.val$switchStatement = psiSwitchBlock;
                }

                public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
                    if (statement == null) {
                        Visitor.$$$reportNull$$$0(0);
                    }
                    super.visitBreakStatement(statement);
                    if (statement.findExitedStatement() == this.val$switchStatement && !BreakConverter.isRemovable(this.val$switchStatement, (PsiStatement)statement)) {
                        this.hasNonRemovableBreak = true;
                        this.stopWalking();
                    }
                }

                public void visitExpression(@NotNull PsiExpression expression) {
                    if (expression == null) {
                        Visitor.$$$reportNull$$$0(1);
                    }
                }

                public void visitClass(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        Visitor.$$$reportNull$$$0(2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "statement";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aClass";
                            break;
                        }
                    }
                    objectArray2[1] = "com/siyeh/ig/psiutils/BreakConverter$1Visitor";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitBreakStatement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClass";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            Visitor visitor2 = new Visitor(switchStatement);
            switchStatement.accept((PsiElementVisitor)visitor2);
            if (visitor2.hasNonRemovableBreak) {
                return null;
            }
        }
        return new BreakConverter(switchStatement, replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BreakConverter", "collectBreaks"));
    }
}

