/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CollectionUtils {
    private static final CallMatcher COLLECTION_MAP_SIZE = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));
    public static final CallMatcher DERIVED_COLLECTION = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Map", "keySet", "values", "entrySet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableMap", "descendingKeySet", "descendingMap", "navigableKeySet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableSet", "descendingSet").parameterCount(0), CallMatcher.instanceCall("java.util.SequencedCollection", "reversed").parameterCount(0));
    @NonNls
    private static final @Unmodifiable Set<String> s_allCollectionClassesAndInterfaces = Set.of("java.util.AbstractCollection", "java.util.AbstractList", "java.util.AbstractMap", "java.util.AbstractQueue", "java.util.AbstractSequentialList", "java.util.AbstractSet", "java.util.ArrayList", "java.util.ArrayDeque", "java.util.Collection", "java.util.Dictionary", "java.util.EnumMap", "java.util.HashMap", "java.util.HashSet", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.List", "java.util.Map", "java.util.PriorityQueue", "java.util.Queue", "java.util.Set", "java.util.SortedMap", "java.util.SortedSet", "java.util.Stack", "java.util.TreeMap", "java.util.TreeSet", "java.util.Vector", "java.util.WeakHashMap", "java.util.concurrent.ArrayBlockingQueue", "java.util.concurrent.BlockingDeque", "java.util.concurrent.BlockingQueue", "java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentLinkedDeque", "java.util.concurrent.ConcurrentLinkedQueue", "java.util.concurrent.ConcurrentMap", "java.util.concurrent.ConcurrentNavigableMap", "java.util.concurrent.ConcurrentSkipListMap", "java.util.concurrent.ConcurrentSkipListSet", "java.util.concurrent.CopyOnWriteArrayList", "java.util.concurrent.CopyOnWriteArraySet", "java.util.concurrent.DelayQueue", "java.util.concurrent.LinkedBlockingDeque", "java.util.concurrent.LinkedBlockingQueue", "java.util.concurrent.LinkedTransferQueue", "java.util.concurrent.PriorityBlockingQueue", "java.util.concurrent.SynchronousQueue", "com.sun.java.util.collections.ArrayList", "com.sun.java.util.collections.Collection", "com.sun.java.util.collections.HashMap", "com.sun.java.util.collections.HashSet", "com.sun.java.util.collections.Hashtable", "com.sun.java.util.collections.LinkedList", "com.sun.java.util.collections.List", "com.sun.java.util.collections.Map", "com.sun.java.util.collections.Set", "com.sun.java.util.collections.SortedMap", "com.sun.java.util.collections.SortedSet", "com.sun.java.util.collections.TreeMap", "com.sun.java.util.collections.TreeSet", "com.sun.java.util.collections.Vector");
    @NonNls
    private static final @Unmodifiable Map<String, String> s_interfaceForCollection = Map.ofEntries(Map.entry("ArrayList", "List"), Map.entry("EnumMap", "Map"), Map.entry("EnumSet", "Set"), Map.entry("HashMap", "Map"), Map.entry("HashSet", "Set"), Map.entry("Hashtable", "Map"), Map.entry("IdentityHashMap", "Map"), Map.entry("LinkedHashMap", "Map"), Map.entry("LinkedHashSet", "Set"), Map.entry("LinkedList", "List"), Map.entry("PriorityQueue", "Queue"), Map.entry("TreeMap", "Map"), Map.entry("TreeSet", "SortedSet"), Map.entry("Vector", "List"), Map.entry("WeakHashMap", "Map"), Map.entry("java.util.ArrayList", "java.util.List"), Map.entry("java.util.EnumMap", "java.util.Map"), Map.entry("java.util.EnumSet", "java.util.Set"), Map.entry("java.util.HashMap", "java.util.Map"), Map.entry("java.util.HashSet", "java.util.Set"), Map.entry("java.util.Hashtable", "java.util.Map"), Map.entry("java.util.IdentityHashMap", "java.util.Map"), Map.entry("java.util.LinkedHashMap", "java.util.Map"), Map.entry("java.util.LinkedHashSet", "java.util.Set"), Map.entry("java.util.LinkedList", "java.util.List"), Map.entry("java.util.PriorityQueue", "java.util.Queue"), Map.entry("java.util.TreeMap", "java.util.Map"), Map.entry("java.util.TreeSet", "java.util.Set"), Map.entry("java.util.Vector", "java.util.List"), Map.entry("java.util.WeakHashMap", "java.util.Map"), Map.entry("com.sun.java.util.collections.HashSet", "com.sun.java.util.collections.Set"), Map.entry("com.sun.java.util.collections.TreeSet", "com.sun.java.util.collections.Set"), Map.entry("com.sun.java.util.collections.Vector", "com.sun.java.util.collections.List"), Map.entry("com.sun.java.util.collections.ArrayList", "com.sun.java.util.collections.List"), Map.entry("com.sun.java.util.collections.LinkedList", "com.sun.java.util.collections.List"), Map.entry("com.sun.java.util.collections.TreeMap", "com.sun.java.util.collections.Map"), Map.entry("com.sun.java.util.collections.HashMap", "com.sun.java.util.collections.Map"), Map.entry("com.sun.java.util.collections.Hashtable", "com.sun.java.util.collections.Map"));

    private CollectionUtils() {
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(@Nullable PsiType type) {
        return CollectionUtils.isConcreteCollectionClass(PsiUtil.resolveClassInClassTypeOnly((PsiType)type));
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(PsiClass aClass) {
        if (aClass == null || aClass.isEnum() || aClass.isInterface() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
            return false;
        }
        @NonNls String name = aClass.getQualifiedName();
        return name != null && name.startsWith("java.util.");
    }

    public static boolean isCollectionClassOrInterface(@Nullable PsiType type) {
        PsiClass resolved = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (resolved == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"com.google.common.collect.Multimap") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"com.google.common.collect.Table");
    }

    public static boolean isCollectionClassOrInterface(PsiClass aClass) {
        return CollectionUtils.isCollectionClassOrInterface(aClass, new HashSet());
    }

    private static boolean isCollectionClassOrInterface(PsiClass aClass, Set<? super PsiClass> visitedClasses) {
        if (!visitedClasses.add((PsiClass)aClass)) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (className != null && s_allCollectionClassesAndInterfaces.contains(className)) {
            return true;
        }
        for (PsiClass aSuper : aClass.getSupers()) {
            if (!CollectionUtils.isCollectionClassOrInterface(aSuper, visitedClasses)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakCollectionClass(@Nullable PsiType type) {
        return type instanceof PsiClassType && "java.util.WeakHashMap".equals(type.getCanonicalText());
    }

    public static boolean isConstantEmptyArray(@NotNull PsiField field) {
        if (field == null) {
            CollectionUtils.$$$reportNull$$$0(0);
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final") && CollectionUtils.isEmptyArray((PsiVariable)field);
    }

    public static boolean isEmptyArray(PsiVariable variable) {
        boolean bl;
        PsiExpression initializer = variable.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
            bl = arrayInitializerExpression.isEmpty();
        } else {
            bl = ConstructionUtils.isEmptyArrayInitializer(initializer);
        }
        return bl;
    }

    public static String getInterfaceForClass(@NotNull String name) {
        int parameterStart;
        if (name == null) {
            CollectionUtils.$$$reportNull$$$0(1);
        }
        String baseName = (parameterStart = name.indexOf(60)) >= 0 ? name.substring(0, parameterStart).trim() : name;
        return s_interfaceForCollection.get(baseName);
    }

    @Contract(value="null, _ -> false")
    public static boolean isCollectionOrMapSize(@Nullable PsiExpression expression, @NotNull PsiExpression collection) {
        PsiMethodCallExpression sizeCall;
        PsiExpression psiExpression;
        if (collection == null) {
            CollectionUtils.$$$reportNull$$$0(2);
        }
        if (!((psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression) || !COLLECTION_MAP_SIZE.test(sizeCall = (PsiMethodCallExpression)psiExpression)) {
            return false;
        }
        PsiExpression sizeQualifier = sizeCall.getMethodExpression().getQualifierExpression();
        if (sizeQualifier == null) {
            return false;
        }
        sizeQualifier = CollectionUtils.getBaseCollection(sizeQualifier);
        collection = CollectionUtils.getBaseCollection(collection);
        return sizeQualifier != null && collection != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sizeQualifier, (PsiElement)collection);
    }

    @Nullable
    private static PsiExpression getBaseCollection(@NotNull PsiExpression derivedCollection) {
        PsiMethodCallExpression derivedCall;
        PsiExpression psiExpression;
        if (derivedCollection == null) {
            CollectionUtils.$$$reportNull$$$0(3);
        }
        while ((psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)derivedCollection)) instanceof PsiMethodCallExpression && DERIVED_COLLECTION.test(derivedCall = (PsiMethodCallExpression)psiExpression)) {
            derivedCollection = ExpressionUtils.getEffectiveQualifier(derivedCall.getMethodExpression());
        }
        return derivedCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedCollection";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/CollectionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstantEmptyArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterfaceForClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollectionOrMapSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseCollection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

