/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LoopDirection;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement psiElement;
        PsiCodeBlock block;
        PsiElement parent = ifStatement.getParent();
        if (parent instanceof PsiCodeBlock && (block = (PsiCodeBlock)parent).getStatementCount() == 1 && (psiElement = parent.getParent()) instanceof PsiBlockStatement) {
            PsiBlockStatement bs = (PsiBlockStatement)psiElement;
            parent = bs.getParent();
        }
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals((Object)elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement) {
        return ControlFlowUtils.statementMayCompleteNormally(statement, null);
    }

    private static boolean statementMayCompleteNormally(@Nullable PsiStatement statement, @Nullable PsiMethod psiMethod) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiYieldStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiSwitchLabelStatement || statement instanceof PsiForeachStatementBase) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            if (method.equals((Object)psiMethod)) {
                return false;
            }
            @NonNls String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return ControlFlowUtils.forStatementMayCompleteNormally(forStatement);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            return ControlFlowUtils.whileStatementMayCompleteNormally(whileStatement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return ControlFlowUtils.doWhileStatementMayCompleteNormally(doWhileStatement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            return ControlFlowUtils.codeBlockMayCompleteNormally(synchronizedStatement.getBody(), psiMethod);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            return ControlFlowUtils.codeBlockMayCompleteNormally(block.getCodeBlock(), psiMethod);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeled = (PsiLabeledStatement)statement;
            return ControlFlowUtils.labeledStatementMayCompleteNormally(labeled, psiMethod);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return ControlFlowUtils.ifStatementMayCompleteNormally(ifStatement, psiMethod);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return ControlFlowUtils.tryStatementMayCompleteNormally(tryStatement, psiMethod);
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            return ControlFlowUtils.switchStatementMayCompleteNormally(switchStatement, psiMethod);
        }
        if (statement instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
            PsiStatement body = rule.getBody();
            return body != null && ControlFlowUtils.statementMayCompleteNormally(body, psiMethod);
        }
        if (statement instanceof PsiTemplateStatement || statement instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + String.valueOf(statement.getClass());
        return true;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isEndlessLoop(@Nullable PsiConditionalLoopStatement loopStatement) {
        if (loopStatement == null) {
            return false;
        }
        if (loopStatement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)loopStatement;
            PsiExpression condition = forStatement.getCondition();
            if (condition != null && !BoolUtils.isTrue(condition)) {
                return false;
            }
            return !(forStatement.getInitialization() != null && !(forStatement.getInitialization() instanceof PsiEmptyStatement) || forStatement.getUpdate() != null && !(forStatement.getUpdate() instanceof PsiEmptyStatement));
        }
        return BoolUtils.isTrue(loopStatement.getCondition());
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(0);
        }
        return ControlFlowUtils.conditionalLoopStatementMayCompleteNormally((PsiConditionalLoopStatement)loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(1);
        }
        return ControlFlowUtils.conditionalLoopStatementMayCompleteNormally((PsiConditionalLoopStatement)loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(2);
        }
        return ControlFlowUtils.conditionalLoopStatementMayCompleteNormally((PsiConditionalLoopStatement)loopStatement);
    }

    private static boolean conditionalLoopStatementMayCompleteNormally(@NotNull PsiConditionalLoopStatement loopStatement) {
        PsiExpression condition;
        Object value;
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(3);
        }
        return (value = ExpressionUtils.computeConstantExpression(condition = loopStatement.getCondition())) != Boolean.TRUE || ControlFlowUtils.statementContainsBreakToStatementOrAncestor((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement, @Nullable PsiMethod method) {
        boolean isLabeledRuleSwitch;
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(4);
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiExpression selectorExpression = switchStatement.getExpression();
        if (selectorExpression == null) {
            return true;
        }
        PsiType selectorType = selectorExpression.getType();
        if (selectorType == null) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        boolean hasUnconditionalPattern = false;
        for (PsiStatement statement : statements) {
            PsiBreakStatement breakStatement;
            if (statement instanceof PsiSwitchLabelStatementBase) {
                PsiSwitchLabelStatementBase switchLabelStatement = (PsiSwitchLabelStatementBase)statement;
                if (statement instanceof PsiSwitchLabelStatement) {
                    ++numCases;
                }
                if (hasDefaultCase || hasUnconditionalPattern) continue;
                if (switchLabelStatement.isDefaultCase()) {
                    hasDefaultCase = true;
                    continue;
                }
                PsiCaseLabelElementList labelElementList = switchLabelStatement.getCaseLabelElementList();
                if (labelElementList == null) continue;
                for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                    if (labelElement instanceof PsiDefaultCaseLabelElement) {
                        hasDefaultCase = true;
                        continue;
                    }
                    if (!(labelElement instanceof PsiPattern)) continue;
                    hasUnconditionalPattern = JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)labelElement, (PsiType)selectorType);
                }
                continue;
            }
            if (!(statement instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() != null) continue;
            return true;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!(hasDefaultCase || hasUnconditionalPattern || isEnum)) {
            return true;
        }
        if (!hasDefaultCase && !hasUnconditionalPattern) {
            PsiClass aClass = ((PsiClassType)selectorType).resolve();
            if (aClass == null) {
                return true;
            }
            if (!ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)aClass, numCases, PsiEnumConstant.class)) {
                return true;
            }
        }
        if (isLabeledRuleSwitch = statements[0] instanceof PsiSwitchLabeledRuleStatement) {
            for (PsiStatement statement : statements) {
                if (!ControlFlowUtils.statementMayCompleteNormally(statement, method)) continue;
                return true;
            }
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1], method);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement) {
        PsiExpression expression = statement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        return aClass != null && aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement, @Nullable PsiMethod method) {
        PsiCodeBlock[] catchBlocks;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(5);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock, method)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock, method)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement, @Nullable PsiMethod method) {
        PsiStatement branch2;
        PsiStatement branch1;
        if (ifStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(6);
        }
        PsiExpression condition = ifStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch, method);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch, method);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1, method) || ControlFlowUtils.statementMayCompleteNormally(branch2, method);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement, @Nullable PsiMethod method) {
        PsiStatement statement;
        if (labeledStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(7);
        }
        if ((statement = labeledStatement.getStatement()) == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement, method) || ControlFlowUtils.statementContainsBreakToStatementOrAncestor(statement);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        return ControlFlowUtils.codeBlockMayCompleteNormally(block, null);
    }

    public static boolean methodMayCompleteNormally(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowUtils.$$$reportNull$$$0(8);
        }
        return ControlFlowUtils.codeBlockMayCompleteNormally(method.getBody(), method);
    }

    private static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block, @Nullable PsiMethod method) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement, method)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementContainsBreakToStatementOrAncestor(@NotNull PsiStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(9);
        }
        BreakFinder breakFinder = new BreakFinder(statement, true);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(10);
        }
        BreakFinder breakFinder = new BreakFinder(statement, false);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(11);
        }
        PsiElement parent = statement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement);
        statement.accept((PsiElementVisitor)continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean containsReturn(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(12);
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(13);
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean containsSystemExit(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(14);
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        element.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean containsYield(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(15);
        }
        YieldFinder returnFinder = new YieldFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.yieldFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, @NonNls String containingClassName, PsiType returnType, @NonNls String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        PsiLoopStatement loopStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(16);
        }
        if ((loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class})) == null) {
            return false;
        }
        PsiStatement body = loopStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element, @Nullable PsiElement stopAt) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(17);
        }
        for (PsiElement parent = element.getParent(); parent != null && parent != stopAt && !(parent instanceof PsiMember) && !(parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            PsiTryStatement tryStatement;
            PsiCodeBlock finallyBlock;
            if (!(parent instanceof PsiTryStatement) || (finallyBlock = (tryStatement = (PsiTryStatement)parent).getFinallyBlock()) == null || !PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)element, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(18);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class}) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(19);
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(20);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReturnStatement.class) != null;
    }

    public static boolean isInThrowStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(21);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class) != null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static PsiStatement stripBraces(@Nullable PsiStatement statement) {
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement;
    }

    public static PsiStatement @NotNull [] unwrapBlock(@Nullable PsiStatement statement) {
        PsiStatement[] psiStatementArray;
        PsiBlockStatement block = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (block != null) {
            PsiStatement[] psiStatementArray2 = block.getCodeBlock().getStatements();
            if (psiStatementArray2 == null) {
                ControlFlowUtils.$$$reportNull$$$0(22);
            }
            return psiStatementArray2;
        }
        if (statement == null) {
            psiStatementArray = PsiStatement.EMPTY_ARRAY;
        } else {
            PsiStatement[] psiStatementArray3 = new PsiStatement[1];
            psiStatementArray = psiStatementArray3;
            psiStatementArray3[0] = statement;
        }
        if (psiStatementArray == null) {
            ControlFlowUtils.$$$reportNull$$$0(23);
        }
        return psiStatementArray;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiElement containingElement, @NotNull PsiStatement statement) {
        if (containingElement == null) {
            ControlFlowUtils.$$$reportNull$$$0(24);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(25);
        }
        PsiStatement statementToCheck = statement;
        while (!containingElement.equals((Object)statementToCheck)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null || container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            statementToCheck = container;
            if (!(statementToCheck instanceof PsiSwitchLabeledRuleStatement)) continue;
            statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)statementToCheck, PsiStatement.class);
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body, @NotNull PsiStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(26);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(27);
        }
        PsiStatement statementToCheck = statement;
        PsiElement container;
        while ((container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck)) != null && !(container instanceof PsiLoopStatement)) {
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals((Object)body)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
            if (!(statementToCheck instanceof PsiSwitchLabeledRuleStatement)) continue;
            statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)statementToCheck, PsiStatement.class);
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiElement getContainingStatementOrBlock(@Nullable PsiElement statement) {
        return PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(28);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(29);
        }
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement.equals((Object)childStatement)) {
                return true;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return (PsiStatement)PsiTreeUtil.getChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        for (PsiElement child = codeBlock.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            return (PsiStatement)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            ControlFlowUtils.$$$reportNull$$$0(30);
        }
        if (element == null) {
            return null;
        }
        PsiElement result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            return null;
        }
        return (T)result;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)codeBlock, count, PsiStatement.class);
    }

    public static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count, @NotNull Class<T> aClass) {
        if (aClass == null) {
            ControlFlowUtils.$$$reportNull$$$0(31);
        }
        if (element == null) {
            return false;
        }
        int i = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child) || ++i <= count) continue;
            return false;
        }
        return i == count;
    }

    public static <T extends PsiElement> boolean isNestedElement(@NotNull T element, @NotNull Class<? extends T> aClass) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(32);
        }
        if (aClass == null) {
            ControlFlowUtils.$$$reportNull$$$0(33);
        }
        return PsiTreeUtil.getParentOfType(element, aClass, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}) != null;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        PsiCodeBlock body;
        if (method == null) {
            ControlFlowUtils.$$$reportNull$$$0(34);
        }
        if ((body = method.getBody()) == null) {
            return true;
        }
        return !ControlFlowUtils.containsReturn((PsiElement)body) && !ControlFlowUtils.codeBlockMayCompleteNormally(body);
    }

    public static boolean lambdaExpressionAlwaysThrowsException(PsiLambdaExpression expression) {
        PsiCodeBlock codeBlock;
        PsiElement body = expression.getBody();
        if (body instanceof PsiExpression) {
            return false;
        }
        return !(body instanceof PsiCodeBlock) || !ControlFlowUtils.containsReturn((PsiElement)(codeBlock = (PsiCodeBlock)body)) && !ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
    }

    @Contract(value="null -> false")
    public static boolean statementContainsNakedBreak(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    @Contract(value="null -> false")
    public static boolean statementContainsNakedContinue(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedContinueFinder breakFinder = new NakedContinueFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.continueFound();
    }

    @Contract(value="null, _ -> false")
    public static boolean statementBreaksLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (statement instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
            return breakStatement.findExitedStatement() == loop;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiCodeBlock block;
            PsiElement psiElement;
            PsiElement nextElement;
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            PsiLoopStatement cur = loop;
            PsiElement parent = cur.getParent();
            while (true) {
                if (parent instanceof PsiLabeledStatement) {
                    cur = parent;
                } else if (parent instanceof PsiCodeBlock) {
                    PsiCodeBlock block2 = (PsiCodeBlock)parent;
                    PsiStatement[] statements = block2.getStatements();
                    if (!(block2.getParent() instanceof PsiBlockStatement) || statements.length <= 0 || statements[statements.length - 1] != cur) break;
                    cur = block2.getParent();
                } else {
                    PsiIfStatement ifStatement;
                    if (!(parent instanceof PsiIfStatement) || cur != (ifStatement = (PsiIfStatement)parent).getThenBranch() && cur != ifStatement.getElseBranch()) break;
                    cur = parent;
                }
                parent = cur.getParent();
            }
            if ((nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)cur)) instanceof PsiReturnStatement) {
                PsiReturnStatement nextReturn = (PsiReturnStatement)nextElement;
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(returnValue, nextReturn.getReturnValue());
            }
            return returnValue == null && (psiElement = cur.getParent()) instanceof PsiCodeBlock && (block = (PsiCodeBlock)psiElement).getParent() instanceof PsiMethod && PsiUtil.isJavaToken((PsiElement)nextElement, (IElementType)JavaTokenType.RBRACE);
        }
        return false;
    }

    private static StreamEx<PsiExpression> conditions(PsiElement element) {
        return StreamEx.iterate((Object)element, e -> e != null && !(e instanceof PsiLambdaExpression) && !(e instanceof PsiMethod), PsiElement::getParent).pairMap((child, parent) -> parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getThenBranch() == child ? parent : null).select(PsiIfStatement.class).map(PsiIfStatement::getCondition).flatMap(cond -> cond instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)cond).getOperationTokenType().equals(JavaTokenType.ANDAND) ? StreamEx.of((Object[])((PsiPolyadicExpression)cond).getOperands()) : StreamEx.of((Object)cond));
    }

    public static boolean isExecutedOnceInLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (ControlFlowUtils.flowBreaksLoop(statement, loop)) {
            return true;
        }
        if (loop instanceof PsiForStatement) {
            boolean hasLoopVarCheck;
            PsiLocalVariable variable;
            PsiForStatement forLoop = (PsiForStatement)loop;
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forLoop.getInitialization(), PsiDeclarationStatement.class);
            PsiStatement update = forLoop.getUpdate();
            if (initialization != null && update != null && (variable = (PsiLocalVariable)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiLocalVariable.class).findFirst(var -> LoopDirection.evaluateLoopDirection((PsiVariable)var, update) != null).orElse(null)) != null && (hasLoopVarCheck = ((StreamEx)ControlFlowUtils.conditions((PsiElement)statement).select(PsiBinaryExpression.class).filter(binOp -> binOp.getOperationTokenType().equals(JavaTokenType.EQEQ))).anyMatch(binOp -> ExpressionUtils.getOtherOperand(binOp, (PsiVariable)variable) != null))) {
                return ContainerUtil.and(VariableAccessUtils.getVariableReferences((PsiVariable)variable), expression -> PsiTreeUtil.isAncestor((PsiElement)update, (PsiElement)expression, (boolean)false) || !PsiUtil.isAccessedForWriting((PsiExpression)expression));
            }
        }
        return false;
    }

    public static boolean isVariableReassigned(PsiStatement statement, PsiVariable variable) {
        PsiStatement sibling = ControlFlowUtils.nextExecutedStatement(statement);
        while (sibling != null) {
            PsiExpression rValue = ExpressionUtils.getAssignmentTo((PsiElement)sibling, variable);
            if (rValue != null && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rValue)) {
                return true;
            }
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)sibling)) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean flowBreaksLoop(PsiStatement statement, PsiLoopStatement loop) {
        if (statement == null || statement == loop) {
            return false;
        }
        PsiStatement sibling = statement;
        while (sibling != null) {
            if (sibling instanceof PsiContinueStatement) {
                PsiContinueStatement continueStatement = (PsiContinueStatement)sibling;
                PsiStatement continueTarget = continueStatement.findContinuedStatement();
                return PsiTreeUtil.isAncestor((PsiElement)continueTarget, (PsiElement)loop, (boolean)true);
            }
            if (sibling instanceof PsiThrowStatement || sibling instanceof PsiReturnStatement) {
                return true;
            }
            if (sibling instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)sibling;
                PsiStatement exitedStatement = breakStatement.findExitedStatement();
                if (exitedStatement == loop) {
                    return true;
                }
                return ControlFlowUtils.flowBreaksLoop(ControlFlowUtils.nextExecutedStatement(exitedStatement), loop);
            }
            if ((sibling instanceof PsiIfStatement || sibling instanceof PsiSwitchStatement) && !PsiTreeUtil.collectElementsOfType((PsiElement)sibling, (Class[])new Class[]{PsiContinueStatement.class}).isEmpty()) {
                return false;
            }
            if (sibling instanceof PsiLoopStatement && PsiTreeUtil.collectElements((PsiElement)sibling, e -> {
                PsiContinueStatement continueStatement;
                return e instanceof PsiContinueStatement && (continueStatement = (PsiContinueStatement)e).getLabelIdentifier() != null;
            }).length > 0) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Nullable
    private static PsiStatement firstStatement(@Nullable PsiStatement statement) {
        PsiStatement[] statements;
        while (statement instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)statement).getCodeBlock().getStatements()).length != 0) {
            statement = statements[0];
        }
        return statement;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiStatement nextExecutedStatement(PsiStatement statement) {
        if (statement == null) {
            return null;
        }
        PsiStatement next = ControlFlowUtils.firstStatement((PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class));
        if (next == null) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement || gParent instanceof PsiSwitchStatement) {
                    return ControlFlowUtils.nextExecutedStatement((PsiStatement)gParent);
                }
            } else if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement || parent instanceof PsiSwitchLabelStatement || parent instanceof PsiSwitchStatement) {
                return ControlFlowUtils.nextExecutedStatement((PsiStatement)parent);
            }
        }
        return next;
    }

    public static boolean isVariableReferencedBeforeStatementEntry(@NotNull ControlFlow flow, int start, PsiElement statement, @NotNull PsiVariable variable, @NotNull @Unmodifiable Set<Integer> excluded) {
        if (flow == null) {
            ControlFlowUtils.$$$reportNull$$$0(35);
        }
        if (variable == null) {
            ControlFlowUtils.$$$reportNull$$$0(36);
        }
        if (excluded == null) {
            ControlFlowUtils.$$$reportNull$$$0(37);
        }
        int statementStart = flow.getStartOffset(statement);
        int statementEnd = flow.getEndOffset(statement);
        List edges = ControlFlowUtil.getEdges((ControlFlow)flow, (int)start);
        Collections.reverse(edges);
        BitSet referenced = new BitSet();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ControlFlowUtil.ControlFlowEdge edge : edges) {
                int from = edge.myFrom;
                int to = edge.myTo;
                if (referenced.get(from)) {
                    if (to == statementStart && (from < statementStart || from >= statementEnd)) {
                        return true;
                    }
                    if (referenced.get(to) || excluded.contains(to)) continue;
                    referenced.set(to);
                    changed = true;
                    continue;
                }
                if (!ControlFlowUtil.isVariableAccess((ControlFlow)flow, (int)from, (PsiVariable)variable) || excluded.contains(from)) continue;
                referenced.set(from);
                referenced.set(to);
                if (to == statementStart) {
                    return true;
                }
                changed = true;
            }
        }
        return false;
    }

    @NotNull
    public static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiStatement statement) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(38);
            }
            return initializerUsageStatus;
        }
        if (ControlFlowUtils.isDeclarationJustBefore(var, statement)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.DECLARED_JUST_BEFORE;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(39);
            }
            return initializerUsageStatus;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class}) != PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class})) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(40);
            }
            return initializerUsageStatus;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        if (block == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(41);
            }
            return initializerUsageStatus;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)statement.getProject()).getControlFlow(block, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(42);
            }
            return initializerUsageStatus;
        }
        int start = controlFlow.getEndOffset((PsiElement)var.getInitializer()) + 1;
        int stop = controlFlow.getStartOffset((PsiElement)statement);
        if (ControlFlowUtils.isVariableReferencedBeforeStatementEntry(controlFlow, start, (PsiElement)statement, var, Collections.emptySet())) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(43);
            }
            return initializerUsageStatus;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop((ControlFlow)controlFlow, (int)start, (int)stop, (PsiVariable)var)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(44);
            }
            return initializerUsageStatus;
        }
        InitializerUsageStatus initializerUsageStatus = var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
        if (initializerUsageStatus == null) {
            ControlFlowUtils.$$$reportNull$$$0(45);
        }
        return initializerUsageStatus;
    }

    private static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        Object[] elements;
        PsiElement declaration = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration instanceof PsiDeclarationStatement && ArrayUtil.getLastElement((Object[])(elements = ((PsiDeclarationStatement)declaration).getDeclaredElements())) == var && nextStatement.equals((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration));
    }

    @Contract(value="null -> false")
    public static boolean statementIsEmpty(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement instanceof PsiBlockStatement) {
            PsiStatement[] codeBlockStatements;
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                if (ControlFlowUtils.statementIsEmpty(codeBlockStatement)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiReturnStatement getNextReturnStatement(PsiStatement statement) {
        PsiElement nextStatement;
        while (!((nextStatement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement)) instanceof PsiReturnStatement)) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
                if (statements.length == 0 || statements[statements.length - 1] != statement) {
                    return null;
                }
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiIfStatement) && !(parent instanceof PsiBlockStatement)) {
                return null;
            }
            statement = (PsiStatement)parent;
        }
        return (PsiReturnStatement)nextStatement;
    }

    public static boolean isReachable(@NotNull PsiStatement statement) {
        ControlFlow flow;
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(46);
        }
        PsiStatement block = statement;
        do {
            if ((block = PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class)) != null) continue;
            return true;
        } while (block.getParent() instanceof PsiSwitchStatement);
        try {
            flow = ControlFlowFactory.getInstance((Project)statement.getProject()).getControlFlow((PsiElement)block, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return ControlFlowUtil.isInstructionReachable((ControlFlow)flow, (int)flow.getStartOffset((PsiElement)statement), (int)0);
    }

    public static boolean isEmpty(PsiElement element, boolean commentIsContent, boolean emptyBlocks) {
        if (!commentIsContent && element instanceof PsiComment) {
            return true;
        }
        if (element instanceof PsiEmptyStatement) {
            return !commentIsContent || PsiTreeUtil.getChildOfType((PsiElement)element, PsiComment.class) == null && !(PsiTreeUtil.skipWhitespacesBackward((PsiElement)element) instanceof PsiComment);
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)element;
            return ControlFlowUtils.isEmpty((PsiElement)block.getCodeBlock(), commentIsContent, emptyBlocks);
        }
        if (emptyBlocks && element instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)element;
            PsiElement[] children = codeBlock.getChildren();
            if (children.length == 2) {
                return true;
            }
            for (int i = 1; i < children.length - 1; ++i) {
                PsiElement child = children[i];
                if (ControlFlowUtils.isEmpty(child, commentIsContent, true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void ensureElseBranch(PsiIfStatement ifStatement) {
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            if (!(elseBranch instanceof PsiBlockStatement)) {
                BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)elseBranch);
            }
        } else {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiBlockStatement emptyBlock = BlockUtils.createBlockStatement((Project)ifStatement.getProject());
            if (thenBranch == null) {
                ifStatement.setThenBranch((PsiStatement)emptyBlock);
            } else if (!(thenBranch instanceof PsiBlockStatement)) {
                BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)thenBranch);
            }
            ifStatement.setElseBranch((PsiStatement)emptyBlock);
        }
    }

    public static void processElementsInCurrentScope(final @NotNull PsiElement context, final @NotNull @NotNull Processor<? super @NotNull PsiElement> processor) {
        if (context == null) {
            ControlFlowUtils.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            ControlFlowUtils.$$$reportNull$$$0(48);
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean stop = false;

            Visitor() {
            }

            public void visitElement(@NotNull PsiElement psiElement) {
                PsiElement parent;
                if (psiElement == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                if (psiElement != context && (parent = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                boolean bl = this.stop = !processor.process((Object)psiElement);
                if (this.stop) {
                    return;
                }
                super.visitElement(psiElement);
            }

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                this.visitElement((PsiElement)aClass);
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    Visitor.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$1Visitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Visitor visitor2 = new Visitor();
        context.accept((PsiElementVisitor)visitor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 23, 38, 39, 40, 41, 42, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 25: 
            case 27: 
            case 29: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 23: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ControlFlowUtils";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapBlock";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializerUsageStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doWhileStatementMayCompleteNormally";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementMayCompleteNormally";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forStatementMayCompleteNormally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "conditionalLoopStatementMayCompleteNormally";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "switchStatementMayCompleteNormally";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementMayCompleteNormally";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementMayCompleteNormally";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "labeledStatementMayCompleteNormally";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "methodMayCompleteNormally";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "statementContainsBreakToStatementOrAncestor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "statementIsBreakTarget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "statementContainsContinueToAncestor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsReturn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "statementIsContinueTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsSystemExit";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsYield";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInLoop";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInFinallyBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInCatchBlock";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInExitStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInReturnStatementArgument";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInThrowStatementArgument";
                break;
            }
            case 22: 
            case 23: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "statementCompletesWithStatement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesWithStatement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "statementIsLastInBlock";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyChildOfType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasChildrenOfTypeCount";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNestedElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "methodAlwaysThrowsException";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReferencedBeforeStatementEntry";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isReachable";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processElementsInCurrentScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 23, 38, 39, 40, 41, 42, 43, 44, 45 -> new IllegalStateException(string);
        };
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;
        private final boolean myAncestor;

        BreakFinder(@NotNull PsiStatement target, boolean ancestor) {
            if (target == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            this.m_target = target;
            this.myAncestor = ancestor;
        }

        boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                BreakFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (this.myAncestor) {
                if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                    this.m_found = true;
                }
            } else if (exitedStatement == this.m_target) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (statement == null) {
                BreakFinder.$$$reportNull$$$0(2);
            }
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement) {
            this.statement = statement;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContinueToAncestorFinder.$$$reportNull$$$0(0);
            }
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement continueStatement) {
            if (continueStatement == null) {
                ContinueToAncestorFinder.$$$reportNull$$$0(1);
            }
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.statement, (boolean)true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueToAncestorFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myFound;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.myFound;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ReturnFinder.$$$reportNull$$$0(0);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                ReturnFinder.$$$reportNull$$$0(1);
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                ReturnFinder.$$$reportNull$$$0(2);
            }
            this.myFound = true;
            this.stopWalking();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            if (target == null) {
                ContinueFinder.$$$reportNull$$$0(0);
            }
            this.m_target = target;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                ContinueFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement);
            PsiStatement continuedStatement = statement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (statement == null) {
                ContinueFinder.$$$reportNull$$$0(2);
            }
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SystemExitFinder.$$$reportNull$$$0(0);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SystemExitFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            @NonNls String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class YieldFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myFound;

        private YieldFinder() {
        }

        private boolean yieldFound() {
            return this.myFound;
        }

        public void visitExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                YieldFinder.$$$reportNull$$$0(0);
            }
        }

        public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
            if (statement == null) {
                YieldFinder.$$$reportNull$$$0(1);
            }
            this.myFound = true;
            this.stopWalking();
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (statement == null) {
                YieldFinder.$$$reportNull$$$0(2);
            }
            if (this.myFound) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                YieldFinder.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$YieldFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYieldStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MethodCallFinder.$$$reportNull$$$0(0);
            }
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                MethodCallFinder.$$$reportNull$$$0(1);
            }
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$MethodCallFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                NakedBreakFinder.$$$reportNull$$$0(0);
            }
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(1);
            }
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
            this.stopWalking();
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(2);
            }
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(3);
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(4);
            }
        }

        public void visitForeachPatternStatement(@NotNull PsiForeachPatternStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(5);
            }
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(6);
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                NakedBreakFinder.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$NakedBreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachPatternStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NakedContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedContinueFinder() {
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                NakedContinueFinder.$$$reportNull$$$0(0);
            }
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(1);
            }
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(2);
            }
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(3);
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(4);
            }
        }

        public void visitForeachPatternStatement(@NotNull PsiForeachPatternStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(5);
            }
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                NakedContinueFinder.$$$reportNull$$$0(6);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$NakedContinueFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachPatternStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

