/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LoopDirection;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CountingLoop {
    @NotNull
    final PsiLocalVariable myCounter;
    @NotNull
    final PsiLoopStatement myLoop;
    @NotNull
    final PsiExpression myInitializer;
    @NotNull
    final PsiExpression myBound;
    final boolean myIncluding;
    final LoopDirection myDirection;
    final boolean myMayOverflow;

    private CountingLoop(@NotNull PsiLoopStatement loop, @NotNull PsiLocalVariable counter, @NotNull PsiExpression initializer, @NotNull PsiExpression bound, boolean including, @NotNull LoopDirection direction, boolean mayOverflow) {
        if (loop == null) {
            CountingLoop.$$$reportNull$$$0(0);
        }
        if (counter == null) {
            CountingLoop.$$$reportNull$$$0(1);
        }
        if (initializer == null) {
            CountingLoop.$$$reportNull$$$0(2);
        }
        if (bound == null) {
            CountingLoop.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            CountingLoop.$$$reportNull$$$0(4);
        }
        this.myInitializer = initializer;
        this.myCounter = counter;
        this.myLoop = loop;
        this.myBound = bound;
        this.myIncluding = including;
        this.myDirection = direction;
        this.myMayOverflow = mayOverflow;
    }

    @NotNull
    public PsiLocalVariable getCounter() {
        PsiLocalVariable psiLocalVariable = this.myCounter;
        if (psiLocalVariable == null) {
            CountingLoop.$$$reportNull$$$0(5);
        }
        return psiLocalVariable;
    }

    @NotNull
    public PsiLoopStatement getLoop() {
        PsiLoopStatement psiLoopStatement = this.myLoop;
        if (psiLoopStatement == null) {
            CountingLoop.$$$reportNull$$$0(6);
        }
        return psiLoopStatement;
    }

    @NotNull
    public PsiExpression getInitializer() {
        PsiExpression psiExpression = this.myInitializer;
        if (psiExpression == null) {
            CountingLoop.$$$reportNull$$$0(7);
        }
        return psiExpression;
    }

    @NotNull
    public PsiExpression getBound() {
        PsiExpression psiExpression = this.myBound;
        if (psiExpression == null) {
            CountingLoop.$$$reportNull$$$0(8);
        }
        return psiExpression;
    }

    public boolean isIncluding() {
        return this.myIncluding;
    }

    public boolean isDescending() {
        return this.myDirection == LoopDirection.DESCENDING;
    }

    public boolean mayOverflow() {
        return this.myMayOverflow;
    }

    @Nullable
    public static CountingLoop from(PsiForStatement forStatement) {
        PsiExpression bound;
        PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forStatement.getInitialization(), PsiDeclarationStatement.class);
        if (initialization == null) {
            return null;
        }
        PsiElement[] declaredElements = initialization.getDeclaredElements();
        if (declaredElements.length != 1) {
            return null;
        }
        PsiLocalVariable counter = (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
        if (counter == null) {
            return null;
        }
        PsiType counterType = counter.getType();
        if (!counterType.equals(PsiTypes.intType()) && !counterType.equals(PsiTypes.longType())) {
            return null;
        }
        PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)counter.getInitializer());
        if (initializer == null) {
            return null;
        }
        LoopDirection loopDirection = LoopDirection.evaluateLoopDirection((PsiVariable)counter, forStatement.getUpdate());
        if (loopDirection == null) {
            return null;
        }
        PsiBinaryExpression condition = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)forStatement.getCondition()), PsiBinaryExpression.class);
        if (condition == null) {
            return null;
        }
        IElementType type = condition.getOperationTokenType();
        boolean closed = false;
        RelationType relationType = DfaPsiUtil.getRelationByToken(type);
        if (relationType == null || !relationType.isInequality()) {
            return null;
        }
        if (relationType.isSubRelation(RelationType.EQ)) {
            closed = true;
        }
        if (loopDirection == LoopDirection.DESCENDING) {
            relationType = relationType.getFlipped();
            assert (relationType != null);
        }
        if ((bound = ExpressionUtils.getOtherOperand(condition, (PsiVariable)counter)) == null) {
            return null;
        }
        if (bound == condition.getLOperand()) {
            relationType = relationType.getFlipped();
            assert (relationType != null);
        }
        if (!relationType.isSubRelation(RelationType.LT)) {
            return null;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)counterType, (PsiExpression)bound)) {
            return null;
        }
        if (VariableAccessUtils.variableIsAssigned((PsiVariable)counter, (PsiElement)forStatement.getBody())) {
            return null;
        }
        return new CountingLoop((PsiLoopStatement)forStatement, counter, initializer, bound, closed, loopDirection, relationType == RelationType.NE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CountingLoop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CountingLoop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoop";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

