/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ExceptionUtils {
    private static final @Unmodifiable Set<String> s_genericExceptionTypes = Set.of("java.lang.Throwable", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Error");

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element) {
        return ExceptionUtils.calculateExceptionsThrown(element, new LinkedHashSet<PsiClassType>(5));
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element, @NotNull Set<PsiClassType> out) {
        if (out == null) {
            ExceptionUtils.$$$reportNull$$$0(0);
        }
        if (element == null) {
            Set<PsiClassType> set = out;
            if (set == null) {
                ExceptionUtils.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (element instanceof PsiResourceList) {
            PsiResourceList resourceList = (PsiResourceList)element;
            for (PsiResourceListElement resource : resourceList) {
                out.addAll(ExceptionUtil.getCloserExceptions((PsiResourceListElement)resource));
            }
        }
        ExceptionsThrownVisitor visitor2 = new ExceptionsThrownVisitor(out);
        element.accept((PsiElementVisitor)visitor2);
        Set<PsiClassType> set = out;
        if (set == null) {
            ExceptionUtils.$$$reportNull$$$0(2);
        }
        return set;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className);
    }

    public static boolean isThrowableRethrown(PsiParameter throwable, PsiCodeBlock catchBlock) {
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(catchBlock);
        if (!(lastStatement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
        PsiExpression expression = throwStatement.getException();
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement element = referenceExpression.resolve();
        return throwable.equals((Object)element);
    }

    static boolean statementThrowsException(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiReturnStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiExpressionListStatement || statement instanceof PsiForeachStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement instanceof PsiThrowStatement) {
            return true;
        }
        if (statement instanceof PsiForStatement) {
            return ExceptionUtils.forStatementThrowsException((PsiForStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ExceptionUtils.doWhileThrowsException((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement instanceof PsiIfStatement) {
            return ExceptionUtils.ifStatementThrowsException((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ExceptionUtils.tryStatementThrowsException((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        return ExceptionUtils.statementThrowsException(ifStatement.getThenBranch()) && ExceptionUtils.statementThrowsException(ifStatement.getElseBranch());
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        return ExceptionUtils.statementThrowsException(doWhileStatement.getBody());
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body;
        PsiExpression condition = whileStatement.getCondition();
        return BoolUtils.isTrue(condition) && ExceptionUtils.statementThrowsException(body = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update)) {
                return true;
            }
        }
        return false;
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement) {
        HashSet<PsiType> out = new HashSet<PsiType>(5);
        for (PsiParameter parameter : statement.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                out.addAll(disjunctionType.getDisjunctions());
                continue;
            }
            out.add(type);
        }
        return out;
    }

    public static boolean isExceptionArgument(@NotNull PsiExpression expression) {
        PsiNewExpression newExpression;
        if (expression == null) {
            ExceptionUtils.$$$reportNull$$$0(3);
        }
        if ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
            PsiType newExpressionType = newExpression.getType();
            if (InheritanceUtil.isInheritor((PsiType)newExpressionType, (String)"java.lang.Throwable")) {
                return true;
            }
        } else {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCallExpression)) {
                PsiMethod constructor = methodCallExpression.resolveMethod();
                return constructor != null && InheritanceUtil.isInheritor((PsiClass)constructor.getContainingClass(), (String)"java.lang.Throwable");
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateExceptionsThrown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateExceptionsThrown";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class ExceptionsThrownVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiClassType> myThrownExceptionTypes;

        private ExceptionsThrownVisitor(Set<PsiClassType> thrownTypes) {
            this.myThrownExceptionTypes = thrownTypes;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(0);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(1);
            }
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            if (callExpression == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(2);
            }
            super.visitCallExpression(callExpression);
            JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
            PsiElement target = resolveResult.getElement();
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiClassType[] referencedTypes = ((PsiMethod)target).getThrowsList().getReferencedTypes();
            this.myThrownExceptionTypes.addAll(ExceptionUtil.collectSubstituted((PsiSubstitutor)resolveResult.getSubstitutor(), (PsiClassType[])referencedTypes, (GlobalSearchScope)callExpression.getResolveScope()));
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(3);
            }
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (!(disjunction instanceof PsiClassType)) continue;
                    this.myThrownExceptionTypes.add((PsiClassType)disjunction);
                }
            } else if (PsiTypes.nullType().equals(type)) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
                PsiClassType npeType = factory.createTypeByFQClassName("java.lang.NullPointerException", statement.getResolveScope());
                this.myThrownExceptionTypes.add(npeType);
            } else if (type instanceof PsiClassType) {
                this.myThrownExceptionTypes.add((PsiClassType)type);
            }
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(4);
            }
            Set<PsiType> exceptionsHandled = ExceptionUtils.getExceptionTypesHandled(statement);
            for (PsiClassType resourceException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getResourceList())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)resourceException)) continue;
                this.myThrownExceptionTypes.add(resourceException);
            }
            for (PsiClassType tryException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getTryBlock())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)tryException)) continue;
                this.myThrownExceptionTypes.add(tryException);
            }
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getFinallyBlock(), this.myThrownExceptionTypes);
            for (PsiCodeBlock catchBlock : statement.getCatchBlocks()) {
                ExceptionUtils.calculateExceptionsThrown((PsiElement)catchBlock, this.myThrownExceptionTypes);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionsHandled, @NotNull PsiType thrownType) {
            if (thrownType == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(5);
            }
            return exceptionsHandled.contains(thrownType) || exceptionsHandled.stream().anyMatch(exceptionHandled -> exceptionHandled.isAssignableFrom(thrownType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThrowStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionHandled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

