/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpectedTypeUtils {
    private ExpectedTypeUtils() {
    }

    @Nullable
    public static PsiType findExpectedType(@NotNull PsiExpression expression, boolean calculateTypeForComplexReferences) {
        if (expression == null) {
            ExpectedTypeUtils.$$$reportNull$$$0(0);
        }
        return ExpectedTypeUtils.findExpectedType(expression, calculateTypeForComplexReferences, false);
    }

    public static PsiType findExpectedType(PsiExpression expression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
        PsiElement context = expression.getParent();
        PsiExpression wrappedExpression = expression;
        while (context instanceof PsiParenthesizedExpression) {
            wrappedExpression = (PsiExpression)context;
            context = context.getParent();
        }
        if (context == null) {
            return null;
        }
        ExpectedTypeVisitor visitor2 = new ExpectedTypeVisitor(wrappedExpression, calculateTypeForComplexReferences, reportCasts);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.getExpectedType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpectedTypeUtils", "findExpectedType"));
    }

    private static class ExpectedTypeVisitor
    extends JavaElementVisitor {
        private static final TokenSet arithmeticOps = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC});
        private static final TokenSet booleanOps = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.AND, JavaTokenType.XOR, JavaTokenType.OROR, JavaTokenType.OR});
        private static final TokenSet operatorAssignmentOps = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ, JavaTokenType.PERCEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ});
        @NotNull
        private final PsiExpression wrappedExpression;
        private final boolean calculateTypeForComplexReferences;
        private final boolean reportCasts;
        private PsiType expectedType;

        ExpectedTypeVisitor(@NotNull PsiExpression wrappedExpression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
            if (wrappedExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(0);
            }
            this.expectedType = null;
            this.wrappedExpression = wrappedExpression;
            this.calculateTypeForComplexReferences = calculateTypeForComplexReferences;
            this.reportCasts = reportCasts;
        }

        public PsiType getExpectedType() {
            return this.expectedType;
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            if (pair == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(1);
            }
            if (!this.wrappedExpression.equals((Object)pair.getValue())) {
                return;
            }
            PsiReference reference = pair.getReference();
            if (reference == null) {
                return;
            }
            PsiElement target = reference.resolve();
            if (target instanceof PsiAnnotationMethod) {
                this.expectedType = ((PsiMethod)target).getReturnType();
            }
        }

        public void visitField(@NotNull PsiField field) {
            PsiExpression initializer;
            if (field == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(2);
            }
            if (this.wrappedExpression.equals((Object)(initializer = field.getInitializer()))) {
                this.expectedType = field.getType();
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiTypeElement typeElement;
            if (variable == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((typeElement = variable.getTypeElement()) != null && !typeElement.isInferredType()) {
                this.expectedType = variable.getType();
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            PsiExpression condition;
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(4);
            }
            this.expectedType = this.wrappedExpression == (condition = statement.getAssertCondition()) ? PsiTypes.booleanType() : TypeUtils.getStringType((PsiElement)statement);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression initializer) {
            PsiType type;
            if (initializer == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(5);
            }
            if (!((type = initializer.getType()) instanceof PsiArrayType)) {
                this.expectedType = null;
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            this.expectedType = arrayType.getComponentType();
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression accessExpression) {
            PsiExpression indexExpression;
            if (accessExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(6);
            }
            if (this.wrappedExpression.equals((Object)(indexExpression = accessExpression.getIndexExpression()))) {
                this.expectedType = PsiTypes.intType();
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression) {
            PsiExpression[] operands;
            if (polyadicExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(7);
            }
            if ((operands = polyadicExpression.getOperands()).length < 2) {
                this.expectedType = null;
                return;
            }
            for (PsiExpression operand : operands) {
                if (operand != null && operand.getType() != null) continue;
                this.expectedType = null;
                return;
            }
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiType type = polyadicExpression.getType();
            PsiType wrappedExpressionType = this.wrappedExpression.getType();
            if (TypeUtils.isJavaLangString(type) || ExpectedTypeVisitor.isArithmeticOperation(tokenType) || ExpectedTypeVisitor.isBooleanOperation(tokenType)) {
                this.expectedType = type;
            } else if (ExpectedTypeVisitor.isShiftOperation(tokenType)) {
                this.expectedType = TypeUtils.unaryNumericPromotion(wrappedExpressionType);
            } else if (ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                PsiExpression operand1 = operands[0];
                PsiExpression operand2 = operands[1];
                if (operand1 == this.wrappedExpression || operand2 == this.wrappedExpression) {
                    PsiType type1 = operand1.getType();
                    PsiType type2 = operand2.getType();
                    this.expectedType = type1 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type1, type2) : (type2 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type2, type1) : TypeUtils.getObjectType((PsiElement)this.wrappedExpression));
                } else {
                    this.expectedType = TypeConversionUtil.isBooleanType((PsiType)wrappedExpressionType) ? PsiTypes.booleanType() : null;
                }
            } else if (ComparisonUtils.isComparisonOperation(tokenType)) {
                if (operands.length != 2) {
                    this.expectedType = null;
                    return;
                }
                if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)wrappedExpressionType) && PsiPrimitiveType.getUnboxedType((PsiType)wrappedExpressionType) == null) {
                    return;
                }
                this.expectedType = TypeConversionUtil.binaryNumericPromotion((PsiType)operands[0].getType(), (PsiType)operands[1].getType());
            } else {
                this.expectedType = null;
            }
        }

        private PsiType expectedPrimitiveType(PsiPrimitiveType type1, PsiType type2) {
            if (TypeConversionUtil.isNumericType((PsiType)type1)) {
                return TypeConversionUtil.isNumericType((PsiType)type2) ? TypeConversionUtil.binaryNumericPromotion((PsiType)type1, (PsiType)type2) : null;
            }
            if (PsiTypes.booleanType().equals((Object)type1)) {
                return TypeConversionUtil.isBooleanType((PsiType)type2) ? PsiTypes.booleanType() : null;
            }
            if (PsiTypes.nullType().equals(type1)) {
                return TypeUtils.getObjectType((PsiElement)this.wrappedExpression);
            }
            return null;
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            PsiType type;
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(8);
            }
            this.expectedType = (type = expression.getType()) instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType((PsiType)type);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(9);
            }
            this.visitSwitchBlock((PsiSwitchBlock)expression);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(10);
            }
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        private void visitSwitchBlock(PsiSwitchBlock switchBlock) {
            PsiExpression expression = switchBlock.getExpression();
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
            this.expectedType = unboxedType != null ? unboxedType : type;
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            PsiElement parent;
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(11);
            }
            if (!((parent = statement.getParent()) instanceof PsiSwitchLabeledRuleStatement)) {
                return;
            }
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)parent;
            PsiSwitchBlock block = switchLabeledRuleStatement.getEnclosingSwitchBlock();
            if (!(block instanceof PsiSwitchExpression)) {
                return;
            }
            PsiSwitchExpression switchExpression = (PsiSwitchExpression)block;
            this.expectedType = switchExpression.getType();
        }

        public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
            PsiSwitchExpression expression;
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(12);
            }
            if ((expression = statement.findEnclosingExpression()) != null) {
                this.expectedType = expression.getType();
            }
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(13);
            }
            if (this.reportCasts) {
                this.expectedType = expression.getType();
            }
        }

        public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(14);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(15);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(16);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(17);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            PsiExpression iteratedValue;
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(18);
            }
            if ((iteratedValue = statement.getIteratedValue()) == null) {
                this.expectedType = null;
                return;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            if (!(iteratedValueType instanceof PsiClassType)) {
                this.expectedType = null;
                return;
            }
            PsiClassType classType = (PsiClassType)iteratedValueType;
            PsiType[] parameters = classType.getParameters();
            PsiClass iterableClass = ClassUtils.findClass("java.lang.Iterable", (PsiElement)statement);
            this.expectedType = iterableClass == null ? null : JavaPsiFacade.getElementFactory((Project)statement.getProject()).createType(iterableClass, parameters);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(19);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(20);
            }
            this.expectedType = PsiTypes.booleanType();
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(21);
            }
            this.expectedType = TypeUtils.getObjectType((PsiElement)statement);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(22);
            }
            PsiExpression rExpression = assignment.getRExpression();
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression lExpression = assignment.getLExpression();
            PsiType lType = lExpression.getType();
            this.expectedType = this.wrappedExpression.equals((Object)rExpression) ? (lType == null ? null : (TypeUtils.isJavaLangString(lType) ? (JavaTokenType.PLUSEQ.equals(tokenType) ? rExpression.getType() : lType) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) ? (lType instanceof PsiPrimitiveType ? lType : PsiPrimitiveType.getUnboxedType((PsiType)lType)) : lType))) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) && !(lType instanceof PsiPrimitiveType) ? PsiPrimitiveType.getUnboxedType((PsiType)lType) : lType);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression conditional) {
            PsiExpression condition;
            if (conditional == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(23);
            }
            this.expectedType = (condition = conditional.getCondition()).equals((Object)this.wrappedExpression) ? PsiTypes.booleanType() : conditional.getType();
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(24);
            }
            this.expectedType = PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(25);
            }
            this.expectedType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(26);
            }
            this.expectedType = TypeUtils.getObjectType((PsiElement)expression);
        }

        public void visitDeclarationStatement(@NotNull PsiDeclarationStatement declaration) {
            PsiElement[] declaredElements;
            if (declaration == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(27);
            }
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiVariable variable;
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiVariable) || !this.wrappedExpression.equals((Object)(initializer = (variable = (PsiVariable)declaredElement).getInitializer()))) continue;
                this.expectedType = variable.getType();
                return;
            }
        }

        public void visitExpressionList(@NotNull PsiExpressionList expressionList) {
            JavaResolveResult result;
            PsiMethod method;
            if (expressionList == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(28);
            }
            if ((method = (PsiMethod)(result = ExpectedTypeVisitor.findCalledMethod(expressionList)).getElement()) == null) {
                this.expectedType = null;
            } else {
                int parameterPosition = ExpectedTypeVisitor.getParameterPosition(expressionList, this.wrappedExpression);
                this.expectedType = ExpectedTypeVisitor.getTypeOfParameter(result, parameterPosition);
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(29);
            }
            for (PsiExpression arrayDimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.wrappedExpression.equals((Object)arrayDimension)) continue;
                this.expectedType = PsiTypes.intType();
                break;
            }
        }

        @NotNull
        private static JavaResolveResult findCalledMethod(PsiExpressionList expressionList) {
            PsiElement grandParent;
            PsiElement parent = expressionList.getParent();
            if (parent instanceof PsiCall) {
                PsiCall call = (PsiCall)parent;
                JavaResolveResult javaResolveResult = call.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    ExpectedTypeVisitor.$$$reportNull$$$0(30);
                }
                return javaResolveResult;
            }
            if (parent instanceof PsiAnonymousClass && (grandParent = parent.getParent()) instanceof PsiCallExpression) {
                PsiCallExpression callExpression = (PsiCallExpression)grandParent;
                JavaResolveResult javaResolveResult = callExpression.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    ExpectedTypeVisitor.$$$reportNull$$$0(31);
                }
                return javaResolveResult;
            }
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(32);
            }
            return javaResolveResult;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(33);
            }
            if (this.calculateTypeForComplexReferences) {
                Project project = referenceExpression.getProject();
                JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    if (!ExpectedTypeVisitor.isAccessibleFrom((PsiMember)field, (PsiElement)referenceExpression)) {
                        return;
                    }
                    PsiClass aClass = field.getContainingClass();
                    if (aClass == null) {
                        return;
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else if (element instanceof PsiMethod) {
                    PsiClass aClass;
                    PsiType returnType;
                    PsiMethod method = (PsiMethod)element;
                    PsiElement parent = referenceExpression.getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
                        PsiType type = methodCallExpression.getType();
                        returnType = !PsiTypes.voidType().equals((Object)type) ? ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, true) : null;
                    } else {
                        returnType = null;
                    }
                    PsiClass methodContainingClass = method.getContainingClass();
                    if (methodContainingClass == null) {
                        return;
                    }
                    PsiMethod superMethod = ExpectedTypeVisitor.findDeepestVisibleSuperMethod(method, returnType, (PsiElement)referenceExpression);
                    if (superMethod != null) {
                        aClass = superMethod.getContainingClass();
                        if (aClass == null) {
                            return;
                        }
                        substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)methodContainingClass, (PsiSubstitutor)substitutor);
                    } else {
                        aClass = methodContainingClass;
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else {
                    this.expectedType = null;
                }
            }
        }

        @Nullable
        private static PsiMethod findDeepestVisibleSuperMethod(PsiMethod method, PsiType returnType, PsiElement element) {
            if (method.isConstructor()) {
                return null;
            }
            if (method.hasModifierProperty("static")) {
                return null;
            }
            if (method.hasModifierProperty("private")) {
                return null;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            HashSet thrownTypes = ContainerUtil.newHashSet((Object[])throwsList.getReferencedTypes());
            PsiMethod[] superMethods = aClass.findMethodsBySignature(method, true);
            PsiMethod topSuper = null;
            PsiClass topSuperContainingClass = null;
            block0: for (PsiMethod superMethod : superMethods) {
                PsiClassType[] superThrownTypes;
                PsiType superReturnType;
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || aClass.equals((Object)superClass) || !ExpectedTypeVisitor.isAccessibleFrom((PsiMember)superMethod, element) || returnType != null && ((superReturnType = superMethod.getReturnType()) == null || !returnType.isAssignableFrom(superReturnType)) || topSuper != null && superClass.isInheritor(topSuperContainingClass, true)) continue;
                PsiReferenceList superThrowsList = superMethod.getThrowsList();
                for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
                    if (!ExceptionUtil.isUncheckedException((PsiClassType)superThrownType) && !thrownTypes.contains(superThrownType)) continue block0;
                }
                topSuper = superMethod;
                topSuperContainingClass = superClass;
            }
            return topSuper;
        }

        private static boolean isAccessibleFrom(PsiMember member, PsiElement referencingLocation) {
            if (member.hasModifierProperty("public")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiClass referencingClass = PsiUtil.getContainingClass((PsiElement)referencingLocation);
            if (referencingClass == null) {
                return false;
            }
            if (referencingClass.equals((Object)containingClass)) {
                return true;
            }
            if (member.hasModifierProperty("private")) {
                return false;
            }
            return ClassUtils.inSamePackage((PsiElement)containingClass, referencingLocation);
        }

        private static boolean isArithmeticOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(34);
            }
            return arithmeticOps.contains(sign);
        }

        private static boolean isBooleanOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(35);
            }
            return booleanOps.contains(sign);
        }

        private static boolean isShiftOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(36);
            }
            return ElementType.SHIFT_OPS.contains(sign);
        }

        private static boolean isOperatorAssignmentOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(37);
            }
            return operatorAssignmentOps.contains(sign);
        }

        private static int getParameterPosition(@NotNull PsiExpressionList expressionList, PsiExpression expression) {
            if (expressionList == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(38);
            }
            return ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)expression);
        }

        @Nullable
        private static PsiType getTypeOfParameter(@NotNull JavaResolveResult result, int parameterPosition) {
            if (result == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(39);
            }
            if (parameterPosition < 0) {
                return null;
            }
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return null;
            }
            boolean isVarargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).getApplicabilityLevel() == 2;
            PsiType parameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)parameterPosition, (boolean)isVarargs);
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiType type = GenericsUtil.getVariableTypeByExpressionType((PsiType)substitutor.substitute(parameterType));
            if (type == null) {
                return null;
            }
            TypeStringCreator typeStringCreator = new TypeStringCreator();
            type.accept((PsiTypeVisitor)typeStringCreator);
            if (typeStringCreator.isModified()) {
                PsiManager manager = method.getManager();
                Project project = manager.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                try {
                    String typeString = typeStringCreator.getTypeString();
                    return factory.createTypeFromText(typeString, (PsiElement)method);
                }
                catch (IncorrectOperationException e) {
                    throw new AssertionError((Object)("incorrect type string generated from " + String.valueOf(type) + ": " + e.getMessage()));
                }
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 30, 31, 32 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappedExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessExpression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "polyadicExpression";
                    break;
                }
                case 8: 
                case 9: 
                case 13: 
                case 25: 
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whileStatement";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditional";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 28: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionList";
                    break;
                }
                case 30: 
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor";
                    break;
                }
                case 30: 
                case 31: 
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findCalledMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNameValuePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssertStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayAccessExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPolyadicExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUnaryExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitExpressionStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitYieldStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeCastExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchLabeledRuleStatement";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchLabelStatement";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWhileStatement";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForeachStatement";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIfStatement";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDoWhileStatement";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSynchronizedStatement";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssignmentExpression";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "visitConditionalExpression";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReturnStatement";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLambdaExpression";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInstanceOfExpression";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDeclarationStatement";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "visitExpressionList";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNewExpression";
                    break;
                }
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "isArithmeticOperation";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "isBooleanOperation";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "isShiftOperation";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "isOperatorAssignmentOperation";
                    break;
                }
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterPosition";
                    break;
                }
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeOfParameter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 30, 31, 32 -> new IllegalStateException(string);
            };
        }

        private static class TypeStringCreator
        extends PsiTypeVisitor<Object> {
            private final StringBuilder typeString = new StringBuilder();
            private boolean modified = false;

            private TypeStringCreator() {
            }

            public Object visitType(@NotNull PsiType type) {
                if (type == null) {
                    TypeStringCreator.$$$reportNull$$$0(0);
                }
                this.typeString.append(type.getCanonicalText());
                return super.visitType(type);
            }

            public Object visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiClassType classType;
                PsiClass aClass;
                PsiType extendsBound;
                if (wildcardType == null) {
                    TypeStringCreator.$$$reportNull$$$0(1);
                }
                if (wildcardType.isExtends() && (extendsBound = wildcardType.getExtendsBound()) instanceof PsiClassType && (aClass = (classType = (PsiClassType)extendsBound).resolve()) != null && aClass.hasModifierProperty("final")) {
                    this.modified = true;
                    return super.visitClassType(classType);
                }
                return super.visitWildcardType(wildcardType);
            }

            public Object visitClassType(@NotNull PsiClassType classType) {
                if (classType == null) {
                    TypeStringCreator.$$$reportNull$$$0(2);
                }
                PsiClassType rawType = classType.rawType();
                this.typeString.append(rawType.getCanonicalText());
                PsiType[] parameterTypes = classType.getParameters();
                if (parameterTypes.length > 0) {
                    this.typeString.append('<');
                    PsiType parameterType1 = parameterTypes[0];
                    if (parameterType1 != null) {
                        parameterType1.accept((PsiTypeVisitor)this);
                    }
                    for (int i = 1; i < parameterTypes.length; ++i) {
                        this.typeString.append(',');
                        PsiType parameterType = parameterTypes[i];
                        if (parameterType == null) continue;
                        parameterType.accept((PsiTypeVisitor)this);
                    }
                    this.typeString.append('>');
                }
                return null;
            }

            public String getTypeString() {
                return this.typeString.toString();
            }

            public boolean isModified() {
                return this.modified;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor$TypeStringCreator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

