/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FinalUtils {
    private FinalUtils() {
    }

    public static boolean canBeFinal(@NotNull PsiVariable variable) {
        if (variable == null) {
            FinalUtils.$$$reportNull$$$0(0);
        }
        if (variable.getInitializer() != null || variable instanceof PsiParameter) {
            return !VariableAccessUtils.variableIsAssigned(variable);
        }
        if (variable instanceof PsiField && !ControlFlowUtil.isFieldInitializedAfterObjectConstruction((PsiField)((PsiField)variable))) {
            return false;
        }
        return FinalUtils.checkIfElementViolatesFinality(variable);
    }

    private static boolean checkIfElementViolatesFinality(@NotNull PsiVariable variable) {
        PsiClass scope;
        if (variable == null) {
            FinalUtils.$$$reportNull$$$0(1);
        }
        Object object = scope = variable instanceof PsiField ? PsiUtil.getTopLevelClass((PsiElement)variable) : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (scope == null) {
            return false;
        }
        HashMap finalVarProblems = new HashMap();
        HashMap uninitializedVarProblems = new HashMap();
        PsiElementProcessor elementDoesNotViolateFinality = e -> FinalUtils.checkElementDoesNotViolateFinality(e, variable, uninitializedVarProblems, finalVarProblems);
        return PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)elementDoesNotViolateFinality);
    }

    public static boolean checkElementDoesNotViolateFinality(PsiElement e, PsiVariable variable, Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (!(e instanceof PsiReferenceExpression)) {
            return true;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)e;
        if (!ref.isReferenceTo((PsiElement)variable)) {
            return true;
        }
        if (!ControlFlowUtil.isInitializedBeforeUsage((PsiReferenceExpression)ref, (PsiVariable)variable, uninitializedVarProblems, (boolean)true)) {
            return false;
        }
        if (!PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
            return true;
        }
        if (!LocalsOrMyInstanceFieldsControlFlowPolicy.isLocalOrMyInstanceReference((PsiReferenceExpression)ref)) {
            return false;
        }
        if (ControlFlowUtil.isVariableAssignedInLoop((PsiReferenceExpression)ref, (PsiElement)variable)) {
            return false;
        }
        if (variable instanceof PsiField) {
            if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)ref) == null) {
                return false;
            }
            PsiElement innerScope = ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)ref);
            if (innerScope != null && innerScope != ((PsiField)variable).getContainingClass()) {
                return false;
            }
        }
        return ControlFlowUtil.findFinalVariableAlreadyInitializedProblem((PsiVariable)variable, (PsiReferenceExpression)ref, finalVarProblems) == ControlFlowUtil.DoubleInitializationProblem.NO_PROBLEM;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "variable";
        objectArray2[1] = "com/siyeh/ig/psiutils/FinalUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeFinal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfElementViolatesFinality";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

