/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FormatUtils {
    public static final CallMatcher STRING_FORMATTED = CallMatcher.instanceCall("java.lang.String", "formatted").parameterTypes("java.lang.Object...");
    @NonNls
    private static final @Unmodifiable Set<String> formatMethodNames = Set.of("format", "printf");
    private static final @Unmodifiable Set<String> formatClassNames = Set.of("java.io.Console", "java.io.PrintWriter", "java.io.PrintStream", "java.util.Formatter", "java.lang.String");

    private FormatUtils() {
    }

    public static boolean isFormatCall(PsiMethodCallExpression expression) {
        return FormatUtils.isFormatCall(expression, Collections.emptyList(), Collections.emptyList());
    }

    public static boolean isFormatCall(PsiMethodCallExpression expression, @Unmodifiable List<String> optionalMethods, @Unmodifiable List<String> optionalClasses) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!(name != null && formatMethodNames.contains(name) || optionalMethods.contains(name))) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return className != null && formatClassNames.contains(className) || optionalClasses.contains(className);
    }

    public static boolean isFormatCallArgument(PsiElement element) {
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiStatement.class, PsiClass.class});
        if (expressionList == null) {
            return false;
        }
        PsiElement parent = expressionList.getParent();
        return parent instanceof PsiMethodCallExpression && FormatUtils.isFormatCall((PsiMethodCallExpression)parent);
    }

    @Nullable
    public static PsiExpression getFormatArgument(PsiExpressionList argumentList) {
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return null;
        }
        PsiExpression firstArgument = arguments[0];
        PsiType type = firstArgument.getType();
        if (type == null) {
            return null;
        }
        int formatArgumentIndex = "java.util.Locale".equals(type.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
        return arguments[formatArgumentIndex];
    }
}

