/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportUtils {
    private ImportUtils() {
    }

    public static void addImportIfNeeded(@NotNull PsiClass aClass, @NotNull PsiElement context) {
        String packageName;
        PsiFile file;
        if (aClass == null) {
            ImportUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(1);
        }
        if (!((file = context.getContainingFile()) instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null ? PsiTreeUtil.isAncestor((PsiElement)javaFile, (PsiElement)aClass, (boolean)true) : PsiTreeUtil.isAncestor((PsiElement)outerClass, (PsiElement)context, (boolean)true) && ClassUtils.isInsideClassBody(context, outerClass)) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        String containingPackageName = javaFile.getPackageName();
        if (containingPackageName.equals(packageName = ClassUtil.extractPackageName((String)qualifiedName)) || importList.findSingleClassImportStatement(qualifiedName) != null) {
            return;
        }
        OnDemandImportConflict conflict = null;
        ImplicitImportChecker implicitImportChecker = ImportUtils.createImplicitImportChecker(javaFile);
        if (implicitImportChecker.isImplicitlyImported(qualifiedName, false) && implicitImportChecker.isImplicitlyImported(qualifiedName, false, conflict = ImportUtils.findOnDemandImportConflict(qualifiedName, (PsiElement)javaFile))) {
            return;
        }
        if (importList.findOnDemandImportStatement(packageName) != null) {
            if (conflict == null) {
                conflict = ImportUtils.findOnDemandImportConflict(qualifiedName, (PsiElement)javaFile);
            }
            if (!conflict.hasConflictForOnDemand()) {
                return;
            }
        }
        if (ContainerUtil.exists((Object[])importList.getImportModuleStatements(), moduleStatement -> moduleStatement.findImportedPackage(packageName) != null)) {
            if (conflict == null) {
                conflict = ImportUtils.findOnDemandImportConflict(qualifiedName, (PsiElement)javaFile);
            }
            if (conflict == OnDemandImportConflict.NO_CONFLICTS) {
                return;
            }
        }
        if (ImportUtils.hasExactImportConflict(qualifiedName, javaFile)) {
            return;
        }
        PsiImportStatement importStatement = JavaPsiFacade.getElementFactory((Project)importList.getProject()).createImportStatement(aClass);
        importList.add((PsiElement)importStatement);
    }

    private static boolean hasAccessibleMemberWithName(@NotNull PsiClass containingClass, @NotNull String memberName, @NotNull PsiElement context) {
        PsiMethod[] methods;
        PsiField field;
        if (containingClass == null) {
            ImportUtils.$$$reportNull$$$0(2);
        }
        if (memberName == null) {
            ImportUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(4);
        }
        if ((field = containingClass.findFieldByName(memberName, true)) != null && PsiUtil.isAccessible((PsiMember)field, (PsiElement)context, null)) {
            return true;
        }
        for (PsiMethod method : methods = containingClass.findMethodsByName(memberName, true)) {
            if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)context, null)) continue;
            return true;
        }
        PsiClass innerClass = containingClass.findInnerClassByName(memberName, true);
        return innerClass != null && PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)context, null);
    }

    public static boolean nameCanBeImported(@NotNull String fqName, @NotNull PsiElement context) {
        PsiFile containingFile;
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(6);
        }
        if (!((containingFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile file = (PsiJavaFile)containingFile;
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        while (containingClass != null) {
            PsiClass[] innerClasses;
            String shortName = ClassUtil.extractClassName((String)fqName);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            if (resolveHelper.resolveAccessibleReferencedVariable(shortName, context) != null) {
                return false;
            }
            for (PsiClass innerClass : innerClasses = containingClass.getAllInnerClasses()) {
                if (innerClass.hasModifierProperty("private") && !containingClass.equals((Object)innerClass.getContainingClass()) || innerClass.hasModifierProperty("packageLocal") && !ClassUtils.inSamePackage((PsiElement)innerClass, (PsiElement)containingClass) || !shortName.equals(innerClass.getName())) continue;
                return fqName.equals(innerClass.getQualifiedName());
            }
            if (shortName.equals(containingClass.getName())) {
                return fqName.equals(containingClass.getQualifiedName());
            }
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
        }
        if (ImportUtils.hasExactImportConflict(fqName, file)) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict(fqName, (PsiElement)file, true, true, true) && !ImportUtils.isAlreadyImported(file, fqName)) {
            return false;
        }
        if (ImportUtils.containsConflictingReference((PsiFile)file, fqName)) {
            return false;
        }
        if (ImportUtils.containsConflictingClassName(fqName, file)) {
            return false;
        }
        return !ImportUtils.containsConflictingTypeParameter(fqName, context);
    }

    public static boolean isAlreadyImported(@NotNull PsiJavaFile file, @NotNull String fullyQualifiedName) {
        if (file == null) {
            ImportUtils.$$$reportNull$$$0(7);
        }
        if (fullyQualifiedName == null) {
            ImportUtils.$$$reportNull$$$0(8);
        }
        String className = ImportUtils.extractClassName(file, fullyQualifiedName);
        Project project = file.getProject();
        PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance((Project)project);
        PsiClass psiClass = resolveHelper.resolveReferencedClass(className, (PsiElement)file);
        return psiClass != null && fullyQualifiedName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    private static String extractClassName(@NotNull PsiJavaFile file, @NotNull String fullyQualifiedName) {
        if (file == null) {
            ImportUtils.$$$reportNull$$$0(9);
        }
        if (fullyQualifiedName == null) {
            ImportUtils.$$$reportNull$$$0(10);
        }
        for (PsiClass aClass : file.getClasses()) {
            String outerClassName = aClass.getQualifiedName();
            if (outerClassName == null || !fullyQualifiedName.startsWith(outerClassName)) continue;
            String string = fullyQualifiedName.substring(outerClassName.lastIndexOf(46) + 1);
            if (string == null) {
                ImportUtils.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = ClassUtil.extractClassName((String)fullyQualifiedName);
        if (string == null) {
            ImportUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean containsConflictingTypeParameter(String fqName, PsiElement context) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        for (PsiElement parent = context.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiTypeParameterListOwner)) continue;
            for (PsiTypeParameter parameter : ((PsiTypeParameterListOwner)parent).getTypeParameters()) {
                if (!shortName.equals(parameter.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsConflictingClassName(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        String shortName = ClassUtil.extractClassName((String)fqName);
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!shortName.equals(aClass.getName()) || fqName.equals(aClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file) {
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        String shortName = ClassUtil.extractClassName((String)fqName);
        String dottedShortName = "." + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static OnDemandImportConflict findOnDemandImportConflict(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(14);
        }
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PACKAGE_IMPORTS_SHADOW_MODULE_IMPORTS, (PsiElement)context)) {
            boolean onDemandConflict = ImportUtils.hasOnDemandImportConflict(fqName, context, false, true, false);
            boolean moduleConflict = ImportUtils.hasOnDemandImportConflict(fqName, context, false, false, true);
            OnDemandImportConflict onDemandImportConflict = OnDemandImportConflict.from(onDemandConflict, moduleConflict);
            if (onDemandImportConflict == null) {
                ImportUtils.$$$reportNull$$$0(15);
            }
            return onDemandImportConflict;
        }
        boolean demandImportConflict = ImportUtils.hasOnDemandImportConflict(fqName, context, false, true, true);
        OnDemandImportConflict onDemandImportConflict = OnDemandImportConflict.from(demandImportConflict, demandImportConflict);
        if (onDemandImportConflict == null) {
            ImportUtils.$$$reportNull$$$0(16);
        }
        return onDemandImportConflict;
    }

    @Deprecated(forRemoval=true)
    public static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiElement context) {
        OnDemandImportConflict conflict;
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(17);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(18);
        }
        return (conflict = ImportUtils.findOnDemandImportConflict(fqName, context)) != OnDemandImportConflict.NO_CONFLICTS;
    }

    private static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiElement context, boolean strict, boolean considerOnDemand, boolean considerModules) {
        PsiFile containingFile;
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(19);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(20);
        }
        if (!((containingFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList imports = javaFile.getImportList();
        if (imports == null) {
            return false;
        }
        List importStatements = ContainerUtil.append((List)ImportsUtil.getAllImplicitImports((PsiJavaFile)javaFile), (Object[])imports.getAllImportStatements());
        ThreeState state = ImportUtils.hasOnDemandImportConflictWithImports(javaFile, importStatements, fqName, strict, considerOnDemand, considerModules);
        if (state != ThreeState.UNSURE) {
            return state.toBoolean();
        }
        return considerOnDemand && ImportUtils.hasDefaultImportConflict(fqName, javaFile);
    }

    public static boolean hasOnDemandImportConflictWithImports(@NotNull PsiJavaFile javaFile, @NotNull List<? extends PsiImportStatementBase> importStatements, @NotNull String fqName, boolean checkOnDemand, boolean checkModules) {
        if (javaFile == null) {
            ImportUtils.$$$reportNull$$$0(21);
        }
        if (importStatements == null) {
            ImportUtils.$$$reportNull$$$0(22);
        }
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(23);
        }
        return ImportUtils.hasOnDemandImportConflictWithImports(javaFile, importStatements, fqName, false, checkOnDemand, checkModules) == ThreeState.YES;
    }

    private static ThreeState hasOnDemandImportConflictWithImports(@NotNull PsiJavaFile javaFile, @NotNull List<? extends PsiImportStatementBase> importStatements, @NotNull String fqName, boolean strict, boolean checkOnDemand, boolean checkModules) {
        if (javaFile == null) {
            ImportUtils.$$$reportNull$$$0(24);
        }
        if (importStatements == null) {
            ImportUtils.$$$reportNull$$$0(25);
        }
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(26);
        }
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        @Nullable PsiClass importedClass = JavaPsiFacade.getInstance((Project)javaFile.getProject()).findClass(packageName, javaFile.getResolveScope());
        block0: for (PsiImportStatementBase psiImportStatementBase : importStatements) {
            PsiMethod[] methods;
            String qualifiedName;
            String packageText;
            PsiJavaCodeReferenceElement importReference;
            if (!psiImportStatementBase.isOnDemand()) continue;
            if (checkModules && psiImportStatementBase instanceof PsiImportModuleStatement) {
                PsiImportModuleStatement moduleStatement = (PsiImportModuleStatement)psiImportStatementBase;
                if (DumbService.isDumb((Project)javaFile.getProject())) {
                    return ThreeState.YES;
                }
                Ref result = new Ref(null);
                PsiJavaModule module = moduleStatement.resolveTargetModule();
                if (module == null) {
                    return ThreeState.UNSURE;
                }
                JavaModuleGraphUtil.JavaModuleScope scope = JavaModuleGraphUtil.JavaModuleScope.moduleWithTransitiveScope(module);
                if (scope == null) {
                    return ThreeState.UNSURE;
                }
                PsiShortNamesCache.getInstance((Project)javaFile.getProject()).processClassesWithName(shortName, currentClass -> {
                    PsiPackage currentResolvedPackage;
                    ThreeState state;
                    if (!currentClass.hasModifierProperty("public")) {
                        return true;
                    }
                    if (currentClass.getContainingClass() != null) {
                        return true;
                    }
                    String qualifiedName = currentClass.getQualifiedName();
                    if (qualifiedName == null) {
                        return true;
                    }
                    String currentPackage = ClassUtil.extractPackageName((String)qualifiedName);
                    if (currentPackage == null) {
                        return true;
                    }
                    if (currentPackage.equals(packageName)) {
                        return true;
                    }
                    PsiPackageAccessibilityStatement aPackage = moduleStatement.findImportedPackage(currentPackage);
                    if (aPackage == null || aPackage.getPackageReference() == null) {
                        return true;
                    }
                    PsiElement resolvedPackage = aPackage.getPackageReference().resolve();
                    if (resolvedPackage instanceof PsiPackage && (state = ImportUtils.hasOnDemandImportConflictInPackage(currentResolvedPackage = (PsiPackage)resolvedPackage, shortName, (PsiFile)javaFile, fqName, strict)) != ThreeState.UNSURE) {
                        result.set((Object)state.toBoolean());
                        return false;
                    }
                    return true;
                }, (GlobalSearchScope)scope, null);
                if (result.get() != null) {
                    return ThreeState.fromBoolean((boolean)((Boolean)result.get()));
                }
            }
            if (!checkOnDemand || (importReference = psiImportStatementBase.getImportReference()) == null || (packageText = importReference.getText()).equals(packageName)) continue;
            PsiElement element = importReference.resolve();
            if (element instanceof PsiPackage) {
                PsiPackage aPackage = (PsiPackage)element;
                ThreeState state = ImportUtils.hasOnDemandImportConflictInPackage(aPackage, shortName, (PsiFile)javaFile, fqName, strict);
                if (state == ThreeState.UNSURE) continue;
                return state;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            PsiClass innerClass = aClass.findInnerClassByName(shortName, true);
            if (psiImportStatementBase instanceof PsiImportStatement) {
                if (innerClass == null || !PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)javaFile, null) || fqName.equals(qualifiedName = innerClass.getQualifiedName()) || strict && !ImportUtils.containsConflictingReference((PsiFile)javaFile, qualifiedName)) continue;
                return ThreeState.YES;
            }
            if (innerClass != null && PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)javaFile, null) && innerClass.hasModifierProperty("static") && !fqName.equals(qualifiedName = innerClass.getQualifiedName()) && (!strict || ImportUtils.memberReferenced((PsiMember)innerClass, (PsiElement)javaFile))) {
                return ThreeState.YES;
            }
            PsiField field = aClass.findFieldByName(shortName, true);
            if (field != null && PsiUtil.isAccessible((PsiMember)field, (PsiElement)javaFile, null) && field.hasModifierProperty("static")) {
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                String qualifiedName2 = containingClass.getQualifiedName() + "." + field.getName();
                if (!(fqName.equals(qualifiedName2) || strict && !ImportUtils.memberReferenced((PsiMember)field, (PsiElement)javaFile))) {
                    return ThreeState.YES;
                }
            }
            for (PsiMethod method : methods = aClass.findMethodsByName(shortName, true)) {
                PsiClass containingClass;
                if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)javaFile, null) || !method.hasModifierProperty("static") || (containingClass = method.getContainingClass()) == null) continue;
                String qualifiedName3 = containingClass.getQualifiedName() + "." + method.getName();
                boolean theSameMethod = fqName.equals(qualifiedName3) || !containingClass.isInterface() && importedClass != null && importedClass.isInheritor(containingClass, true);
                if (theSameMethod) continue block0;
                if (strict && !ImportUtils.memberReferenced((PsiMember)method, (PsiElement)javaFile)) continue;
                return ThreeState.YES;
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState hasOnDemandImportConflictInPackage(@NotNull PsiPackage aPackage, @NotNull String shortName, @NotNull PsiFile containingFile, @NotNull String fqName, boolean strict) {
        if (aPackage == null) {
            ImportUtils.$$$reportNull$$$0(27);
        }
        if (shortName == null) {
            ImportUtils.$$$reportNull$$$0(28);
        }
        if (containingFile == null) {
            ImportUtils.$$$reportNull$$$0(29);
        }
        if (fqName == null) {
            ImportUtils.$$$reportNull$$$0(30);
        }
        if (!strict) {
            if (aPackage.findClassByShortName(shortName, containingFile.getResolveScope()).length > 0) {
                return ThreeState.YES;
            }
        } else {
            int n = 0;
            PsiClass[] classes = aPackage.findClassByShortName(shortName, containingFile.getResolveScope());
            PsiClass[] psiClassArray = classes;
            int n2 = psiClassArray.length;
            if (n < n2) {
                PsiClass aClass = psiClassArray[n];
                String qualifiedClassName = aClass.getQualifiedName();
                if (qualifiedClassName == null || fqName.equals(qualifiedClassName)) {
                    return ThreeState.UNSURE;
                }
                return ThreeState.fromBoolean((boolean)ImportUtils.containsConflictingReference(containingFile, qualifiedClassName));
            }
        }
        return ThreeState.UNSURE;
    }

    private static boolean hasDefaultImportConflict(String fqName, PsiJavaFile file) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        String filePackageName = file.getPackageName();
        if (filePackageName.equals(packageName)) {
            return false;
        }
        Project project = file.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage filePackage = psiFacade.findPackage(filePackageName);
        return filePackage != null && filePackage.hasClassWithShortName(shortName, file.getResolveScope());
    }

    public static boolean addStaticImport(@NotNull String qualifierClass, @NonNls @NotNull String memberName, @NotNull PsiElement context) {
        PsiFile contextFile;
        PsiClass containingClass;
        if (qualifierClass == null) {
            ImportUtils.$$$reportNull$$$0(31);
        }
        if (memberName == null) {
            ImportUtils.$$$reportNull$$$0(32);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(33);
        }
        if (ClassUtils.isInsideClassBody(context, containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class))) {
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)qualifierClass)) {
                return true;
            }
            if (ImportUtils.hasAccessibleMemberWithName(containingClass, memberName, context)) {
                return false;
            }
        }
        if (!((contextFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)contextFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement != null) {
            if (existingImportStatement instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)existingImportStatement;
                if (!memberName.equals(importStaticStatement.getReferenceName())) {
                    return false;
                }
                PsiClass targetClass = importStaticStatement.resolveTargetClass();
                return targetClass != null && qualifierClass.equals(targetClass.getQualifiedName());
            }
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, qualifierClass);
        if (onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(qualifierClass + "." + memberName, (PsiElement)javaFile, false, true, false)) {
            return true;
        }
        Project project = context.getProject();
        GlobalSearchScope scope = context.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = psiFacade.findClass(qualifierClass, scope);
        if (aClass == null || !PsiUtil.isAccessible((PsiMember)aClass, (PsiElement)contextFile, null) || !ImportUtils.hasAccessibleMemberWithName(aClass, memberName, (PsiElement)contextFile)) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        List<PsiImportStaticStatement> imports = ImportUtils.getMatchingImports(importList, qualifiedName);
        int onDemandCount = JavaFileCodeStyleFacade.forContext((PsiFile)contextFile).getNamesCountToUseImportOnDemand();
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (imports.size() + 1 < onDemandCount) {
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, memberName));
        } else {
            for (PsiImportStaticStatement importStatement : imports) {
                importStatement.delete();
            }
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, "*"));
        }
        return true;
    }

    @Nullable
    private static PsiImportStaticStatement findOnDemandImportStaticStatement(PsiImportList importList, String qualifierClass) {
        Object[] importStaticStatements = importList.getImportStaticStatements();
        List additionalOnDemandImports = new ArrayList();
        PsiFile psiFile = importList.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            additionalOnDemandImports = ContainerUtil.filterIsInstance((Collection)ImportsUtil.getAllImplicitImports((PsiJavaFile)javaFile), PsiImportStaticStatement.class);
        }
        for (PsiImportStaticStatement importStaticStatement : ContainerUtil.append(additionalOnDemandImports, (Object[])importStaticStatements)) {
            String text;
            PsiJavaCodeReferenceElement importReference;
            if (!importStaticStatement.isOnDemand() || (importReference = importStaticStatement.getImportReference()) == null || !qualifierClass.equals(text = importReference.getText())) continue;
            return importStaticStatement;
        }
        return null;
    }

    private static List<PsiImportStaticStatement> getMatchingImports(@NotNull PsiImportList importList, @NotNull String className) {
        if (importList == null) {
            ImportUtils.$$$reportNull$$$0(34);
        }
        if (className == null) {
            ImportUtils.$$$reportNull$$$0(35);
        }
        ArrayList<PsiImportStaticStatement> imports = new ArrayList<PsiImportStaticStatement>();
        List additionalOnDemandImports = new ArrayList();
        PsiFile psiFile = importList.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            additionalOnDemandImports = ContainerUtil.filterIsInstance((Collection)ImportsUtil.getAllImplicitImports((PsiJavaFile)javaFile), PsiImportStaticStatement.class);
        }
        for (PsiImportStaticStatement staticStatement : ContainerUtil.append(additionalOnDemandImports, (Object[])importList.getImportStaticStatements())) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !className.equals(psiClass.getQualifiedName())) continue;
            imports.add(staticStatement);
        }
        return imports;
    }

    public static boolean isStaticallyImported(@NotNull PsiMember member, @NotNull PsiElement context) {
        PsiImportStaticStatement importStaticStatement;
        PsiClass importClass;
        PsiClass memberClass;
        if (member == null) {
            ImportUtils.$$$reportNull$$$0(36);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(37);
        }
        if ((memberClass = member.getContainingClass()) == null) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            return false;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        String memberName = member.getName();
        if (memberName == null) {
            return false;
        }
        if (ImportUtils.hasImplicitStaticImport(javaFile, memberClass.getQualifiedName() + "." + memberName)) {
            return true;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement instanceof PsiImportStaticStatement && InheritanceUtil.isInheritorOrSelf((PsiClass)(importClass = (importStaticStatement = (PsiImportStaticStatement)existingImportStatement).resolveTargetClass()), (PsiClass)memberClass, (boolean)true)) {
            return true;
        }
        String memberClassName = memberClass.getQualifiedName();
        if (memberClassName == null) {
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, memberClassName);
        return onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(memberClassName + "." + memberName, (PsiElement)javaFile, false, true, false);
    }

    private static boolean hasImplicitStaticImport(@NotNull PsiJavaFile file, @NotNull String name) {
        if (file == null) {
            ImportUtils.$$$reportNull$$$0(38);
        }
        if (name == null) {
            ImportUtils.$$$reportNull$$$0(39);
        }
        return ImportUtils.createImplicitImportChecker(file).isImplicitlyImported(name, true);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ImplicitImportChecker createImplicitImportChecker(@NotNull PsiJavaFile file) {
        if (file == null) {
            ImportUtils.$$$reportNull$$$0(40);
        }
        return new ImplicitImportChecker(file);
    }

    private static boolean memberReferenced(PsiMember member, PsiElement context) {
        MemberReferenceVisitor visitor2 = new MemberReferenceVisitor(member);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isReferenceFound();
    }

    public static boolean isReferenceCorrectWithoutQualifier(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiMember member) {
        String referenceName;
        if (reference == null) {
            ImportUtils.$$$reportNull$$$0(41);
        }
        if (member == null) {
            ImportUtils.$$$reportNull$$$0(42);
        }
        if ((referenceName = reference.getReferenceName()) == null) {
            return false;
        }
        Project project = reference.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
        PsiVariable newTarget = null;
        if (member instanceof PsiMethod) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)reference.getParent().copy();
            PsiElement qualifier = methodCallExpression.getMethodExpression().getQualifier();
            assert (qualifier != null);
            qualifier.delete();
            newTarget = methodCallExpression.resolveMethod();
        } else if (member instanceof PsiField) {
            newTarget = resolveHelper.resolveAccessibleReferencedVariable(referenceName, (PsiElement)reference);
        } else if (member instanceof PsiClass) {
            newTarget = resolveHelper.resolveReferencedClass(referenceName, (PsiElement)reference);
        }
        return member.equals((Object)newTarget);
    }

    public static boolean isAlreadyStaticallyImported(PsiJavaCodeReferenceElement reference) {
        if (reference instanceof PsiMethodReferenceExpression) {
            return false;
        }
        PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)ObjectUtils.tryCast((Object)reference.getQualifier(), PsiJavaCodeReferenceElement.class);
        if (qualifier == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
            return false;
        }
        if (GenericsUtil.isGenericReference((PsiJavaCodeReferenceElement)reference, (PsiJavaCodeReferenceElement)qualifier)) {
            return false;
        }
        PsiMember member = (PsiMember)ObjectUtils.tryCast((Object)reference.resolve(), PsiMember.class);
        if (member == null) {
            return false;
        }
        if (!(qualifier.resolve() instanceof PsiClass)) {
            return false;
        }
        return ImportUtils.isStaticallyImported(member, (PsiElement)reference) && ImportUtils.isReferenceCorrectWithoutQualifier(reference, member);
    }

    private static boolean containsConflictingReference(PsiFile element, String fullyQualifiedName) {
        Map cachedValue = (Map)CachedValuesManager.getCachedValue((PsiElement)element, () -> new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        Boolean conflictingRef = (Boolean)cachedValue.get(fullyQualifiedName);
        if (conflictingRef != null) {
            return conflictingRef;
        }
        ConflictingClassReferenceVisitor visitor2 = new ConflictingClassReferenceVisitor(fullyQualifiedName);
        element.accept((PsiElementVisitor)visitor2);
        conflictingRef = visitor2.isConflictingReferenceFound();
        cachedValue.put(fullyQualifiedName, conflictingRef);
        return conflictingRef;
    }

    @NotNull
    public static List<PsiImportModuleStatement> optimizeModuleImports(@NotNull PsiJavaFile file) {
        if (file == null) {
            ImportUtils.$$$reportNull$$$0(43);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return new CachedValueProvider.Result(List.of(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            List<PsiImportModuleStatement> statements = Arrays.asList(importList.getImportModuleStatements());
            List implicit = ContainerUtil.filterIsInstance((Collection)ImportsUtil.getAllImplicitImports((PsiJavaFile)file), PsiImportModuleStatement.class);
            ArrayList<PsiImportModuleStatement> results = new ArrayList<PsiImportModuleStatement>(statements);
            HashMap<PsiImportModuleStatement, PsiJavaModule> modules = new HashMap<PsiImportModuleStatement, PsiJavaModule>();
            HashMap<PsiJavaModule, Set> dependencies = new HashMap<PsiJavaModule, Set>();
            HashSet<PsiImportModuleStatement> toDelete = new HashSet<PsiImportModuleStatement>();
            List allImports = ContainerUtil.concat((List)implicit, statements);
            block0: for (PsiImportModuleStatement current : statements) {
                PsiJavaModule currentModule = modules.computeIfAbsent(current, m -> m.resolveTargetModule());
                if (currentModule == null) continue;
                for (PsiImportModuleStatement higher : allImports) {
                    Set higherDependencies;
                    PsiJavaModule higherModule;
                    if (toDelete.contains(higher) || higher == current || (higherModule = modules.computeIfAbsent(higher, m -> m.resolveTargetModule())) == null || !(higherDependencies = dependencies.computeIfAbsent(higherModule, m -> JavaResolveUtil.getAllTransitiveModulesIncludeCurrent((PsiJavaModule)m))).contains(currentModule)) continue;
                    toDelete.add(current);
                    continue block0;
                }
            }
            results.removeAll(toDelete);
            return new CachedValueProvider.Result(results, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (list == null) {
            ImportUtils.$$$reportNull$$$0(44);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 15, 16, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 14: 
            case 18: 
            case 20: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 19: 
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 7: 
            case 9: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedName";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ImportUtils";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatements";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ImportUtils";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOnDemandImportConflict";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeModuleImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addImportIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasAccessibleMemberWithName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nameCanBeImported";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyImported";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 44: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findOnDemandImportConflict";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasOnDemandImportConflict";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasOnDemandImportConflictWithImports";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasOnDemandImportConflictInPackage";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addStaticImport";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingImports";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyImported";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitStaticImport";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitImportChecker";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceCorrectWithoutQualifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "optimizeModuleImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 15, 16, 44 -> new IllegalStateException(string);
        };
    }

    public static class ImplicitImportChecker {
        @NotNull
        private final Map<String, PsiImportStaticStatement> myStaticImportStatements;
        @NotNull
        private final Set<PsiImportModuleStatement> myModulesStatements;
        @NotNull
        private final Map<String, PsiImportStatement> myPackageStatements;
        @NotNull
        private final Map<ImplicitCacheItem, Boolean> myCache;

        private ImplicitImportChecker(@NotNull PsiJavaFile file) {
            if (file == null) {
                ImplicitImportChecker.$$$reportNull$$$0(0);
            }
            this.myStaticImportStatements = new HashMap<String, PsiImportStaticStatement>();
            this.myModulesStatements = new HashSet<PsiImportModuleStatement>();
            this.myPackageStatements = new HashMap<String, PsiImportStatement>();
            this.myCache = new HashMap<ImplicitCacheItem, Boolean>();
            for (PsiImportStatementBase anImport : ImportsUtil.getAllImplicitImports((PsiJavaFile)file)) {
                PsiImportStatement packageStatement;
                String qualifiedName;
                if (anImport instanceof PsiImportStaticStatement) {
                    String referenceName;
                    PsiImportStaticStatement staticStatement = (PsiImportStaticStatement)anImport;
                    PsiJavaCodeReferenceElement importReference = staticStatement.getImportReference();
                    if (importReference == null || (referenceName = importReference.getQualifiedName()) == null) continue;
                    this.myStaticImportStatements.put(staticStatement.isOnDemand() ? referenceName : StringUtil.getPackageName((String)referenceName), staticStatement);
                    continue;
                }
                if (anImport instanceof PsiImportModuleStatement) {
                    PsiImportModuleStatement moduleStatement = (PsiImportModuleStatement)anImport;
                    this.myModulesStatements.add(moduleStatement);
                    continue;
                }
                if (!(anImport instanceof PsiImportStatement) || (qualifiedName = (packageStatement = (PsiImportStatement)anImport).getQualifiedName()) == null || !packageStatement.isOnDemand()) continue;
                this.myPackageStatements.put(qualifiedName, packageStatement);
            }
        }

        public boolean isImplicitlyImported(String qName, boolean isStatic) {
            return this.isImplicitlyImported(qName, isStatic, OnDemandImportConflict.NO_CONFLICTS);
        }

        public boolean isImplicitlyImported(String qName, boolean isStatic, @NotNull OnDemandImportConflict conflicts) {
            PsiImportStaticStatement psiImportStaticStatement;
            ImplicitCacheItem cacheItem;
            Boolean result;
            if (conflicts == null) {
                ImplicitImportChecker.$$$reportNull$$$0(1);
            }
            if ((result = this.myCache.get(cacheItem = new ImplicitCacheItem(qName, isStatic, conflicts))) != null) {
                return result;
            }
            String packageOrClassName = StringUtil.getPackageName((String)qName);
            String className = ClassUtil.extractClassName((String)qName);
            if (!isStatic) {
                if (conflicts == OnDemandImportConflict.NO_CONFLICTS) {
                    for (PsiImportModuleStatement psiImportModuleStatement : this.myModulesStatements) {
                        PsiPackage psiPackage;
                        PsiElement resolved;
                        PsiJavaCodeReferenceElement reference;
                        PsiPackageAccessibilityStatement importedPackage = psiImportModuleStatement.findImportedPackage(packageOrClassName);
                        if (importedPackage == null || (reference = importedPackage.getPackageReference()) == null || !((resolved = reference.resolve()) instanceof PsiPackage) || !(psiPackage = (PsiPackage)resolved).containsClassNamed(className)) continue;
                        this.myCache.put(cacheItem, true);
                        return true;
                    }
                }
                if (!conflicts.hasConflictForOnDemand() && this.myPackageStatements.containsKey(packageOrClassName)) {
                    this.myCache.put(cacheItem, true);
                    return true;
                }
            } else if (!conflicts.hasConflictForOnDemand() && (psiImportStaticStatement = this.myStaticImportStatements.get(packageOrClassName)) != null) {
                if (psiImportStaticStatement.isOnDemand()) {
                    this.myCache.put(cacheItem, true);
                    return true;
                }
                PsiJavaCodeReferenceElement reference = psiImportStaticStatement.getImportReference();
                if (reference == null) {
                    this.myCache.put(cacheItem, false);
                    return false;
                }
                String qualifiedName = reference.getQualifiedName();
                boolean equals = qName.equals(qualifiedName);
                this.myCache.put(cacheItem, equals);
                return equals;
            }
            this.myCache.put(cacheItem, false);
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ImportUtils$ImplicitImportChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isImplicitlyImported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        record ImplicitCacheItem(String qName, boolean isStatic, @NotNull OnDemandImportConflict conflicts) {
            @NotNull
            private final OnDemandImportConflict conflicts;

            ImplicitCacheItem(String qName, boolean isStatic, @NotNull OnDemandImportConflict conflicts) {
                if (conflicts == null) {
                    ImplicitCacheItem.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public OnDemandImportConflict conflicts() {
                OnDemandImportConflict onDemandImportConflict = this.conflicts;
                if (onDemandImportConflict == null) {
                    ImplicitCacheItem.$$$reportNull$$$0(1);
                }
                return onDemandImportConflict;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conflicts";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/siyeh/ig/psiutils/ImportUtils$ImplicitImportChecker$ImplicitCacheItem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/siyeh/ig/psiutils/ImportUtils$ImplicitImportChecker$ImplicitCacheItem";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "conflicts";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static enum OnDemandImportConflict {
        NO_CONFLICTS(false, false),
        ON_DEMAND_IMPORT_CONFLICTS(true, false),
        MODULE_CONFLICTS(false, true),
        ON_DEMAND_AND_MODULE_CONFLICT(true, true);

        private final boolean myConflictForOnDemand;
        private final boolean myConflictForModules;

        private OnDemandImportConflict(boolean conflictForOnDemand, boolean conflictForModules) {
            this.myConflictForOnDemand = conflictForOnDemand;
            this.myConflictForModules = conflictForModules;
        }

        public boolean hasConflictForOnDemand() {
            return this.myConflictForOnDemand;
        }

        public boolean hasConflictForModules() {
            return this.myConflictForModules;
        }

        private static OnDemandImportConflict from(boolean conflictForOnDemand, boolean conflictForModules) {
            if (conflictForOnDemand && conflictForModules) {
                return ON_DEMAND_AND_MODULE_CONFLICT;
            }
            if (conflictForOnDemand) {
                return ON_DEMAND_IMPORT_CONFLICTS;
            }
            if (conflictForModules) {
                return MODULE_CONFLICTS;
            }
            return NO_CONFLICTS;
        }
    }

    private static class MemberReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMember[] members;
        private boolean referenceFound;

        MemberReferenceVisitor(PsiMember member) {
            this.members = new PsiMember[]{member};
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                MemberReferenceVisitor.$$$reportNull$$$0(0);
            }
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            for (PsiMember member : this.members) {
                if (!member.equals((Object)target)) continue;
                this.referenceFound = true;
                return;
            }
        }

        boolean isReferenceFound() {
            return this.referenceFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/psiutils/ImportUtils$MemberReferenceVisitor", "visitReferenceElement"));
        }
    }

    private static class ConflictingClassReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String name;
        private final String fullyQualifiedName;
        private boolean referenceFound;

        ConflictingClassReferenceVisitor(String fullyQualifiedName) {
            this.name = ClassUtil.extractClassName((String)fullyQualifiedName);
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ConflictingClassReferenceVisitor.$$$reportNull$$$0(0);
            }
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiClass aClass;
            block8: {
                block7: {
                    if (reference == null) {
                        ConflictingClassReferenceVisitor.$$$reportNull$$$0(1);
                    }
                    if (this.referenceFound) {
                        return;
                    }
                    super.visitReferenceElement(reference);
                    if (reference.getQualifier() != null) {
                        return;
                    }
                    PsiElement element = reference.resolve();
                    if (!(element instanceof PsiClass)) break block7;
                    aClass = (PsiClass)element;
                    if (!(element instanceof PsiTypeParameter)) break block8;
                }
                return;
            }
            String testClassName = aClass.getName();
            String testClassQualifiedName = aClass.getQualifiedName();
            if (testClassQualifiedName == null || testClassName == null || testClassQualifiedName.equals(this.fullyQualifiedName) || !testClassName.equals(this.name)) {
                return;
            }
            this.referenceFound = true;
        }

        boolean isConflictingReferenceFound() {
            return this.referenceFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ImportUtils$ConflictingClassReferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

