/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedContainer {
    @NotNull
    private final PsiExpression myQualifier;

    protected IndexedContainer(@NotNull PsiExpression qualifier) {
        if (qualifier == null) {
            IndexedContainer.$$$reportNull$$$0(0);
        }
        this.myQualifier = qualifier;
    }

    public abstract boolean isGetMethodReference(PsiMethodReferenceExpression var1);

    public abstract PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression var1);

    public abstract PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression var1);

    @NotNull
    public PsiExpression getQualifier() {
        PsiExpression psiExpression = this.myQualifier;
        if (psiExpression == null) {
            IndexedContainer.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    public boolean isQualifierEquivalent(@Nullable PsiExpression candidate) {
        return (candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate)) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myQualifier, (PsiElement)candidate);
    }

    public abstract PsiType getElementType();

    @Nullable
    public static IndexedContainer fromLengthExpression(@Nullable PsiExpression expression) {
        PsiExpression qualifier;
        PsiMethodCallExpression call;
        PsiExpression arrayExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getArrayFromLengthExpression(expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)));
        if (arrayExpression != null) {
            return new ArrayIndexedContainer(arrayExpression);
        }
        if (expression instanceof PsiMethodCallExpression && ListIndexedContainer.isSizeCall(call = (PsiMethodCallExpression)expression) && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier(call.getMethodExpression()))) != null) {
            return new ListIndexedContainer(qualifier);
        }
        return null;
    }

    @Nullable
    public static IndexedContainer arrayContainerWithBound(@NotNull PsiArrayAccessExpression arrayAccessExpression, @NotNull PsiExpression bound) {
        PsiReferenceExpression reference;
        PsiElement psiElement;
        PsiExpression arrayExpression;
        if (arrayAccessExpression == null) {
            IndexedContainer.$$$reportNull$$$0(2);
        }
        if (bound == null) {
            IndexedContainer.$$$reportNull$$$0(3);
        }
        if (!((arrayExpression = arrayAccessExpression.getArrayExpression()) instanceof PsiReferenceExpression) || !((psiElement = (reference = (PsiReferenceExpression)arrayExpression).resolve()) instanceof PsiVariable)) {
            return null;
        }
        PsiVariable arrayVariable = (PsiVariable)psiElement;
        PsiExpression initializer = arrayVariable.getInitializer();
        if (!(initializer instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length != 1) {
            return null;
        }
        PsiExpression dimension = dimensions[0];
        PsiVariable dimensionVariable = ExpressionUtils.resolveVariable(dimension);
        PsiVariable boundVariable = ExpressionUtils.resolveVariable(bound);
        if (dimensionVariable == null || boundVariable == null || !dimensionVariable.isEquivalentTo((PsiElement)boundVariable)) {
            return null;
        }
        if (VariableAccessUtils.variableIsAssigned(dimensionVariable) || VariableAccessUtils.variableIsAssigned(arrayVariable)) {
            return null;
        }
        return new ArrayIndexedContainer(arrayExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/IndexedContainer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/IndexedContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "arrayContainerWithBound";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class ArrayIndexedContainer
    extends IndexedContainer {
        ArrayIndexedContainer(@NotNull PsiExpression qualifier) {
            if (qualifier == null) {
                ArrayIndexedContainer.$$$reportNull$$$0(0);
            }
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            return false;
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)indexExpression.getParent())) instanceof PsiExpression && PsiTreeUtil.isAncestor((PsiElement)this.extractIndexFromGetExpression((PsiExpression)parent), (PsiElement)indexExpression, (boolean)false)) {
                return (PsiExpression)parent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression) {
            PsiArrayAccessExpression arrayAccess;
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiArrayAccessExpression && this.isQualifierEquivalent((arrayAccess = (PsiArrayAccessExpression)expression).getArrayExpression())) {
                return arrayAccess.getIndexExpression();
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type = this.getQualifier().getType();
            return type instanceof PsiArrayType ? ((PsiArrayType)type).getComponentType() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/siyeh/ig/psiutils/IndexedContainer$ArrayIndexedContainer", "<init>"));
        }
    }

    static class ListIndexedContainer
    extends IndexedContainer {
        ListIndexedContainer(@NotNull PsiExpression qualifier) {
            if (qualifier == null) {
                ListIndexedContainer.$$$reportNull$$$0(0);
            }
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            if (!"get".equals(methodReference.getReferenceName())) {
                return false;
            }
            if (!this.isQualifierEquivalent(ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)methodReference))) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodReference.resolve(), PsiMethod.class);
            return method != null && MethodUtils.methodMatches(method, "java.util.List", null, "get", new PsiType[]{PsiTypes.intType()});
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement gParent;
            PsiElement parent;
            if (indexExpression != null && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)indexExpression.getParent())) instanceof PsiExpressionList && (gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiMethodCallExpression && PsiTreeUtil.isAncestor((PsiElement)this.extractIndexFromGetExpression((PsiExpression)gParent), (PsiElement)indexExpression, (boolean)false)) {
                return (PsiExpression)gParent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1 && ListIndexedContainer.isGetCall(call) && this.isQualifierEquivalent(ExpressionUtils.getEffectiveQualifier(call.getMethodExpression()))) {
                return args[0];
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type = PsiUtil.substituteTypeParameter((PsiType)this.getQualifier().getType(), (String)"java.util.List", (int)0, (boolean)false);
            return GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
        }

        static boolean isGetCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", null, "get", new PsiType[]{PsiTypes.intType()});
        }

        static boolean isSizeCall(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.util.List", (PsiType)PsiTypes.intType(), "size", new PsiType[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/siyeh/ig/psiutils/IndexedContainer$ListIndexedContainer", "<init>"));
        }
    }
}

