/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.java.codeserver.core.JavaPsiVariableUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstanceOfUtils {
    private InstanceOfUtils() {
    }

    public static PsiInstanceOfExpression getConflictingInstanceof(@Nullable PsiType castType, @NotNull PsiReferenceExpression operand, @NotNull PsiElement context) {
        if (operand == null) {
            InstanceOfUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            InstanceOfUtils.$$$reportNull$$$0(1);
        }
        if (!(castType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)castType;
        if (classType.resolve() instanceof PsiTypeParameter) {
            return null;
        }
        PsiClassType rawType = classType.rawType();
        InstanceofChecker checker = new InstanceofChecker(operand, (PsiType)rawType, false);
        PsiStatement sibling = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        while (sibling != null) {
            PsiMethodCallExpression call;
            if (sibling instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)sibling;
                condition = ifStatement.getCondition();
                if (condition != null) {
                    if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch())) {
                        checker.negate = true;
                        checker.checkExpression(condition);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    } else if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getElseBranch())) {
                        checker.negate = false;
                        checker.checkExpression(condition);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    }
                }
            } else if (sibling instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)sibling;
                condition = assertStatement.getAssertCondition();
                checker.negate = false;
                checker.checkExpression(condition);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            } else if (sibling instanceof PsiExpressionStatement && InstanceOfUtils.isInstanceOfAssertionCall(checker, call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)sibling).getExpression(), PsiMethodCallExpression.class))) {
                return null;
            }
            sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        }
        checker.negate = false;
        PsiElement parent = InstanceOfUtils.findInterestingParent(context);
        while (parent != null) {
            IElementType tokenType;
            IElementType iElementType = tokenType = parent instanceof PsiPolyadicExpression ? ((PsiPolyadicExpression)parent).getOperationTokenType() : null;
            if (JavaTokenType.ANDAND.equals(tokenType) || JavaTokenType.OROR.equals(tokenType)) {
                checker.negate = tokenType.equals(JavaTokenType.OROR);
                for (PsiExpression expression : ((PsiPolyadicExpression)parent).getOperands()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)context, (boolean)false)) break;
                    expression.accept((PsiElementVisitor)checker);
                    if (!checker.hasAgreeingInstanceof()) continue;
                    return null;
                }
                checker.negate = false;
            } else {
                parent.accept((PsiElementVisitor)checker);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            }
            parent = InstanceOfUtils.findInterestingParent(parent);
        }
        if (checker.hasAgreeingInstanceof()) {
            return null;
        }
        return checker.getConflictingInstanceof();
    }

    @Nullable
    private static PsiElement findInterestingParent(@NotNull PsiElement context) {
        if (context == null) {
            InstanceOfUtils.$$$reportNull$$$0(2);
        }
        PsiElement parent;
        while ((parent = context.getParent()) != null) {
            IElementType tokenType;
            if (parent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
                return parent;
            }
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() != context) {
                return parent;
            }
            if (parent instanceof PsiConditionalLoopStatement && ((PsiConditionalLoopStatement)parent).getCondition() != context) {
                return parent;
            }
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != context) {
                return parent;
            }
            context = parent;
        }
        return null;
    }

    private static boolean isInstanceOfAssertionCall(@NotNull InstanceofChecker checker, @Nullable PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (checker == null) {
            InstanceOfUtils.$$$reportNull$$$0(3);
        }
        if (call == null) {
            return false;
        }
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
        if (contracts.isEmpty()) {
            return false;
        }
        MethodContract contract = contracts.get(0);
        if (!contract.getReturnValue().isFail()) {
            return false;
        }
        ContractValue condition = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
        if (condition == null) {
            return false;
        }
        checker.negate = true;
        OptionalInt argNum = condition.getArgumentComparedTo(ContractValue.booleanValue(true), true);
        if (argNum.isEmpty()) {
            checker.negate = false;
            argNum = condition.getArgumentComparedTo(ContractValue.booleanValue(false), true);
        }
        if (argNum.isEmpty()) {
            return false;
        }
        int index = argNum.getAsInt();
        if (index >= (args = call.getArgumentList().getExpressions()).length) {
            return false;
        }
        checker.checkExpression(args[index]);
        return checker.hasAgreeingInstanceof();
    }

    public static boolean hasAgreeingInstanceof(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            InstanceOfUtils.$$$reportNull$$$0(4);
        }
        PsiType castType = expression.getType();
        PsiExpression operand = expression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        PsiElement parent = InstanceOfUtils.findInterestingParent((PsiElement)expression);
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return true;
            }
            parent = InstanceOfUtils.findInterestingParent(parent);
        }
        return false;
    }

    @Nullable
    public static PsiInstanceOfExpression findPatternCandidate(@NotNull PsiTypeCastExpression cast) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(5);
        }
        return InstanceOfUtils.findPatternCandidate(cast, null);
    }

    @Nullable
    public static PsiInstanceOfExpression findPatternCandidate(@NotNull PsiTypeCastExpression cast, @Nullable PsiVariable variable) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(6);
        }
        if (InstanceOfUtils.isUncheckedCast(cast)) {
            return null;
        }
        return InstanceOfUtils.findCorrespondingInstanceOf(cast, variable);
    }

    public static boolean isUncheckedCast(@NotNull PsiTypeCastExpression cast) {
        PsiTypeElement castType;
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(7);
        }
        if ((castType = cast.getCastType()) == null) {
            return true;
        }
        PsiExpression castOperand = cast.getOperand();
        if (castOperand == null) {
            return true;
        }
        PsiType type = castOperand.getType();
        if (type == null) {
            return true;
        }
        return JavaGenericsUtil.isUncheckedCast((PsiType)castType.getType(), (PsiType)type);
    }

    @Nullable
    public static PsiInstanceOfExpression findCorrespondingInstanceOf(@NotNull PsiTypeCastExpression cast) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(8);
        }
        return InstanceOfUtils.findCorrespondingInstanceOf(cast, null);
    }

    @Nullable
    public static PsiInstanceOfExpression findCorrespondingInstanceOf(@NotNull PsiTypeCastExpression cast, @Nullable PsiVariable variable) {
        PsiElement context;
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(9);
        }
        if ((context = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getContext())) instanceof PsiLocalVariable) {
            context = context.getContext();
        } else {
            while (true) {
                boolean whenTrue;
                PsiInstanceOfExpression instanceOf;
                PsiConditionalExpression conditional;
                PsiExpression condition;
                PsiInstanceOfExpression instanceOf2;
                PsiPolyadicExpression polyadic;
                IElementType tokenType;
                if (context instanceof PsiPolyadicExpression && ((tokenType = (polyadic = (PsiPolyadicExpression)context).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) && (instanceOf2 = InstanceOfUtils.findInstanceOf((PsiExpression)polyadic, cast, tokenType.equals(JavaTokenType.ANDAND), variable)) != null) {
                    return instanceOf2;
                }
                if (context instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)(condition = (conditional = (PsiConditionalExpression)context).getCondition()), (PsiElement)cast, (boolean)true) && (instanceOf = InstanceOfUtils.findInstanceOf(condition, cast, whenTrue = PsiTreeUtil.isAncestor((PsiElement)conditional.getThenExpression(), (PsiElement)cast, (boolean)false), variable)) != null) {
                    return instanceOf;
                }
                if ((!(context instanceof PsiExpression) || context instanceof PsiLambdaExpression) && !(context instanceof PsiExpressionList) && !(context instanceof PsiLocalVariable) && !(context instanceof DummyHolder)) break;
                context = context.getContext();
            }
            if (!(context instanceof PsiStatement)) {
                return null;
            }
        }
        PsiVariable operandVariable = ExpressionUtils.resolveVariable(cast.getOperand());
        return InstanceOfUtils.walkBackAndUpToFindInstanceOf(context, operandVariable, variable, cast);
    }

    @Nullable
    private static PsiInstanceOfExpression walkBackAndUpToFindInstanceOf(@Nullable PsiElement context, @Nullable PsiVariable operandVariable, @Nullable PsiVariable variable, @NotNull PsiTypeCastExpression cast) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(10);
        }
        if (context == null) {
            return null;
        }
        ResultOfInstanceOf resultOfInstanceOf = InstanceOfUtils.processOfPreviousStatements(context, operandVariable, variable, cast);
        context = resultOfInstanceOf.context;
        if (context == null) {
            return resultOfInstanceOf.instanceOf;
        }
        PsiElement parent = context.getContext();
        PsiInstanceOfExpression expression = InstanceOfUtils.processParent(cast, context, parent, variable);
        if (expression != null) {
            return expression;
        }
        return InstanceOfUtils.walkBackAndUpToFindInstanceOf(parent, operandVariable, variable, cast);
    }

    @NotNull
    private static ResultOfInstanceOf processOfPreviousStatements(@Nullable PsiElement context, @Nullable PsiVariable operandVariable, @Nullable PsiVariable variable, @NotNull PsiTypeCastExpression cast) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(11);
        }
        if (context == null) {
            return new ResultOfInstanceOf(null, null);
        }
        PsiElement parent = context.getContext();
        if (parent instanceof PsiCodeBlock) {
            for (PsiElement stmt = context.getPrevSibling(); stmt != null; stmt = stmt.getPrevSibling()) {
                PsiInstanceOfExpression instanceOf;
                PsiConditionalLoopStatement loop;
                PsiIfStatement ifStatement;
                if (stmt instanceof PsiIfStatement && InstanceOfUtils.conditionMayContainCorrespondingInstanceOf((ifStatement = (PsiIfStatement)stmt).getCondition(), cast)) {
                    PsiInstanceOfExpression instanceOf2;
                    boolean elseCompletes;
                    PsiStatement thenBranch = ifStatement.getThenBranch();
                    PsiStatement elseBranch = ifStatement.getElseBranch();
                    boolean thenCompletes = InstanceOfUtils.canCompleteNormally(parent, thenBranch);
                    if (thenCompletes != (elseCompletes = InstanceOfUtils.canCompleteNormally(parent, elseBranch)) && (instanceOf2 = InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, thenCompletes, variable)) != null) {
                        return new ResultOfInstanceOf(null, instanceOf2);
                    }
                }
                if ((stmt instanceof PsiWhileStatement || stmt instanceof PsiDoWhileStatement || stmt instanceof PsiForStatement) && InstanceOfUtils.conditionMayContainCorrespondingInstanceOf((loop = (PsiConditionalLoopStatement)stmt).getCondition(), cast) && PsiTreeUtil.processElements((PsiElement)loop, e -> {
                    PsiBreakStatement breakStatement;
                    return !(e instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)e).findExitedStatement() != loop;
                }) && (instanceOf = InstanceOfUtils.findInstanceOf(loop.getCondition(), cast, false, variable)) != null) {
                    return new ResultOfInstanceOf(null, instanceOf);
                }
                if (stmt instanceof PsiSwitchLabelStatementBase) break;
                if (operandVariable == null || !VariableAccessUtils.variableIsAssigned(operandVariable, stmt)) continue;
                return new ResultOfInstanceOf(null, null);
            }
            if (parent.getContext() instanceof PsiBlockStatement) {
                context = parent.getContext();
            }
        }
        return new ResultOfInstanceOf(context, null);
    }

    private static boolean conditionMayContainCorrespondingInstanceOf(@Nullable PsiExpression condition, @NotNull PsiTypeCastExpression cast) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(12);
        }
        if (condition == null) {
            return false;
        }
        final PsiExpression castOperand = cast.getOperand();
        if (castOperand == null) {
            return false;
        }
        var visitor2 = new JavaRecursiveElementVisitor(){
            boolean found = false;

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.found) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
                PsiExpression instanceOperand;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)(instanceOperand = expression.getOperand()), (PsiElement)castOperand)) {
                    this.found = true;
                    return;
                }
                super.visitInstanceOfExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/InstanceOfUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitInstanceOfExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        condition.accept((PsiElementVisitor)visitor2);
        return visitor2.found;
    }

    @Nullable
    public static PsiTypeElement findCheckTypeElement(@NotNull PsiInstanceOfExpression expression) {
        PsiTypeElement typeElement;
        if (expression == null) {
            InstanceOfUtils.$$$reportNull$$$0(13);
        }
        if ((typeElement = expression.getCheckType()) == null) {
            typeElement = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)expression.getPattern());
        }
        return typeElement;
    }

    private static PsiInstanceOfExpression processParent(@NotNull PsiTypeCastExpression cast, @NotNull PsiElement context, @Nullable PsiElement parent, @Nullable PsiVariable variable) {
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(14);
        }
        if (context == null) {
            InstanceOfUtils.$$$reportNull$$$0(15);
        }
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            if (ifStatement.getThenBranch() == context) {
                return InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, true, variable);
            }
            if (ifStatement.getElseBranch() == context) {
                return InstanceOfUtils.findInstanceOf(ifStatement.getCondition(), cast, false, variable);
            }
        }
        if (parent instanceof PsiForStatement || parent instanceof PsiWhileStatement) {
            return InstanceOfUtils.findInstanceOf(((PsiConditionalLoopStatement)parent).getCondition(), cast, true, variable);
        }
        return null;
    }

    private static boolean canCompleteNormally(@NotNull PsiElement parent, @Nullable PsiStatement statement) {
        ControlFlow flow;
        if (parent == null) {
            InstanceOfUtils.$$$reportNull$$$0(16);
        }
        if (statement == null) {
            return true;
        }
        try {
            flow = ControlFlowFactory.getControlFlow((PsiElement)parent, (ControlFlowPolicy)new LocalsControlFlowPolicy(parent), (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        int startOffset = flow.getStartOffset((PsiElement)statement);
        int endOffset = flow.getEndOffset((PsiElement)statement);
        return startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally((ControlFlow)flow, (int)startOffset, (int)endOffset);
    }

    @Contract(value="null, _, _, _ -> null")
    private static PsiInstanceOfExpression findInstanceOf(@Nullable PsiExpression condition, @NotNull PsiTypeCastExpression cast, boolean whenTrue, @Nullable PsiVariable variable) {
        PsiPolyadicExpression polyadic;
        IElementType tokenType;
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(17);
        }
        if (condition == null) {
            return null;
        }
        if (condition instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)condition;
            return InstanceOfUtils.findInstanceOf(parenthesized.getExpression(), cast, whenTrue, variable);
        }
        if (BoolUtils.isNegation(condition)) {
            return InstanceOfUtils.findInstanceOf(BoolUtils.getNegated(condition), cast, !whenTrue, variable);
        }
        if (condition instanceof PsiPolyadicExpression && ((tokenType = (polyadic = (PsiPolyadicExpression)condition).getOperationTokenType()) == JavaTokenType.ANDAND && whenTrue || tokenType == JavaTokenType.OROR && !whenTrue)) {
            for (PsiExpression operand : polyadic.getOperands()) {
                if (PsiTreeUtil.isContextAncestor((PsiElement)operand, (PsiElement)cast, (boolean)false)) {
                    return null;
                }
                PsiInstanceOfExpression result = InstanceOfUtils.findInstanceOf(operand, cast, whenTrue, variable);
                if (result == null) continue;
                return result;
            }
        }
        if (condition instanceof PsiInstanceOfExpression) {
            PsiTypeElement typeElement;
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)condition;
            if (whenTrue && (typeElement = InstanceOfUtils.findCheckTypeElement(instanceOf)) != null) {
                PsiType type = typeElement.getType();
                PsiType castType = Objects.requireNonNull(cast.getCastType()).getType();
                PsiExpression castOperand = Objects.requireNonNull(cast.getOperand());
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)instanceOf.getOperand(), (PsiElement)castOperand) && (InstanceOfUtils.typeCompatible(type, castType, castOperand) || PsiUtil.isJvmLocalVariable((PsiElement)variable) && InstanceOfUtils.isSafeToNarrowType(variable, cast, type))) {
                    return instanceOf;
                }
            }
        }
        return null;
    }

    public static boolean typeCompatible(@NotNull PsiType instanceOfType, @NotNull PsiType castType, @NotNull PsiExpression castOperand) {
        PsiClassType rawType;
        if (instanceOfType == null) {
            InstanceOfUtils.$$$reportNull$$$0(18);
        }
        if (castType == null) {
            InstanceOfUtils.$$$reportNull$$$0(19);
        }
        if (castOperand == null) {
            InstanceOfUtils.$$$reportNull$$$0(20);
        }
        if (instanceOfType.equals(castType)) {
            return true;
        }
        if (castType instanceof PsiClassType && instanceOfType.equals(rawType = ((PsiClassType)castType).rawType())) {
            return castOperand.getType() != null;
        }
        return false;
    }

    public static boolean hasConflictingDeclaredNames(@NotNull PsiLocalVariable variable, @NotNull PsiInstanceOfExpression instanceOf) {
        PsiIdentifier identifier;
        if (variable == null) {
            InstanceOfUtils.$$$reportNull$$$0(21);
        }
        if (instanceOf == null) {
            InstanceOfUtils.$$$reportNull$$$0(22);
        }
        if ((identifier = variable.getNameIdentifier()) == null) {
            return false;
        }
        PsiElement scope = JavaSharedImplUtil.getPatternVariableDeclarationScope((PsiInstanceOfExpression)instanceOf);
        if (scope == null) {
            return false;
        }
        boolean hasConflict = InstanceOfUtils.isConflictingNameDeclaredInside((PsiVariable)variable, scope, false);
        if (hasConflict) {
            if (instanceOf.getPattern() != null) {
                return true;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
            PsiExpression newExpression = factory.createExpressionFromText(instanceOf.getText() + " " + identifier.getText(), (PsiElement)instanceOf);
            PsiFile file = variable.getContainingFile();
            if (file != instanceOf.getContainingFile()) {
                return true;
            }
            PsiFile copyFile = (PsiFile)file.copy();
            PsiInstanceOfExpression copyInstanceOf = (PsiInstanceOfExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)instanceOf, (PsiFile)copyFile);
            PsiLocalVariable copyVariable = (PsiLocalVariable)PsiTreeUtil.findSameElementInCopy((PsiElement)variable, (PsiFile)copyFile);
            copyVariable.delete();
            newExpression = copyInstanceOf.replace((PsiElement)newExpression);
            if (!(newExpression instanceof PsiInstanceOfExpression)) {
                return true;
            }
            PsiInstanceOfExpression newInstanceOfExpression = (PsiInstanceOfExpression)newExpression;
            PsiPrimaryPattern psiPrimaryPattern = newInstanceOfExpression.getPattern();
            if (!(psiPrimaryPattern instanceof PsiTypeTestPattern)) {
                return true;
            }
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)psiPrimaryPattern;
            PsiPatternVariable patternVariable = typeTestPattern.getPatternVariable();
            if (patternVariable == null) {
                return true;
            }
            scope = JavaSharedImplUtil.getPatternVariableDeclarationScope((PsiInstanceOfExpression)newInstanceOfExpression);
            if (scope == null) {
                return false;
            }
            return InstanceOfUtils.isConflictingNameDeclaredInside((PsiVariable)patternVariable, scope, true);
        }
        return false;
    }

    public static boolean isConflictingNameDeclaredInside(@Nullable PsiVariable myVariable, @Nullable PsiElement element, boolean checkRedeclared) {
        if (myVariable == null || element == null) {
            return false;
        }
        PsiIdentifier identifier = myVariable.getNameIdentifier();
        if (identifier == null) {
            return false;
        }
        HasDeclaredVariableWithTheSameNameVisitor visitor2 = new HasDeclaredVariableWithTheSameNameVisitor(myVariable, checkRedeclared);
        element.accept((PsiElementVisitor)visitor2);
        return visitor2.hasConflict;
    }

    public static boolean isSafeToNarrowType(@NotNull PsiVariable variable, @NotNull PsiTypeCastExpression cast, @NotNull PsiType type) {
        PsiClassType classType;
        if (variable == null) {
            InstanceOfUtils.$$$reportNull$$$0(23);
        }
        if (cast == null) {
            InstanceOfUtils.$$$reportNull$$$0(24);
        }
        if (type == null) {
            InstanceOfUtils.$$$reportNull$$$0(25);
        }
        PsiType castType = GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
        PsiTypeElement varTypeElement = variable.getTypeElement();
        if (varTypeElement == null || varTypeElement.isInferredType() || varTypeElement.hasAnnotations()) {
            return false;
        }
        PsiType variableType = varTypeElement.getType();
        if (!(variableType instanceof PsiClassType) || (classType = (PsiClassType)variableType).isRaw()) {
            return false;
        }
        if (variableType.equals(castType) || !variableType.isAssignableFrom(castType)) {
            return false;
        }
        for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences(variable)) {
            if (PsiTreeUtil.isAncestor((PsiElement)cast, (PsiElement)reference, (boolean)true) || VariableAccessUtils.isVariableTypeChangeSafeForReference(castType, reference)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castOperand";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/InstanceOfUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConflictingInstanceof";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findInterestingParent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInstanceOfAssertionCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAgreeingInstanceof";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findPatternCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedCast";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findCorrespondingInstanceOf";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "walkBackAndUpToFindInstanceOf";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processOfPreviousStatements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "conditionMayContainCorrespondingInstanceOf";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findCheckTypeElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processParent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "canCompleteNormally";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstanceOf";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "typeCompatible";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConflictingDeclaredNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isSafeToNarrowType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InstanceofChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private final PsiType castType;
        private final boolean strict;
        private boolean negate = false;
        private PsiInstanceOfExpression conflictingInstanceof = null;
        private boolean agreeingInstanceof = false;

        InstanceofChecker(PsiReferenceExpression referenceExpression, PsiType castType, boolean strict) {
            this.referenceExpression = referenceExpression;
            this.castType = castType;
            this.strict = strict;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(0);
            }
            this.visitExpression((PsiExpression)expression);
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(1);
            }
            if ((tokenType = expression.getOperationTokenType()) == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) {
                for (PsiExpression operand : expression.getOperands()) {
                    this.checkExpression(operand);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (!this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            }
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                InstanceofChecker.$$$reportNull$$$0(2);
            }
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                InstanceofChecker.$$$reportNull$$$0(3);
            }
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                InstanceofChecker.$$$reportNull$$$0(4);
            }
            this.processConditionalLoop((PsiConditionalLoopStatement)statement);
        }

        private void processConditionalLoop(PsiConditionalLoopStatement loop) {
            PsiStatement body = loop.getBody();
            if (!PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)this.referenceExpression, (boolean)true)) {
                return;
            }
            if (this.isReassignedInside(body)) {
                return;
            }
            this.checkExpression(loop.getCondition());
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                InstanceofChecker.$$$reportNull$$$0(5);
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            this.negate = PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)this.referenceExpression, (boolean)true);
            if (this.isReassignedInside(this.negate ? elseBranch : ifStatement.getThenBranch())) {
                return;
            }
            this.checkExpression(ifStatement.getCondition());
        }

        private boolean isReassignedInside(PsiStatement branch) {
            return branch instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)branch);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(6);
            }
            PsiExpression elseExpression = expression.getElseExpression();
            this.negate = PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)this.referenceExpression, (boolean)true);
            this.checkExpression(expression.getCondition());
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(7);
            }
            if (this.negate) {
                return;
            }
            if (this.isAgreeing(expression)) {
                this.agreeingInstanceof = true;
                this.conflictingInstanceof = null;
            } else if (this.isConflicting(expression) && this.conflictingInstanceof == null) {
                this.conflictingInstanceof = expression;
            }
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            PsiExpression operand;
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(8);
            }
            if ((operand = expression.getExpression()) != null) {
                operand.accept((PsiElementVisitor)this);
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                InstanceofChecker.$$$reportNull$$$0(9);
            }
            super.visitPrefixExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (operand != null && expression.getOperationTokenType().equals(JavaTokenType.EXCL)) {
                this.negate = !this.negate;
                operand.accept((PsiElementVisitor)this);
                this.negate = !this.negate;
            }
        }

        private void checkExpression(PsiExpression expression) {
            if (expression != null) {
                expression.accept((PsiElementVisitor)this);
            }
        }

        private boolean isConflicting(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return !this.castType.equals(type);
            }
            return !this.castType.isAssignableFrom(type);
        }

        private boolean isAgreeing(PsiInstanceOfExpression expression) {
            PsiExpression conditionOperand = expression.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type = typeElement.getType();
            if (this.strict) {
                return this.castType.equals(type);
            }
            return this.castType.isAssignableFrom(type);
        }

        public boolean hasAgreeingInstanceof() {
            return this.agreeingInstanceof;
        }

        public PsiInstanceOfExpression getConflictingInstanceof() {
            return this.conflictingInstanceof;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/InstanceOfUtils$InstanceofChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record ResultOfInstanceOf(@Nullable PsiElement context, @Nullable PsiInstanceOfExpression instanceOf) {
    }

    private static class HasDeclaredVariableWithTheSameNameVisitor
    extends JavaRecursiveElementWalkingVisitor {
        boolean hasConflict;
        private final PsiVariable myVariable;
        private final PsiIdentifier myIdentifier;
        private final boolean myCheckRedeclared;

        private HasDeclaredVariableWithTheSameNameVisitor(@NotNull PsiVariable variable, boolean checkRedeclared) {
            if (variable == null) {
                HasDeclaredVariableWithTheSameNameVisitor.$$$reportNull$$$0(0);
            }
            this.hasConflict = false;
            this.myVariable = variable;
            this.myIdentifier = variable.getNameIdentifier();
            this.myCheckRedeclared = checkRedeclared;
            if (this.myIdentifier == null) {
                this.stopWalking();
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                HasDeclaredVariableWithTheSameNameVisitor.$$$reportNull$$$0(1);
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            String name;
            if (variable == null) {
                HasDeclaredVariableWithTheSameNameVisitor.$$$reportNull$$$0(2);
            }
            if ((name = variable.getName()) != null && this.myVariable != variable && this.myIdentifier.textMatches((CharSequence)name) && (!this.myCheckRedeclared || JavaPsiVariableUtil.findPreviousVariableDeclaration((PsiVariable)variable) != null)) {
                this.hasConflict = true;
                this.stopWalking();
            }
            super.visitVariable(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/InstanceOfUtils$HasDeclaredVariableWithTheSameNameVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

