/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiMathUtil {
    private JavaPsiMathUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static String add(@NotNull PsiExpression expression, int addend, @NotNull CommentTracker ct) {
        PsiPolyadicExpression polyadicExpression;
        int multiplier;
        if (expression == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(0);
        }
        if (ct == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(1);
        }
        if (addend == 0) {
            String string = ct.text((PsiElement)expression);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        Number value = JavaPsiMathUtil.getNumberFromLiteral(stripped);
        if (value instanceof Integer) {
            String string = String.valueOf(value.intValue() + addend);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (value instanceof Long) {
            String string = String.valueOf(value.longValue() + (long)addend);
            if (string == null) {
                JavaPsiMathUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (stripped instanceof PsiPolyadicExpression && (multiplier = JavaPsiMathUtil.getMultiplier(polyadicExpression = (PsiPolyadicExpression)stripped)) != 0) {
            value = JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
            Object updatedAddend = null;
            if (value instanceof Integer) {
                updatedAddend = String.valueOf(value.intValue() * multiplier + addend);
            } else if (value instanceof Long) {
                updatedAddend = String.valueOf(value.longValue() * (long)multiplier + (long)addend);
            }
            if (updatedAddend != null) {
                if (((String)updatedAddend).equals("0")) {
                    updatedAddend = "";
                } else if (!((String)updatedAddend).startsWith("-")) {
                    updatedAddend = "+" + (String)updatedAddend;
                }
                String string = JavaPsiMathUtil.updateLastAddend(polyadicExpression, (String)updatedAddend, ct);
                if (string == null) {
                    JavaPsiMathUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = ct.text(expression, 6) + (addend > 0 ? "+" : "") + addend;
        if (string == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static String simplifyComparison(PsiExpression comparison, @NotNull CommentTracker ct) {
        if (ct == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(7);
        }
        if (!(comparison instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)comparison;
        RelationType relationType = DfaPsiUtil.getRelationByToken(binOp.getOperationTokenType());
        if (relationType == null) {
            return null;
        }
        String operator = binOp.getOperationSign().getText();
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        Integer leftValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(left), Integer.class);
        Integer rightValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(right), Integer.class);
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)left, PsiPolyadicExpression.class);
        Integer leftAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(leftPolyadic), Integer.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)right, PsiPolyadicExpression.class);
        Integer rightAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(rightPolyadic), Integer.class);
        if (leftAddend != null) {
            if (leftAddend == 1 && operator.equals(">")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">=" + ct.text((PsiElement)right);
            }
            if (leftAddend == 1 && operator.equals("<=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator.equals(">=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator.equals("<")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<=" + ct.text((PsiElement)right);
            }
            if (rightValue != null) {
                rightValue = rightValue - leftAddend;
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator + rightValue;
            }
        }
        if (rightAddend != null) {
            if (rightAddend == 1 && operator.equals("<")) {
                return ct.text((PsiElement)left) + "<=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == 1 && operator.equals(">=")) {
                return ct.text((PsiElement)left) + ">" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator.equals("<=")) {
                return ct.text((PsiElement)left) + "<" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator.equals(">")) {
                return ct.text((PsiElement)left) + ">=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (leftValue != null) {
                leftValue = leftValue - rightAddend;
                return leftValue + operator + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
        }
        if (leftAddend != null && rightAddend != null) {
            int diff = leftAddend - rightAddend;
            if (diff > 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "+" + diff, ct) + operator + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (diff < 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "+" + -diff, ct);
            }
            return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
        }
        return null;
    }

    private static String updateLastAddend(PsiPolyadicExpression polyadicExpression, String updatedAddend, CommentTracker ct) {
        PsiExpression lastElement = Objects.requireNonNull((PsiExpression)ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
        PsiJavaToken lastToken = Objects.requireNonNull(polyadicExpression.getTokenBeforeOperand(lastElement));
        PsiElement from = polyadicExpression.getFirstChild();
        PsiElement to = lastToken.getPrevSibling();
        return ((StreamEx)StreamEx.iterate((Object)from, PsiElement::getNextSibling).takeWhileInclusive(e -> !to.equals(e))).map(ct::text).joining() + updatedAddend;
    }

    @Contract(value="null->null")
    @Nullable
    public static Number getNumberFromLiteral(@Nullable PsiExpression expression) {
        PsiExpression operand;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression) {
            return (Number)ObjectUtils.tryCast((Object)((PsiLiteralExpression)expression).getValue(), Number.class);
        }
        if (expression instanceof PsiUnaryExpression && ((PsiUnaryExpression)expression).getOperationTokenType().equals(JavaTokenType.MINUS) && (operand = ((PsiUnaryExpression)expression).getOperand()) instanceof PsiLiteralExpression) {
            Object value = ((PsiLiteralExpression)operand).getValue();
            return JavaPsiMathUtil.negate(value);
        }
        return null;
    }

    @Nullable
    public static Number negate(Object value) {
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        return null;
    }

    private static int getMultiplier(PsiPolyadicExpression polyadicExpression) {
        IElementType type = polyadicExpression.getOperationTokenType();
        int multiplier = type.equals(JavaTokenType.PLUS) ? 1 : (type.equals(JavaTokenType.MINUS) ? -1 : 0);
        return multiplier;
    }

    @Nullable
    private static Number getLastAddend(PsiPolyadicExpression polyadic) {
        int multiplier;
        if (polyadic != null && (multiplier = JavaPsiMathUtil.getMultiplier(polyadic)) != 0) {
            PsiExpression lastOp = (PsiExpression)ArrayUtil.getLastElement((Object[])polyadic.getOperands());
            Number lastAddend = JavaPsiMathUtil.getNumberFromLiteral(lastOp);
            if (multiplier == 1) {
                return lastAddend;
            }
            if (multiplier == -1) {
                return JavaPsiMathUtil.negate(lastAddend);
            }
        }
        return null;
    }

    @Nullable
    public static LongRangeSet getRangeFromComparison(@NotNull PsiExpression nonConstantOperand) {
        boolean yodaCondition;
        PsiExpression constOperand;
        PsiBinaryExpression binOp;
        if (nonConstantOperand == null) {
            JavaPsiMathUtil.$$$reportNull$$$0(8);
        }
        if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)nonConstantOperand.getParent()), PsiBinaryExpression.class)) == null) {
            return null;
        }
        PsiJavaToken sign = binOp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        RelationType relation = DfaPsiUtil.getRelationByToken(tokenType);
        if (relation == null) {
            return null;
        }
        PsiExpression psiExpression = constOperand = PsiTreeUtil.isAncestor((PsiElement)binOp.getLOperand(), (PsiElement)nonConstantOperand, (boolean)false) ? binOp.getROperand() : binOp.getLOperand();
        if (constOperand == null) {
            return null;
        }
        Object constantExpression = ExpressionUtils.computeConstantExpression(constOperand);
        if (!(constantExpression instanceof Integer) && !(constantExpression instanceof Long)) {
            return null;
        }
        long value = ((Number)constantExpression).longValue();
        boolean bl = yodaCondition = constOperand == binOp.getLOperand();
        if (yodaCondition) {
            relation = relation.getFlipped();
        }
        return LongRangeSet.point((long)value).fromRelation(relation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/JavaPsiMathUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonConstantOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/JavaPsiMathUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "simplifyComparison";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRangeFromComparison";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

