/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LoopDirection {
    ASCENDING,
    DESCENDING;


    @Nullable
    public static LoopDirection evaluateLoopDirection(@NotNull PsiVariable counter, @Nullable PsiStatement updateStatement) {
        PsiExpressionStatement expressionStatement;
        if (counter == null) {
            LoopDirection.$$$reportNull$$$0(0);
        }
        if ((expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)updateStatement, PsiExpressionStatement.class)) == null) {
            return null;
        }
        PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expressionStatement.getExpression());
        if (expression instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression;
            IElementType tokenType = unaryExpression.getOperationTokenType();
            if (tokenType != JavaTokenType.PLUSPLUS && tokenType != JavaTokenType.MINUSMINUS) {
                return null;
            }
            PsiExpression operand = unaryExpression.getOperand();
            if (!ExpressionUtils.isReferenceTo(operand, counter)) {
                return null;
            }
            return tokenType == JavaTokenType.PLUSPLUS ? ASCENDING : DESCENDING;
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!ExpressionUtils.isReferenceTo(lhs, counter)) {
                return null;
            }
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQ) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)rhs, PsiBinaryExpression.class);
                if (binaryExpression == null) {
                    return null;
                }
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (binaryTokenType != JavaTokenType.PLUS && binaryTokenType != JavaTokenType.MINUS) {
                    return null;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand)) {
                    if (!ExpressionUtils.isReferenceTo(rOperand, counter)) {
                        return null;
                    }
                    return binaryTokenType == JavaTokenType.PLUS ? ASCENDING : DESCENDING;
                }
                if (ExpressionUtils.isOne(rOperand)) {
                    if (!ExpressionUtils.isReferenceTo(lOperand, counter)) {
                        return null;
                    }
                    return binaryTokenType == JavaTokenType.PLUS ? ASCENDING : DESCENDING;
                }
            } else if ((tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return tokenType == JavaTokenType.PLUSEQ ? ASCENDING : DESCENDING;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/siyeh/ig/psiutils/LoopDirection", "evaluateLoopDirection"));
    }
}

