/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptTable;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMatcher
implements OptionContainer {
    private final List<String> myMethodNamePatterns = new ArrayList<String>();
    private final List<String> myClassNames = new ArrayList<String>();
    private final Map<String, Pattern> myPatternCache = new HashMap<String, Pattern>();
    private final boolean myWriteDefaults;
    private final String myOptionName;
    private String myDefaultSettings = null;

    public MethodMatcher() {
        this(false, "METHOD_MATCHER_CONFIG");
    }

    public MethodMatcher(boolean writeDefaults, @NonNls String optionName) {
        this.myWriteDefaults = writeDefaults;
        this.myOptionName = optionName;
    }

    public MethodMatcher add(@NonNls @NotNull String className, @NonNls @NotNull String methodNamePattern) {
        if (className == null) {
            MethodMatcher.$$$reportNull$$$0(0);
        }
        if (methodNamePattern == null) {
            MethodMatcher.$$$reportNull$$$0(1);
        }
        this.myClassNames.add(className);
        this.myMethodNamePatterns.add(methodNamePattern);
        return this;
    }

    public void add(@NotNull PsiMethodCallExpression expression) {
        PsiMethod method;
        if (expression == null) {
            MethodMatcher.$$$reportNull$$$0(2);
        }
        if ((method = expression.resolveMethod()) != null) {
            this.add(method);
        }
    }

    public void add(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            MethodMatcher.$$$reportNull$$$0(3);
        }
        if ((aClass = method.getContainingClass()) == null) {
            return;
        }
        String fqName = aClass.getQualifiedName();
        int index = this.myClassNames.indexOf(fqName);
        String methodName = method.getName();
        if (index < 0) {
            this.myClassNames.add(fqName);
            this.myMethodNamePatterns.add(methodName);
        } else {
            String[] names;
            String pattern = this.myMethodNamePatterns.get(index);
            if (pattern.isEmpty()) {
                this.myMethodNamePatterns.set(index, methodName);
                return;
            }
            if (".*".equals(pattern)) {
                return;
            }
            for (String name : names = pattern.split("\\|")) {
                if (!methodName.equals(name)) continue;
                return;
            }
            this.myMethodNamePatterns.set(index, pattern + "|" + methodName);
        }
        ProjectInspectionProfileManager.getInstance((Project)method.getProject()).fireProfileChanged();
    }

    @NotNull
    protected String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            MethodMatcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    public List<String> getMethodNamePatterns() {
        return this.myMethodNamePatterns;
    }

    public List<String> getClassNames() {
        return this.myClassNames;
    }

    public boolean matches(@Nullable PsiMethod method) {
        return this.find(method, null, false) != -1;
    }

    public int find(@Nullable PsiMethod method, @Nullable PsiClass containingClass, boolean checkBases) {
        if (method == null) {
            return -1;
        }
        String methodName = method.getName();
        if (containingClass == null) {
            containingClass = method.getContainingClass();
        }
        if (containingClass == null) {
            return -1;
        }
        int size = this.myMethodNamePatterns.size();
        for (int i = 0; i < size; ++i) {
            Pattern pattern = this.getPattern(i);
            if (pattern == null || !pattern.matcher(methodName).matches()) continue;
            String className = this.myClassNames.get(i);
            PsiClass base = JavaPsiFacade.getInstance((Project)method.getProject()).findClass(className, containingClass.getResolveScope());
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)base, (boolean)true) || base.findMethodsBySignature(method, checkBases).length <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean matches(PsiCall call) {
        return this.matches(call.resolveMethod());
    }

    private Pattern getPattern(int i) {
        String methodNamePattern = this.myMethodNamePatterns.get(i);
        if (StringUtil.isEmpty((String)methodNamePattern)) {
            return null;
        }
        Pattern pattern = this.myPatternCache.get(methodNamePattern);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.myPatternCache.put(methodNamePattern, pattern);
            }
            catch (NullPointerException | PatternSyntaxException ignore) {
                return null;
            }
        }
        return pattern;
    }

    public MethodMatcher finishDefault() {
        if (this.myDefaultSettings != null) {
            throw new IllegalStateException();
        }
        this.myDefaultSettings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        return this;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            MethodMatcher.$$$reportNull$$$0(5);
        }
        String settings = null;
        for (Element option : node.getChildren("option")) {
            String value = option.getAttributeValue("name");
            if (value == null || !value.equals(this.getOptionName())) continue;
            settings = option.getAttributeValue("value");
            break;
        }
        if (settings == null) {
            return;
        }
        this.myPatternCache.clear();
        this.myClassNames.clear();
        this.myMethodNamePatterns.clear();
        BaseInspection.parseString(settings, this.myClassNames, this.myMethodNamePatterns);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            MethodMatcher.$$$reportNull$$$0(6);
        }
        String settings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        if (!this.myWriteDefaults && settings.equals(this.myDefaultSettings)) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", this.getOptionName()).setAttribute("value", settings));
    }

    @NotNull
    public OptTable getTable(@NlsContexts.Label @NotNull String label) {
        if (label == null) {
            MethodMatcher.$$$reportNull$$$0(7);
        }
        OptTable optTable = OptPane.table((String)label, (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"myClassNames", (String)InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), (StringValidator)new JavaClassValidator()), OptPane.column((String)"myMethodNamePatterns", (String)InspectionGadgetsBundle.message("method.name.regex", new Object[0]), (StringValidator)new RegexValidator())});
        if (optTable == null) {
            MethodMatcher.$$$reportNull$$$0(8);
        }
        return optTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNamePattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/MethodMatcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/MethodMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }
}

