/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParenthesesUtils {
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int NUM_PRECEDENCES = 18;

    private ParenthesesUtils() {
    }

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        return PsiPrecedenceUtil.isCommutativeOperator((IElementType)token);
    }

    public static boolean isCommutativeOperation(PsiPolyadicExpression expression) {
        return PsiPrecedenceUtil.isCommutativeOperation((PsiPolyadicExpression)expression);
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression) {
        return PsiPrecedenceUtil.isAssociativeOperation((PsiPolyadicExpression)expression);
    }

    public static int getPrecedence(PsiExpression expression) {
        return PsiPrecedenceUtil.getPrecedence((PsiExpression)expression);
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator) {
        if (operator == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        return PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)operator);
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression, boolean ignoreClarifyingParentheses) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiParenthesizedExpression)expression, (boolean)ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiExpression)expression, (PsiExpression)parentExpression, (boolean)ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiJavaToken compoundAssignmentToken, PsiExpression rhs) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiJavaToken)compoundAssignmentToken, (PsiExpression)rhs);
    }

    public static String getText(@NotNull PsiExpression expression, int precedence) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(2);
        }
        String text = InjectedLanguageManager.getInstance((Project)expression.getProject()).getUnescapedText((PsiElement)expression);
        if (ParenthesesUtils.getPrecedence(expression) >= precedence) {
            return "(" + text + ")";
        }
        return text;
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression stripParentheses(@Nullable PsiExpression expression) {
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
    }

    public static void removeParentheses(PsiCaseLabelElement element, boolean ignoreClarifyingParentheses) {
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            ParenthesesUtils.removeParensFromMethodCallExpression(methodCall, ignoreClarifyingParentheses);
        } else if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            ParenthesesUtils.removeParensFromReferenceExpression(referenceExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            ParenthesesUtils.removeParensFromNewExpression(newExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            ParenthesesUtils.removeParensFromAssignmentExpression(assignmentExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)element;
            ParenthesesUtils.removeParensFromArrayInitializerExpression(arrayInitializerExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            ParenthesesUtils.removeParensFromTypeCastExpression(typeCastExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            ParenthesesUtils.removeParensFromArrayAccessExpression(arrayAccessExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            ParenthesesUtils.removeParensFromPrefixExpression(prefixExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
            ParenthesesUtils.removeParensFromPostfixExpression(postfixExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element;
            ParenthesesUtils.removeParensFromPolyadicExpression(polyadicExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)element;
            ParenthesesUtils.removeParensFromInstanceOfExpression(instanceofExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            ParenthesesUtils.removeParensFromConditionalExpression(conditionalExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            ParenthesesUtils.removeParensFromParenthesizedExpression(parenthesizedExpression, ignoreClarifyingParentheses);
        } else if (element instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)element;
            ParenthesesUtils.removeParensFromLambdaExpression(lambdaExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromLambdaExpression(PsiLambdaExpression lambdaExpression, boolean ignoreClarifyingParentheses) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)body;
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)expression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromReferenceExpression(@NotNull PsiReferenceExpression referenceExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression qualifier;
        if (referenceExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(3);
        }
        if ((qualifier = referenceExpression.getQualifierExpression()) != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)qualifier, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromParenthesizedExpression(@NotNull PsiParenthesizedExpression parenthesizedExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression expression;
        PsiExpression body;
        if (parenthesizedExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(4);
        }
        if ((body = parenthesizedExpression.getExpression()) == null) {
            return;
        }
        PsiElement parent = parenthesizedExpression.getParent();
        if (!(parent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(body, expression = (PsiExpression)parent, ignoreClarifyingParentheses)) {
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(body);
            PsiExpression newExpression = (PsiExpression)commentTracker.replaceAndRestoreComments((PsiElement)parenthesizedExpression, (PsiElement)body);
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)newExpression, ignoreClarifyingParentheses);
        } else {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)body, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromConditionalExpression(@NotNull PsiConditionalExpression conditionalExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression elseBranch;
        if (conditionalExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(5);
        }
        PsiExpression condition = conditionalExpression.getCondition();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)condition, ignoreClarifyingParentheses);
        PsiExpression thenBranch = conditionalExpression.getThenExpression();
        if (thenBranch != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)thenBranch, ignoreClarifyingParentheses);
        }
        if ((elseBranch = conditionalExpression.getElseExpression()) != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)elseBranch, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromInstanceOfExpression(@NotNull PsiInstanceOfExpression instanceofExpression, boolean ignoreClarifyingParentheses) {
        if (instanceofExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(6);
        }
        PsiExpression operand = instanceofExpression.getOperand();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression, boolean ignoreClarifyingParentheses) {
        if (polyadicExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(7);
        }
        for (PsiExpression operand : polyadicExpression.getOperands()) {
            if (!operand.isValid()) break;
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromPostfixExpression(@NotNull PsiPostfixExpression postfixExpression, boolean ignoreClarifyingParentheses) {
        if (postfixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(8);
        }
        PsiExpression operand = postfixExpression.getOperand();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPrefixExpression(@NotNull PsiPrefixExpression prefixExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand;
        if (prefixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(9);
        }
        if ((operand = prefixExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression, boolean ignoreClarifyingParentheses) {
        if (arrayAccessExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(10);
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)arrayExpression, ignoreClarifyingParentheses);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        if (indexExpression != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)indexExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromTypeCastExpression(@NotNull PsiTypeCastExpression typeCastExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand;
        if (typeCastExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(11);
        }
        if ((operand = typeCastExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializerExpression, boolean ignoreClarifyingParentheses) {
        if (arrayInitializerExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(12);
        }
        for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)initializer, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromAssignmentExpression(@NotNull PsiAssignmentExpression assignment, boolean ignoreClarifyingParentheses) {
        if (assignment == null) {
            ParenthesesUtils.$$$reportNull$$$0(13);
        }
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression rhs = assignment.getRExpression();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)lhs, ignoreClarifyingParentheses);
        if (rhs != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)rhs, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromNewExpression(@NotNull PsiNewExpression newExpression, boolean ignoreClarifyingParentheses) {
        PsiExpressionList argumentList;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpression[] dimensions;
        if (newExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(14);
        }
        for (PsiExpression dimension : dimensions = newExpression.getArrayDimensions()) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)dimension, ignoreClarifyingParentheses);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        if (qualifier != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)qualifier, ignoreClarifyingParentheses);
        }
        if ((arrayInitializer = newExpression.getArrayInitializer()) != null) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)arrayInitializer, ignoreClarifyingParentheses);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            PsiExpression[] arguments;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                ParenthesesUtils.removeParentheses((PsiCaseLabelElement)argument, ignoreClarifyingParentheses);
            }
        }
    }

    private static void removeParensFromMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression, boolean ignoreClarifyingParentheses) {
        if (methodCallExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(15);
        }
        PsiReferenceExpression target = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        ParenthesesUtils.removeParentheses((PsiCaseLabelElement)target, ignoreClarifyingParentheses);
        for (PsiExpression argument : arguments) {
            ParenthesesUtils.removeParentheses((PsiCaseLabelElement)argument, ignoreClarifyingParentheses);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommutativeOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedenceForOperator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromReferenceExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromParenthesizedExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromConditionalExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromInstanceOfExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPolyadicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPostfixExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPrefixExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayAccessExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTypeCastExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayInitializerExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromAssignmentExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromNewExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

