/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SerializationUtils {
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";

    private SerializationUtils() {
    }

    public static boolean isSerializable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable");
    }

    public static boolean isExternalizable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Externalizable");
    }

    public static boolean isDirectlySerializable(@NotNull PsiClass aClass) {
        PsiReferenceList implementsList;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(0);
        }
        if ((implementsList = aClass.getImplementsList()) == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement aInterfaces : implementsList.getReferenceElements()) {
            PsiElement implemented = aInterfaces.resolve();
            if (!(implemented instanceof PsiClass) || !"java.io.Serializable".equals(((PsiClass)implemented).getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(1);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("readObject", false)) {
            if (!SerializationUtils.isReadObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadResolve(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(2);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("readResolve", true)) {
            if (!SerializationUtils.isReadResolve(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(3);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            if (!SerializationUtils.isWriteObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteReplace(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            SerializationUtils.$$$reportNull$$$0(4);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeReplace", true)) {
            if (!SerializationUtils.isWriteReplace(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadObject(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(5);
        }
        PsiClassType type = TypeUtils.getType("java.io.ObjectInputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "readObject", new PsiType[]{type});
    }

    public static boolean isWriteObject(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(6);
        }
        PsiClassType type = TypeUtils.getType("java.io.ObjectOutputStream", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "writeObject", new PsiType[]{type});
    }

    public static boolean isReadObjectNoData(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(7);
        }
        return MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "readObjectNoData", new PsiType[0]);
    }

    public static boolean isReadResolve(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(8);
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "readResolve", new String[0]);
    }

    public static boolean isWriteReplace(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(9);
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "writeReplace", new String[0]);
    }

    public static boolean isReadExternal(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(10);
        }
        PsiClassType type = TypeUtils.getType("java.io.ObjectInput", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "readExternal", new PsiType[]{type});
    }

    public static boolean isWriteExternal(@NotNull PsiMethod method) {
        if (method == null) {
            SerializationUtils.$$$reportNull$$$0(11);
        }
        PsiClassType type = TypeUtils.getType("java.io.ObjectOutput", (PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiTypes.voidType(), "writeExternal", new PsiType[]{type});
    }

    public static boolean isSerialVersionUid(@NotNull PsiField field) {
        if (field == null) {
            SerializationUtils.$$$reportNull$$$0(12);
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.getName().equals("serialVersionUID") && field.getType().equals(PsiTypes.longType());
    }

    public static boolean isSerialPersistentFields(@NotNull PsiField field) {
        if (field == null) {
            SerializationUtils.$$$reportNull$$$0(13);
        }
        return field.hasModifierProperty("private") && field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.getName().equals(SERIAL_PERSISTENT_FIELDS_FIELD_NAME) && field.getType().equalsToText("java.io.ObjectStreamField[]");
    }

    public static boolean isProbablySerializable(PsiType type) {
        if (type instanceof PsiWildcardType || type instanceof PsiPrimitiveType) {
            return true;
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            return SerializationUtils.isProbablySerializable(componentType);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                PsiReferenceList extendsList = typeParameter.getExtendsList();
                return ContainerUtil.and((Object[])extendsList.getReferencedTypes(), SerializationUtils::isProbablySerializable);
            }
            if (aClass == null || aClass.hasModifierProperty("abstract")) {
                return true;
            }
            if (SerializationUtils.isSerializable(aClass) || SerializationUtils.isExternalizable(aClass)) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
                return ContainerUtil.and((Object[])classType.getParameters(), SerializationUtils::isProbablySerializable);
            }
            return false;
        }
        return false;
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        String name;
        if (field == null) {
            SerializationUtils.$$$reportNull$$$0(14);
        }
        if ("serialVersionUID".equals(name = field.getName())) {
            if (!PsiTypes.longType().equals((Object)field.getType())) {
                return false;
            }
        } else if (SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name)) {
            PsiArrayType arrayType;
            if (!field.hasModifierProperty("private")) {
                return false;
            }
            PsiType psiType = field.getType();
            if (!(psiType instanceof PsiArrayType) || (arrayType = (PsiArrayType)psiType).getArrayDimensions() != 1) {
                return false;
            }
            PsiType componentType = arrayType.getComponentType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)componentType);
            if (aClass != null && !"java.io.ObjectStreamField".equals(aClass.getQualifiedName())) {
                return false;
            }
        } else {
            return false;
        }
        if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || JavaHighlightUtil.isSerializable(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/SerializationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlySerializable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReadObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReadResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteReplace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadObjectNoData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteReplace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadExternal";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteExternal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerialVersionUid";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerialPersistentFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerializationImplicitlyUsedField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

