/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.java.codeserver.core.JavaPatternExhaustivenessUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BreakConverter;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class SwitchUtils {
    public static final CallMatcher STRING_IS_EMPTY = CallMatcher.instanceCall("java.lang.String", "isEmpty").parameterCount(0);

    private SwitchUtils() {
    }

    public static int calculateBranchCount(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            SwitchUtils.$$$reportNull$$$0(0);
        }
        return SwitchUtils.calculateBranchCount((PsiSwitchBlock)statement);
    }

    public static int calculateBranchCount(@NotNull PsiSwitchBlock block) {
        List switchBranches;
        if (block == null) {
            SwitchUtils.$$$reportNull$$$0(1);
        }
        if ((switchBranches = JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)block)).isEmpty()) {
            return 0;
        }
        int branches = 0;
        boolean defaultFound = false;
        for (PsiElement branch : switchBranches) {
            if (branch instanceof PsiSwitchLabelStatementBase) {
                if (!((PsiSwitchLabelStatementBase)branch).isDefaultCase()) continue;
                defaultFound = true;
                continue;
            }
            if (!(branch instanceof PsiCaseLabelElement)) continue;
            if (branch instanceof PsiDefaultCaseLabelElement) {
                defaultFound = true;
                continue;
            }
            ++branches;
        }
        PsiCodeBlock body = block.getBody();
        if (body == null) {
            return 0;
        }
        return defaultFound ? -branches - 1 : branches;
    }

    public static int countUnconditionalPatterns(@NotNull PsiExpression selector, @NotNull Set<Object> existingCaseValues) {
        PsiType selectorType;
        if (selector == null) {
            SwitchUtils.$$$reportNull$$$0(2);
        }
        if (existingCaseValues == null) {
            SwitchUtils.$$$reportNull$$$0(3);
        }
        if ((selectorType = selector.getType()) == null) {
            return 0;
        }
        int count = 0;
        for (Object caseValue : existingCaseValues) {
            if (!(caseValue instanceof PsiPattern) || !JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)((PsiPattern)caseValue), (PsiType)selectorType)) continue;
            ++count;
        }
        return count;
    }

    public static boolean canBeSwitchCase(@Nullable PsiExpression expression, @NotNull PsiExpression switchExpression, @NotNull LanguageLevel languageLevel, @NotNull Set<Object> existingCaseValues, boolean isPatternMatch) {
        PsiMethodCallExpression methodCallExpression;
        EqualityCheck check;
        if (switchExpression == null) {
            SwitchUtils.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            SwitchUtils.$$$reportNull$$$0(5);
        }
        if (existingCaseValues == null) {
            SwitchUtils.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            return false;
        }
        expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        boolean primitiveTypesInPatternsSufficient = JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel);
        if (isPatternMatch || primitiveTypesInPatternsSufficient) {
            boolean patternSwitchCase = SwitchUtils.canBePatternSwitchCase(expression, switchExpression, existingCaseValues);
            if (patternSwitchCase) {
                return true;
            }
            if (!primitiveTypesInPatternsSufficient) {
                return false;
            }
        }
        if ((check = EqualityCheck.from(expression)) != null) {
            PsiExpression left = check.getLeft();
            PsiExpression right = check.getRight();
            if (SwitchUtils.canBeCaseLabel(left, languageLevel, existingCaseValues, switchExpression)) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, right);
            }
            if (SwitchUtils.canBeCaseLabel(right, languageLevel, existingCaseValues, switchExpression)) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, left);
            }
        }
        if (primitiveTypesInPatternsSufficient && SwitchUtils.isComparisonWithPrimitives(expression, switchExpression, existingCaseValues)) {
            return true;
        }
        if (expression instanceof PsiMethodCallExpression && STRING_IS_EMPTY.test(methodCallExpression = (PsiMethodCallExpression)expression) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(methodCallExpression.getMethodExpression().getQualifierExpression(), switchExpression)) {
            PsiExpression emptyText = PsiElementFactory.getInstance((Project)expression.getProject()).createExpressionFromText("\"\"", (PsiElement)switchExpression);
            if (SwitchUtils.hasDominated((PsiCaseLabelElement)emptyText, existingCaseValues, switchExpression)) {
                return false;
            }
            return existingCaseValues.add("");
        }
        if (!(expression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR)) {
            for (PsiExpression operand : operands) {
                if (SwitchUtils.canBeSwitchCase(operand, switchExpression, languageLevel, existingCaseValues, false)) continue;
                return false;
            }
            return true;
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands.length == 2) {
            return SwitchUtils.canBeCaseLabel(operands[0], languageLevel, existingCaseValues, switchExpression) && !SwitchUtils.isExtendedSwitchSelectorType(operands[1].getType()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands[1]) || SwitchUtils.canBeCaseLabel(operands[1], languageLevel, existingCaseValues, switchExpression) && !SwitchUtils.isExtendedSwitchSelectorType(operands[0].getType()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands[0]);
        }
        return false;
    }

    public static boolean isExtendedSwitchSelectorType(@Nullable PsiType primitiveOrBoxedType) {
        PsiPrimitiveType primitiveType = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)primitiveOrBoxedType);
        if (primitiveType == null) {
            return false;
        }
        return PsiTypes.booleanType().equals((Object)primitiveType) || PsiTypes.longType().equals((Object)primitiveType) || PsiTypes.doubleType().equals((Object)primitiveType) || PsiTypes.floatType().equals((Object)primitiveType);
    }

    private static boolean isComparisonWithPrimitives(@Nullable PsiExpression psiExpression, @NotNull PsiExpression switchExpression, @NotNull Set<Object> existingCaseValues) {
        if (switchExpression == null) {
            SwitchUtils.$$$reportNull$$$0(7);
        }
        if (existingCaseValues == null) {
            SwitchUtils.$$$reportNull$$$0(8);
        }
        if (!(psiExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression psiBinaryExpression = (PsiBinaryExpression)psiExpression;
        if (!TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)switchExpression.getType())) {
            return false;
        }
        if (psiBinaryExpression.getOperationTokenType() != JavaTokenType.EQEQ) {
            return false;
        }
        boolean isEqual = psiBinaryExpression.getOperationTokenType() == JavaTokenType.EQEQ;
        PsiExpression left = psiBinaryExpression.getLOperand();
        PsiExpression right = psiBinaryExpression.getROperand();
        if (right == null) {
            return false;
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, right) && SwitchUtils.primitiveValueCanBeUsedForComparisonInCase(left, right, isEqual ? existingCaseValues : null)) {
            return true;
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, left) && SwitchUtils.primitiveValueCanBeUsedForComparisonInCase(right, left, isEqual ? existingCaseValues : null);
    }

    private static boolean primitiveValueCanBeUsedForComparisonInCase(@Nullable PsiExpression value, @Nullable PsiExpression selector, @Nullable Set<Object> existingCaseValues) {
        PsiPrimitiveType unwrapped;
        if (value == null || selector == null) {
            return false;
        }
        Object o = ExpressionUtils.computeConstantExpression(value);
        if (o == null) {
            return false;
        }
        if (existingCaseValues != null && existingCaseValues.contains(o)) {
            return false;
        }
        PsiType selectorType = selector.getType();
        PsiType valueType = value.getType();
        if (selectorType == null || valueType == null) {
            return false;
        }
        if (existingCaseValues != null) {
            if (SwitchUtils.hasDominated((PsiCaseLabelElement)value, existingCaseValues, selector)) {
                return false;
            }
            existingCaseValues.add(o);
        }
        if ((unwrapped = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)selectorType)) != null && SwitchUtils.isExtendedSwitchSelectorType((PsiType)unwrapped)) {
            return unwrapped.equals((Object)valueType);
        }
        return TypeConversionUtil.isAssignable((PsiType)selectorType, (PsiType)valueType);
    }

    private static boolean hasDominated(@Nullable PsiCaseLabelElement currentValue, @Nullable Set<Object> previousValues, @NotNull PsiExpression selector) {
        if (selector == null) {
            SwitchUtils.$$$reportNull$$$0(9);
        }
        if (currentValue == null || previousValues == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        for (Object caseValue : previousValues) {
            PsiPattern pattern;
            if (!(caseValue instanceof PsiPattern) || !JavaPsiSwitchUtil.isDominated((PsiCaseLabelElement)currentValue, (PsiElement)(pattern = (PsiPattern)caseValue), (PsiType)selectorType)) continue;
            return true;
        }
        return false;
    }

    private static boolean canBePatternSwitchCase(@Nullable PsiExpression expression, @NotNull PsiExpression switchExpression, @NotNull Set<Object> existingCaseValues) {
        if (switchExpression == null) {
            SwitchUtils.$$$reportNull$$$0(10);
        }
        if (existingCaseValues == null) {
            SwitchUtils.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            return false;
        }
        if (!SwitchUtils.canBePatternSwitchCase(expression, switchExpression)) {
            return false;
        }
        if (SwitchUtils.isNullComparison(expression, switchExpression)) {
            return existingCaseValues.add(null);
        }
        PsiCaseLabelElement pattern = SwitchUtils.createPatternFromExpression(expression);
        if (pattern == null) {
            PsiExpression[] psiExpressionArray;
            int n;
            int n2;
            PsiPolyadicExpression polyadicExpression;
            if (expression instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType().equals(JavaTokenType.OROR) && (n2 = 0) < (n = (psiExpressionArray = polyadicExpression.getOperands()).length)) {
                PsiExpression child = psiExpressionArray[n2];
                if (!(child instanceof PsiExpression)) {
                    return false;
                }
                PsiExpression childExpression = child;
                return SwitchUtils.canBePatternSwitchCase(childExpression, switchExpression, existingCaseValues);
            }
            return false;
        }
        if (VariableAccessUtils.isAnyVariableAssigned(VariableAccessUtils.collectUsedVariables((PsiElement)expression), (PsiElement)expression)) {
            return false;
        }
        if (!PsiTreeUtil.findChildrenOfType((PsiElement)expression, PsiDeclarationStatement.class).isEmpty()) {
            return false;
        }
        PsiType selectorType = switchExpression.getType();
        if (selectorType == null) {
            return false;
        }
        if (SwitchUtils.hasDominated(pattern, existingCaseValues, switchExpression)) {
            return false;
        }
        existingCaseValues.add(pattern);
        return true;
    }

    private static boolean isNullComparison(@Nullable PsiExpression expression, @NotNull PsiExpression switchExpression) {
        if (switchExpression == null) {
            SwitchUtils.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            return false;
        }
        PsiExpression operand = SwitchUtils.findNullCheckedOperand(expression);
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operand);
    }

    @Nullable
    public static PsiCaseLabelElement createPatternFromExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            SwitchUtils.$$$reportNull$$$0(13);
        }
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)expression.getProject());
        String patternCaseText = SwitchUtils.createPatternCaseText(expression);
        if (patternCaseText == null) {
            return null;
        }
        String labelText = "case " + patternCaseText + "->{}";
        PsiStatement statement = factory.createStatementFromText(labelText, (PsiElement)expression);
        PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)statement, PsiSwitchLabelStatementBase.class);
        assert (label != null);
        return Objects.requireNonNull(label.getCaseLabelElementList()).getElements()[0];
    }

    @Contract(pure=true)
    public static boolean isRuleFormatSwitch(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            SwitchUtils.$$$reportNull$$$0(14);
        }
        return PsiUtil.isRuleFormatSwitch((PsiSwitchBlock)block);
    }

    public static boolean canBeSwitchSelectorExpression(@Nullable PsiExpression expression, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            SwitchUtils.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (PsiTypes.charType().equals((Object)type) || PsiTypes.byteType().equals((Object)type) || PsiTypes.shortType().equals((Object)type) || PsiTypes.intType().equals((Object)type)) {
            return true;
        }
        if (type instanceof PsiClassType && languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            if (type.equalsToText("java.lang.Character") || type.equalsToText("java.lang.Byte") || type.equalsToText("java.lang.Short") || type.equalsToText("java.lang.Integer")) {
                return true;
            }
            if (TypeConversionUtil.isEnumType((PsiType)type)) {
                return true;
            }
            if (JavaFeature.STRING_SWITCH.isSufficient(languageLevel) && type.equalsToText("java.lang.String")) {
                return true;
            }
            return PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS_IN_SWITCH, (PsiElement)expression);
        }
        return JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel) && type instanceof PsiPrimitiveType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression getSwitchSelectorExpression(PsiExpression expression) {
        if (expression == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression);
        PsiExpression selectorExpression = SwitchUtils.getPossibleSwitchSelectorExpression(expression, languageLevel);
        return SwitchUtils.canBeSwitchSelectorExpression(selectorExpression, languageLevel) ? selectorExpression : null;
    }

    private static PsiExpression getPossibleSwitchSelectorExpression(@Nullable PsiExpression expression, @NotNull LanguageLevel languageLevel) {
        PsiMethodCallExpression methodCallExpression;
        PsiExpression patternSwitchExpression;
        if (languageLevel == null) {
            SwitchUtils.$$$reportNull$$$0(16);
        }
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return null;
        }
        EqualityCheck check = EqualityCheck.from(expression);
        if (check != null) {
            PsiExpression left = check.getLeft();
            PsiExpression right = check.getRight();
            if (SwitchUtils.canBeCaseLabel(left, languageLevel, null, null)) {
                return right;
            }
            if (SwitchUtils.canBeCaseLabel(right, languageLevel, null, null)) {
                return left;
            }
        }
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS_IN_SWITCH, (PsiElement)expression) && (patternSwitchExpression = SwitchUtils.findPatternSwitchExpression(expression)) != null) {
            return patternSwitchExpression;
        }
        if (expression instanceof PsiMethodCallExpression && STRING_IS_EMPTY.test(methodCallExpression = (PsiMethodCallExpression)expression)) {
            return methodCallExpression.getMethodExpression().getQualifierExpression();
        }
        if (!(expression instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR) && operands.length > 0) {
            return SwitchUtils.getPossibleSwitchSelectorExpression(operands[0], languageLevel);
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands.length == 2) {
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[0]);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[1]);
            if (SwitchUtils.canBeCaseLabel(lhs, languageLevel, null, null)) {
                return rhs;
            }
            if (SwitchUtils.canBeCaseLabel(rhs, languageLevel, null, null)) {
                return lhs;
            }
        }
        if (JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel) && expression instanceof PsiBinaryExpression) {
            PsiExpression right;
            PsiBinaryExpression psiBinaryExpression = (PsiBinaryExpression)expression;
            IElementType operationTokenType = psiBinaryExpression.getOperationTokenType();
            if (!(operationTokenType.equals(JavaTokenType.EQEQ) || operationTokenType.equals(JavaTokenType.GT) || operationTokenType.equals(JavaTokenType.GE) || operationTokenType.equals(JavaTokenType.LT) || operationTokenType.equals(JavaTokenType.LE))) {
                return null;
            }
            PsiExpression left = psiBinaryExpression.getLOperand();
            if (SwitchUtils.primitiveValueCanBeUsedForComparisonInCase(left, right = psiBinaryExpression.getROperand(), null)) {
                return right;
            }
            if (SwitchUtils.primitiveValueCanBeUsedForComparisonInCase(right, left, null)) {
                return left;
            }
        }
        return null;
    }

    @Nullable
    private static PsiExpression findPossiblePatternOperand(@Nullable PsiExpression expression) {
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression psiInstanceOfExpression = (PsiInstanceOfExpression)expression;
            if (SwitchUtils.isUsedOutsideParentIf(psiInstanceOfExpression)) {
                return null;
            }
            return psiInstanceOfExpression.getOperand();
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType operationToken = polyadicExpression.getOperationTokenType();
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (JavaTokenType.ANDAND.equals(operationToken)) {
                PsiExpression patternOperand = SwitchUtils.findPossiblePatternOperand(operands[0]);
                if (patternOperand != null) {
                    return patternOperand;
                }
                for (PsiExpression operand : operands) {
                    PsiExpression pattern = SwitchUtils.findPossiblePatternOperand(operand);
                    if (pattern != null) {
                        return pattern;
                    }
                    if (SideEffectChecker.mayHaveSideEffects(operand)) break;
                }
            }
        }
        return null;
    }

    private static boolean isUsedOutsideParentIf(@NotNull PsiInstanceOfExpression expression) {
        PsiIfStatement ifStatement;
        if (expression == null) {
            SwitchUtils.$$$reportNull$$$0(17);
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)(ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class)), (PsiElement)expression, (boolean)false)) {
            return true;
        }
        return JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)expression).stream().flatMap(variable -> VariableAccessUtils.getVariableReferences((PsiVariable)variable, ifStatement.getParent()).stream()).anyMatch(variable -> !PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)variable, (boolean)false));
    }

    @Nullable
    public static PsiExpression findPatternSwitchExpression(@Nullable PsiExpression expression) {
        PsiExpression[] operands;
        PsiPolyadicExpression polyadicExpression;
        IElementType operationToken;
        PsiExpression patternOperand = SwitchUtils.findPossiblePatternOperand(expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression));
        if (patternOperand != null) {
            return patternOperand;
        }
        PsiExpression nullCheckedOperand = SwitchUtils.findNullCheckedOperand(expression);
        if (nullCheckedOperand != null) {
            return nullCheckedOperand;
        }
        if (expression instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals(operationToken = (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType()) && (operands = polyadicExpression.getOperands()).length == 2) {
            PsiExpression firstOperand = SwitchUtils.findNullCheckedOperand(operands[0]);
            PsiExpression secondOperand = SwitchUtils.findPossiblePatternOperand(operands[1]);
            if (firstOperand == null || secondOperand == null) {
                firstOperand = SwitchUtils.findPossiblePatternOperand(operands[0]);
                secondOperand = SwitchUtils.findNullCheckedOperand(operands[1]);
            }
            if (firstOperand == null || secondOperand == null) {
                return null;
            }
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(firstOperand, secondOperand)) {
                return firstOperand;
            }
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean canBePatternSwitchCase(@Nullable PsiExpression expression, @NotNull PsiExpression switchExpression) {
        if (switchExpression == null) {
            SwitchUtils.$$$reportNull$$$0(18);
        }
        if (expression == null) {
            return false;
        }
        PsiExpression localSwitchExpression = SwitchUtils.findPatternSwitchExpression(expression);
        if (localSwitchExpression == null && expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            localSwitchExpression = SwitchUtils.findSelectorWithComparedPrimitives(polyadicExpression);
        }
        if (localSwitchExpression == null) {
            return false;
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(localSwitchExpression, switchExpression);
    }

    @Nullable
    public static PsiExpression findNullCheckedOperand(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        if (!JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType())) {
            return null;
        }
        if (ExpressionUtils.isNullLiteral(binaryExpression.getLOperand())) {
            return binaryExpression.getROperand();
        }
        if (ExpressionUtils.isNullLiteral(binaryExpression.getROperand())) {
            return binaryExpression.getLOperand();
        }
        return null;
    }

    @Nullable
    @NonNls
    public static String createPatternCaseText(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)expression;
            PsiPrimaryPattern pattern = instanceOf.getPattern();
            if (pattern != null) {
                PsiDeconstructionPattern deconstruction;
                if (pattern instanceof PsiDeconstructionPattern && ErrorUtil.containsError((PsiElement)(deconstruction = (PsiDeconstructionPattern)pattern).getDeconstructionList())) {
                    return null;
                }
                return pattern.getText();
            }
            PsiTypeElement typeElement = instanceOf.getCheckType();
            PsiType type = typeElement != null ? typeElement.getType() : null;
            String name = new VariableNameGenerator((PsiElement)instanceOf, VariableKind.LOCAL_VARIABLE).byType(type).generate(true);
            String typeText = typeElement != null ? typeElement.getText() : "java.lang.Object";
            return typeText + " " + name;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            String textWithPrimitives = SwitchUtils.getSwitchCaseTextWithComparedPrimitives(polyadicExpression);
            if (textWithPrimitives != null) {
                return textWithPrimitives;
            }
            IElementType operationToken = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(operationToken)) {
                Object[] operands = polyadicExpression.getOperands();
                PsiExpression instanceOf = (PsiExpression)ContainerUtil.find((Object[])operands, operand -> operand instanceof PsiInstanceOfExpression);
                StringBuilder builder = new StringBuilder();
                builder.append(SwitchUtils.createPatternCaseText(instanceOf));
                boolean needAppendWhen = PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS, (PsiElement)expression);
                if (!needAppendWhen) {
                    return null;
                }
                for (Object operand2 : operands) {
                    if (operand2 == instanceOf) continue;
                    builder.append(needAppendWhen ? " when " : " && ").append(operand2.getText());
                    needAppendWhen = false;
                }
                return builder.toString();
            }
        }
        return null;
    }

    @Nullable
    private static String getSwitchCaseTextWithComparedPrimitives(@NotNull PsiPolyadicExpression expression) {
        PsiExpression switchSelector;
        if (expression == null) {
            SwitchUtils.$$$reportNull$$$0(19);
        }
        if ((switchSelector = SwitchUtils.findSelectorWithComparedPrimitives(expression)) == null) {
            return null;
        }
        PsiType switchSelectorType = switchSelector.getType();
        if (switchSelectorType == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String name = new VariableNameGenerator((PsiElement)switchSelector, VariableKind.LOCAL_VARIABLE).byType(switchSelectorType).generate(true);
        String typeText = switchSelectorType.getPresentableText();
        stringBuilder.append(typeText).append(" ").append(name).append(" when ");
        for (PsiElement child : expression.getChildren()) {
            if (child instanceof PsiBinaryExpression) {
                PsiBinaryExpression childBinaryExpression = (PsiBinaryExpression)child;
                for (PsiElement binaryChild : childBinaryExpression.getChildren()) {
                    if (SwitchUtils.isSwitchSelector(binaryChild, switchSelector)) {
                        stringBuilder.append(name);
                        continue;
                    }
                    stringBuilder.append(binaryChild.getText());
                }
                continue;
            }
            if (SwitchUtils.isSwitchSelector(child, switchSelector)) {
                stringBuilder.append(name);
                continue;
            }
            stringBuilder.append(child.getText());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSwitchSelector(@NotNull PsiElement child, @NotNull PsiExpression selector) {
        if (child == null) {
            SwitchUtils.$$$reportNull$$$0(20);
        }
        if (selector == null) {
            SwitchUtils.$$$reportNull$$$0(21);
        }
        if (child == selector) {
            return true;
        }
        if (!child.getText().equals(selector.getText())) {
            return false;
        }
        if (!(child instanceof PsiReferenceExpression)) return false;
        PsiReferenceExpression childReference = (PsiReferenceExpression)child;
        if (!(selector instanceof PsiReferenceExpression)) return false;
        PsiReferenceExpression selectorReference = (PsiReferenceExpression)selector;
        PsiElement psiElement = childReference.resolve();
        if (!(psiElement instanceof PsiVariable)) return false;
        PsiVariable childVariable = (PsiVariable)psiElement;
        psiElement = selectorReference.resolve();
        if (!(psiElement instanceof PsiVariable)) return false;
        PsiVariable selectorVariable = (PsiVariable)psiElement;
        if (!child.getManager().areElementsEquivalent((PsiElement)childVariable, (PsiElement)selectorVariable)) return false;
        return true;
    }

    @Nullable
    private static PsiExpression findSelectorWithComparedPrimitives(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            SwitchUtils.$$$reportNull$$$0(22);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, (PsiElement)expression)) {
            return null;
        }
        IElementType operationTokenType = expression.getOperationTokenType();
        ArrayList<PsiBinaryExpression> binaryExpressions = new ArrayList<PsiBinaryExpression>();
        if (operationTokenType == JavaTokenType.OROR || operationTokenType == JavaTokenType.ANDAND) {
            for (PsiExpression operand : expression.getOperands()) {
                if (!(operand instanceof PsiBinaryExpression)) {
                    return null;
                }
                PsiBinaryExpression psiBinaryExpression = (PsiBinaryExpression)operand;
                binaryExpressions.add(psiBinaryExpression);
            }
        } else if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            binaryExpressions.add(binaryExpression);
        } else {
            return null;
        }
        PsiExpression switchSelector = null;
        for (PsiBinaryExpression binaryExpression : binaryExpressions) {
            PsiReferenceExpression referenceExpression;
            PsiReferenceExpression referenceExpression2;
            IElementType binaryExpressionOperationTokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.LE.equals(binaryExpressionOperationTokenType) && !JavaTokenType.LT.equals(binaryExpressionOperationTokenType) && !JavaTokenType.GE.equals(binaryExpressionOperationTokenType) && !JavaTokenType.GT.equals(binaryExpressionOperationTokenType)) continue;
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            if (lOperand instanceof PsiReferenceExpression && (referenceExpression2 = (PsiReferenceExpression)lOperand).resolve() instanceof PsiVariable && ExpressionUtils.computeConstantExpression(rOperand) != null) {
                if (switchSelector != null && !equivalence.expressionsAreEquivalent(switchSelector, lOperand)) {
                    return null;
                }
                switchSelector = lOperand;
                continue;
            }
            if (!(rOperand instanceof PsiReferenceExpression) || !((referenceExpression = (PsiReferenceExpression)rOperand).resolve() instanceof PsiVariable) || ExpressionUtils.computeConstantExpression(lOperand) == null) continue;
            if (switchSelector != null && !equivalence.expressionsAreEquivalent(switchSelector, rOperand)) {
                return null;
            }
            switchSelector = rOperand;
        }
        if (switchSelector == null) {
            return null;
        }
        PsiType switchSelectorType = switchSelector.getType();
        if (switchSelectorType == null || !TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)switchSelectorType)) {
            return null;
        }
        return switchSelector;
    }

    private static boolean canBeCaseLabel(@Nullable PsiExpression expression, @NotNull LanguageLevel languageLevel, @Nullable Set<Object> existingCaseValues, @Nullable PsiExpression switchExpression) {
        PsiReferenceExpression ref;
        PsiElement referent;
        if (languageLevel == null) {
            SwitchUtils.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            return false;
        }
        if (JavaFeature.ENUMS.isSufficient(languageLevel) && expression instanceof PsiReferenceExpression && (referent = (ref = (PsiReferenceExpression)expression).resolve()) instanceof PsiEnumConstant) {
            if (switchExpression != null && SwitchUtils.hasDominated((PsiCaseLabelElement)expression, existingCaseValues, switchExpression)) {
                return false;
            }
            return existingCaseValues == null || existingCaseValues.add(referent);
        }
        PsiType type = expression.getType();
        if (!(JavaFeature.STRING_SWITCH.isSufficient(languageLevel) && TypeUtils.isJavaLangString(type) || PsiTypes.intType().equals((Object)type) || PsiTypes.shortType().equals((Object)type) || PsiTypes.byteType().equals((Object)type) || PsiTypes.charType().equals((Object)type))) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return false;
        }
        if (switchExpression != null && SwitchUtils.hasDominated((PsiCaseLabelElement)expression, existingCaseValues, switchExpression)) {
            return false;
        }
        return existingCaseValues == null || existingCaseValues.add(value);
    }

    public static String findUniqueLabelName(PsiStatement statement, @NonNls String baseName) {
        PsiElement ancestor = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMember.class);
        if (ancestor == null || !SwitchUtils.checkForLabel(baseName, ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (SwitchUtils.checkForLabel(name = baseName + val, ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, PsiElement ancestor) {
        LabelSearchVisitor visitor2 = new LabelSearchVisitor(name);
        ancestor.accept((PsiElementVisitor)visitor2);
        return visitor2.isUsed();
    }

    @NotNull
    public static @Unmodifiable List<PsiEnumConstant> findEnumConstants(PsiSwitchLabelStatementBase label) {
        if (label == null) {
            List<PsiEnumConstant> list = Collections.emptyList();
            if (list == null) {
                SwitchUtils.$$$reportNull$$$0(24);
            }
            return list;
        }
        PsiCaseLabelElementList list = label.getCaseLabelElementList();
        if (list == null) {
            List<PsiEnumConstant> list2 = Collections.emptyList();
            if (list2 == null) {
                SwitchUtils.$$$reportNull$$$0(25);
            }
            return list2;
        }
        ArrayList<PsiEnumConstant> constants = new ArrayList<PsiEnumConstant>();
        for (PsiCaseLabelElement labelElement : list.getElements()) {
            PsiElement target;
            PsiExpression expr;
            if (labelElement instanceof PsiDefaultCaseLabelElement || labelElement instanceof PsiExpression && ExpressionUtils.isNullLiteral(expr = (PsiExpression)labelElement)) continue;
            if (labelElement instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)labelElement).resolve()) instanceof PsiEnumConstant) {
                constants.add((PsiEnumConstant)target);
                continue;
            }
            List<PsiEnumConstant> list3 = Collections.emptyList();
            if (list3 == null) {
                SwitchUtils.$$$reportNull$$$0(26);
            }
            return list3;
        }
        ArrayList<PsiEnumConstant> arrayList = constants;
        if (arrayList == null) {
            SwitchUtils.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    public static boolean isDefaultLabel(@Nullable PsiSwitchLabelStatementBase label) {
        if (label == null) {
            return false;
        }
        if (label.isDefaultCase()) {
            return true;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        if (labelElementList == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])labelElementList.getElements(), element -> element instanceof PsiDefaultCaseLabelElement);
    }

    public static boolean hasOnlyDefaultCase(@Nullable PsiSwitchLabelStatementBase label) {
        if (label == null) {
            return false;
        }
        if (label.isDefaultCase()) {
            return true;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        return labelElementList != null && labelElementList.getElementCount() == 1 && labelElementList.getElements()[0] instanceof PsiDefaultCaseLabelElement;
    }

    public static boolean isCaseNull(@Nullable PsiSwitchLabelStatementBase label) {
        PsiExpression expr;
        PsiCaseLabelElement psiCaseLabelElement;
        if (label == null) {
            return false;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        return labelElementList != null && labelElementList.getElementCount() == 1 && (psiCaseLabelElement = labelElementList.getElements()[0]) instanceof PsiExpression && ExpressionUtils.isNullLiteral(expr = (PsiExpression)psiCaseLabelElement);
    }

    public static boolean isCaseNullDefault(@Nullable PsiSwitchLabelStatementBase label) {
        PsiExpression expr;
        PsiCaseLabelElement psiCaseLabelElement;
        if (label == null) {
            return false;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        return labelElementList != null && labelElementList.getElementCount() == 2 && (psiCaseLabelElement = labelElementList.getElements()[0]) instanceof PsiExpression && ExpressionUtils.isNullLiteral(expr = (PsiExpression)psiCaseLabelElement) && labelElementList.getElements()[1] instanceof PsiDefaultCaseLabelElement;
    }

    public static boolean isUnconditionalLabel(@Nullable PsiSwitchLabelStatementBase label) {
        if (label == null) {
            return false;
        }
        if (SwitchUtils.isDefaultLabel(label)) {
            return true;
        }
        PsiSwitchBlock switchBlock = label.getEnclosingSwitchBlock();
        if (switchBlock == null) {
            return false;
        }
        PsiExpression expression = switchBlock.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        if (labelElementList == null) {
            return false;
        }
        return StreamEx.of((Object[])labelElementList.getElements()).select(PsiPattern.class).anyMatch(pattern -> JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)pattern, (PsiType)type));
    }

    public static @Unmodifiable List<PsiCaseLabelElement> findRemovableUnreachableBranches(PsiCaseLabelElement reachableLabel, PsiSwitchBlock statement) {
        PsiSwitchLabeledRuleStatement ruleStatement;
        boolean canUnwrap;
        PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)reachableLabel, PsiSwitchLabelStatementBase.class);
        List allBranches = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatementBase.class);
        boolean hasDefault = false;
        ArrayList<PsiCaseLabelElement> unreachableElements = new ArrayList<PsiCaseLabelElement>();
        for (PsiSwitchLabelStatementBase branch : allBranches) {
            if (branch.isDefaultCase()) {
                hasDefault = true;
                continue;
            }
            PsiCaseLabelElementList elementList = branch.getCaseLabelElementList();
            if (elementList == null) continue;
            PsiCaseLabelElement[] elements = elementList.getElements();
            unreachableElements.addAll(Arrays.asList(elements));
        }
        unreachableElements.remove(reachableLabel);
        boolean bl = canUnwrap = statement instanceof PsiSwitchStatement && BreakConverter.from(statement) != null || statement instanceof PsiSwitchExpression && labelStatement instanceof PsiSwitchLabeledRuleStatement && (ruleStatement = (PsiSwitchLabeledRuleStatement)labelStatement).getBody() instanceof PsiExpressionStatement;
        if (canUnwrap) {
            return unreachableElements;
        }
        if (unreachableElements.isEmpty() || hasDefault) {
            return unreachableElements;
        }
        boolean isEnhancedSwitch = ExpressionUtil.isEnhancedSwitch((PsiSwitchBlock)statement);
        if (isEnhancedSwitch) {
            PsiExpression expression = statement.getExpression();
            if (expression == null) {
                return List.of();
            }
            PsiType selectorType = expression.getType();
            if (selectorType == null) {
                return List.of();
            }
            ArrayList<PsiCaseLabelElement> toDelete = new ArrayList<PsiCaseLabelElement>();
            for (int i = 0; i < unreachableElements.size(); ++i) {
                PsiCaseLabelElement nextElement;
                PsiCaseLabelElement currentElement = (PsiCaseLabelElement)unreachableElements.get(i);
                boolean isDominated = false;
                for (int j = i + 1; j < unreachableElements.size() && (isDominated = JavaPsiSwitchUtil.isDominated((PsiCaseLabelElement)currentElement, (PsiElement)(nextElement = (PsiCaseLabelElement)unreachableElements.get(j)), (PsiType)selectorType)); ++j) {
                }
                if (isDominated) continue;
                toDelete.add(currentElement);
            }
            unreachableElements.removeAll(toDelete);
        }
        return unreachableElements;
    }

    @NotNull
    public static SwitchExhaustivenessState evaluateSwitchCompleteness(@NotNull PsiSwitchBlock switchBlock, boolean considerNestedDeconstructionPatterns) {
        boolean hasError;
        boolean isEnumSelector;
        PsiExpression selector;
        if (switchBlock == null) {
            SwitchUtils.$$$reportNull$$$0(28);
        }
        if ((selector = switchBlock.getExpression()) == null) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.MALFORMED;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(29);
            }
            return switchExhaustivenessState;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.MALFORMED;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(30);
            }
            return switchExhaustivenessState;
        }
        PsiCodeBlock switchBody = switchBlock.getBody();
        if (switchBody == null) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.MALFORMED;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(31);
            }
            return switchExhaustivenessState;
        }
        List labelElements = ((StreamEx)StreamEx.of((Collection)JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)switchBlock)).select(PsiCaseLabelElement.class).filter(element -> !(element instanceof PsiDefaultCaseLabelElement))).toList();
        if (labelElements.isEmpty()) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.EMPTY;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(32);
            }
            return switchExhaustivenessState;
        }
        boolean needToCheckCompleteness = ExpressionUtil.isEnhancedSwitch((PsiSwitchBlock)switchBlock);
        boolean bl = isEnumSelector = JavaPsiSwitchUtil.getSwitchSelectorKind((PsiType)selectorType) == JavaPsiSwitchUtil.SelectorKind.ENUM;
        if (ContainerUtil.find((Iterable)labelElements, element -> JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)element, (PsiType)selectorType)) != null) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.EXHAUSTIVE_NO_DEFAULT;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(33);
            }
            return switchExhaustivenessState;
        }
        if (JavaPsiSwitchUtil.isBooleanSwitchWithTrueAndFalse((PsiSwitchBlock)switchBlock)) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.EXHAUSTIVE_NO_DEFAULT;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(34);
            }
            return switchExhaustivenessState;
        }
        if (!needToCheckCompleteness && !isEnumSelector) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.INCOMPLETE;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(35);
            }
            return switchExhaustivenessState;
        }
        if (!considerNestedDeconstructionPatterns) {
            labelElements = ContainerUtil.filter((Collection)labelElements, label -> {
                PsiDeconstructionPattern deconstructionPattern;
                return !(label instanceof PsiDeconstructionPattern && ContainerUtil.or((Object[])(deconstructionPattern = (PsiDeconstructionPattern)label).getDeconstructionList().getDeconstructionComponents(), component -> component instanceof PsiDeconstructionPattern));
            });
        }
        if (!(hasError = JavaPatternExhaustivenessUtil.hasExhaustivenessError((PsiSwitchBlock)switchBlock, (List)labelElements))) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.EXHAUSTIVE_CAN_ADD_DEFAULT;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(36);
            }
            return switchExhaustivenessState;
        }
        if (needToCheckCompleteness) {
            SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.UNNECESSARY;
            if (switchExhaustivenessState == null) {
                SwitchUtils.$$$reportNull$$$0(37);
            }
            return switchExhaustivenessState;
        }
        SwitchExhaustivenessState switchExhaustivenessState = SwitchExhaustivenessState.INCOMPLETE;
        if (switchExhaustivenessState == null) {
            SwitchUtils.$$$reportNull$$$0(38);
        }
        return switchExhaustivenessState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingCaseValues";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/SwitchUtils";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/SwitchUtils";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findEnumConstants";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSwitchCompleteness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchCount";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "countUnconditionalPatterns";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeSwitchCase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isComparisonWithPrimitives";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasDominated";
                break;
            }
            case 10: 
            case 11: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canBePatternSwitchCase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNullComparison";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPatternFromExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRuleFormatSwitch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canBeSwitchSelectorExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleSwitchSelectorExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUsedOutsideParentIf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchCaseTextWithComparedPrimitives";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSwitchSelector";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSelectorWithComparedPrimitives";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canBeCaseLabel";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSwitchCompleteness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 -> new IllegalStateException(string);
        };
    }

    private static class LabelSearchVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String m_labelName;
        private boolean m_used = false;

        LabelSearchVisitor(String name) {
            this.m_labelName = name;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                LabelSearchVisitor.$$$reportNull$$$0(0);
            }
            if (this.m_used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
            PsiIdentifier labelIdentifier;
            String labelText;
            if (statement == null) {
                LabelSearchVisitor.$$$reportNull$$$0(1);
            }
            if ((labelText = (labelIdentifier = statement.getLabelIdentifier()).getText()).equals(this.m_labelName)) {
                this.m_used = true;
            }
        }

        public boolean isUsed() {
            return this.m_used;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/SwitchUtils$LabelSearchVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLabeledStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum SwitchExhaustivenessState {
        MALFORMED,
        EMPTY,
        UNNECESSARY,
        INCOMPLETE,
        EXHAUSTIVE_NO_DEFAULT,
        EXHAUSTIVE_CAN_ADD_DEFAULT;

    }

    public static class IfStatementBranch {
        private final Set<String> topLevelVariables = new HashSet<String>(3);
        private final LinkedList<String> comments = new LinkedList();
        private final LinkedList<String> statementComments = new LinkedList();
        private final List<PsiExpression> caseExpressions = new ArrayList<PsiExpression>(3);
        private final PsiStatement statement;
        private final boolean elseBranch;
        private boolean hasPattern;

        public IfStatementBranch(PsiStatement branch, boolean elseBranch) {
            this.statement = branch;
            this.elseBranch = elseBranch;
            this.calculateVariablesDeclared(this.statement);
        }

        public void addComment(String comment) {
            this.comments.addFirst(comment);
        }

        public void addStatementComment(String comment) {
            this.statementComments.addFirst(comment);
        }

        public void addCaseExpression(PsiExpression expression) {
            if (SwitchUtils.createPatternCaseText(expression) != null) {
                this.hasPattern = true;
            }
            this.caseExpressions.add(expression);
        }

        public boolean hasPattern() {
            return this.hasPattern;
        }

        public PsiStatement getStatement() {
            return this.statement;
        }

        public List<PsiExpression> getCaseExpressions() {
            return Collections.unmodifiableList(this.caseExpressions);
        }

        public boolean isElse() {
            return this.elseBranch;
        }

        public boolean topLevelDeclarationsConflictWith(IfStatementBranch testBranch) {
            return IfStatementBranch.intersects(this.topLevelVariables, testBranch.topLevelVariables);
        }

        private static boolean intersects(Set<String> set1, Set<String> set2) {
            for (String s : set1) {
                if (!set2.contains(s)) continue;
                return true;
            }
            return false;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public List<String> getStatementComments() {
            return this.statementComments;
        }

        public void calculateVariablesDeclared(PsiStatement statement) {
            block4: {
                PsiStatement[] statements;
                block3: {
                    PsiElement[] elements;
                    if (statement == null) {
                        return;
                    }
                    if (!(statement instanceof PsiDeclarationStatement)) break block3;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
                        PsiVariable variable = (PsiVariable)element;
                        String varName = variable.getName();
                        this.topLevelVariables.add(varName);
                    }
                    break block4;
                }
                if (!(statement instanceof PsiBlockStatement)) break block4;
                PsiBlockStatement block = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                for (PsiStatement statement1 : statements = codeBlock.getStatements()) {
                    this.calculateVariablesDeclared(statement1);
                }
            }
        }
    }
}

