/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.daemon.impl.analysis.LocalRefUseInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor2 = new VariableAssignedFromVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor2 = new VariablePassedAsArgumentVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, Processor<? super PsiCall> callProcessor) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(2);
        }
        return VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, false, callProcessor);
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern, Processor<? super PsiCall> callProcessor) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor2 = new VariablePassedAsArgumentExcludedVisitor(variable, builderPattern, callProcessor);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor2 = new VariableUsedInArrayInitializerVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(5);
        }
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("private")) {
                PsiClass aClass = PsiUtil.getTopLevelClass((PsiElement)variable);
                return VariableAccessUtils.variableIsAssigned(variable, (PsiElement)aClass);
            }
            return DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)variable, false) || ReferencesSearch.search((PsiElement)variable).anyMatch(reference -> {
                PsiExpression expression;
                PsiElement patt0$temp = reference.getElement();
                return patt0$temp instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)(expression = (PsiExpression)patt0$temp));
            });
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiLambdaExpression.class, PsiCatchSection.class, PsiForStatement.class, PsiForeachStatement.class});
        return VariableAccessUtils.variableIsAssigned(variable, context);
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(6);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @NotNull Predicate<? super PsiAssignmentExpression> skipFilter, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(7);
        }
        if (skipFilter == null) {
            VariableAccessUtils.$$$reportNull$$$0(8);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable, skipFilter, true);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(9);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable, recurseIntoClasses);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(10);
        }
        return VariableAccessUtils.variableIsReturned(variable, context, false);
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(11);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableReturnedVisitor visitor2 = new VariableReturnedVisitor(variable, builderPattern);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(12);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableValueUsedVisitor visitor2 = new VariableValueUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(13);
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor2 = new ArrayContentsAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(14);
        }
        if (context == null || variable.isUnnamed()) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor2 = new VariableUsedInInnerClassVisitor(variable);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(15);
        }
        return VariableAccessUtils.mayEvaluateToVariable(expression, variable, false);
    }

    static boolean mayEvaluateToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable, boolean builderPattern) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(16);
        }
        if (expression == null || variable.isUnnamed()) {
            return false;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression, variable, builderPattern) || VariableAccessUtils.mayEvaluateToVariable(elseExpression, variable, builderPattern);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type = variable.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count;
            }
            return count != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable, builderPattern);
        }
        if (builderPattern && expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            PsiType variableType = variable.getType();
            if (!variableType.equals(returnType)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return VariableAccessUtils.mayEvaluateToVariable(qualifier, variable, true);
        }
        return ExpressionUtils.isReferenceTo(expression, variable);
    }

    public static @Unmodifiable List<PsiReferenceExpression> getVariableReferences(@NotNull PsiVariable variable) {
        PsiFile file;
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(17);
        }
        if ((file = variable.getContainingFile()) == null) {
            return List.of();
        }
        if (!file.isPhysical()) {
            return VariableAccessUtils.getVariableReferences(variable, (PsiElement)(variable instanceof PsiField ? file : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null)));
        }
        return LocalRefUseInfo.forFile(file).getVariableReferences(variable, null);
    }

    public static @Unmodifiable List<PsiReferenceExpression> getVariableReferencesNoCache(@NotNull PsiVariable variable) {
        PsiFile scope;
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(18);
        }
        Object object = scope = variable instanceof PsiField ? variable.getContainingFile() : PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (scope == null) {
            return List.of();
        }
        return VariableAccessUtils.getVariableReferencesNoCache(variable, (PsiElement)scope);
    }

    public static @Unmodifiable List<PsiReferenceExpression> getVariableReferences(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(19);
        }
        if (context == null) {
            return Collections.emptyList();
        }
        PsiFile file = context.getContainingFile();
        PsiFile variableFile = variable.getContainingFile();
        if (variableFile != null && file == variableFile && file.isPhysical()) {
            return LocalRefUseInfo.forFile(file).getVariableReferences(variable, context);
        }
        return VariableAccessUtils.getVariableReferencesNoCache(variable, context);
    }

    @NotNull
    private static @Unmodifiable List<PsiReferenceExpression> getVariableReferencesNoCache(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(20);
        }
        if (context == null) {
            VariableAccessUtils.$$$reportNull$$$0(21);
        }
        ArrayList<PsiReferenceExpression> result = new ArrayList<PsiReferenceExpression>();
        PsiTreeUtil.processElements((PsiElement)context, e -> {
            if (e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).isReferenceTo((PsiElement)variable)) {
                result.add((PsiReferenceExpression)e);
            }
            return true;
        });
        ArrayList<PsiReferenceExpression> arrayList = result;
        if (arrayList == null) {
            VariableAccessUtils.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Contract(value="_, null -> false")
    public static boolean variableIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(23);
        }
        if (context == null) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        PsiFile variableFile = variable.getContainingFile();
        if (variableFile != null && file == variableFile && file.isPhysical()) {
            return LocalRefUseInfo.forFile(file).isVariableUsed(variable, context);
        }
        return VariableUsedVisitor.isVariableUsedIn(variable, context);
    }

    public static boolean variableIsDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(24);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, false);
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(25);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, true);
    }

    private static boolean variableIsIncrementedOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement, boolean incremented) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(26);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (expression instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression;
            IElementType tokenType = unaryExpression.getOperationTokenType();
            if (!tokenType.equals(incremented ? JavaTokenType.PLUSPLUS : JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = unaryExpression.getOperand();
            return ExpressionUtils.isReferenceTo(operand, variable);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!ExpressionUtils.isReferenceTo(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (binaryTokenType != (incremented ? JavaTokenType.PLUS : JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand)) {
                    return ExpressionUtils.isReferenceTo(rOperand, variable);
                }
                if (ExpressionUtils.isOne(rOperand)) {
                    return ExpressionUtils.isReferenceTo(lOperand, variable);
                }
            } else if (tokenType == (incremented ? JavaTokenType.PLUSEQ : JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (referenceExpression == null) {
            VariableAccessUtils.$$$reportNull$$$0(27);
        }
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable, context, (PsiElement)referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children;
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(28);
        }
        if (point == null) {
            VariableAccessUtils.$$$reportNull$$$0(29);
        }
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            VariableAccessUtils.$$$reportNull$$$0(30);
        }
        if (descendant == null) {
            VariableAccessUtils.$$$reportNull$$$0(31);
        }
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals((Object)ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    public static @Unmodifiable Set<PsiVariable> collectUsedVariables(PsiElement context) {
        if (context == null) {
            return Collections.emptySet();
        }
        VariableCollectingVisitor visitor2 = new VariableCollectingVisitor();
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.getUsedVariables();
    }

    public static boolean isAnyVariableAssigned(@NotNull @Unmodifiable Collection<? extends PsiVariable> variables, @Nullable PsiElement context) {
        if (variables == null) {
            VariableAccessUtils.$$$reportNull$$$0(32);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variables, true);
        context.accept((PsiElementVisitor)visitor2);
        return visitor2.isAssigned();
    }

    public static boolean isLocalVariableCopy(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(33);
        }
        return VariableAccessUtils.isLocalVariableCopy(variable, PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()));
    }

    public static boolean isLocalVariableCopy(@NotNull PsiLocalVariable variable, @Nullable PsiExpression expression) {
        PsiReferenceExpression reference;
        PsiElement psiElement;
        PsiExpression operand;
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(34);
        }
        if (expression instanceof PsiTypeCastExpression && (operand = ((PsiTypeCastExpression)expression).getOperand()) instanceof PsiReferenceExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)expression)) {
            expression = operand;
        }
        if (!(expression instanceof PsiReferenceExpression) || !((psiElement = (reference = (PsiReferenceExpression)expression).resolve()) instanceof PsiVariable)) {
            return false;
        }
        PsiVariable initialization = (PsiVariable)psiElement;
        if (!(initialization instanceof PsiResourceVariable) && variable instanceof PsiResourceVariable) {
            return false;
        }
        if (!(initialization instanceof PsiLocalVariable || initialization instanceof PsiParameter || VariableAccessUtils.isFinalChain(reference) && VariableAccessUtils.getVariableReferences((PsiVariable)variable).size() == 1)) {
            return false;
        }
        PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (containingScope == null) {
            return false;
        }
        if (VariableAccessUtils.variableMayChange(containingScope, null, (PsiVariable)variable)) {
            return false;
        }
        if (VariableAccessUtils.variableMayChange(containingScope, PsiUtil.skipParenthesizedExprDown((PsiExpression)reference.getQualifierExpression()), initialization)) {
            return false;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)containingScope.getProject()).getResolveHelper();
        String initializationName = initialization.getName();
        if (initializationName == null) {
            return false;
        }
        boolean finalVariableIntroduction = !initialization.hasModifierProperty("final") && variable.hasModifierProperty("final") || PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)initialization) && !ControlFlowUtil.isEffectivelyFinal((PsiVariable)initialization, (PsiElement)containingScope) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)containingScope);
        boolean canCaptureThis = initialization instanceof PsiField && !initialization.hasModifierProperty("static");
        PsiType variableType = variable.getType();
        PsiType initializationType = initialization.getType();
        boolean sameType = Comparing.equal((Object)variableType, (Object)initializationType);
        for (PsiReferenceExpression refElement : VariableAccessUtils.getVariableReferences((PsiVariable)variable)) {
            if (finalVariableIntroduction || canCaptureThis) {
                PsiElement element = LambdaUtil.getContainingClassOrLambda((PsiElement)refElement);
                if (element != null && PsiTreeUtil.isAncestor((PsiElement)containingScope, (PsiElement)element, (boolean)true)) {
                    return false;
                }
                PsiSwitchLabelStatementBase switchLabel = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiSwitchLabelStatementBase.class);
                if (switchLabel != null && switchLabel.getGuardExpression() != null && PsiTreeUtil.isAncestor((PsiElement)switchLabel.getGuardExpression(), (PsiElement)refElement, (boolean)true) && PsiTreeUtil.isAncestor((PsiElement)containingScope, (PsiElement)switchLabel, (boolean)true)) {
                    return false;
                }
            }
            if (resolveHelper.resolveReferencedVariable(initializationName, (PsiElement)refElement) != initialization) {
                return false;
            }
            if (sameType || VariableAccessUtils.isVariableTypeChangeSafeForReference(initializationType, refElement)) continue;
            return false;
        }
        return !TypeConversionUtil.boxingConversionApplicable((PsiType)variableType, (PsiType)initializationType);
    }

    public static @Unmodifiable List<PsiVariable> findDeclaredVariables(@NotNull PsiStatement statement) {
        if (statement == null) {
            VariableAccessUtils.$$$reportNull$$$0(35);
        }
        final ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                variables.add(variable);
                super.visitVariable(variable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/VariableAccessUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return variables;
    }

    private static boolean isFinalChain(PsiReferenceExpression reference) {
        PsiElement element;
        while ((element = reference.resolve()) instanceof PsiField) {
            if (!((PsiField)element).hasModifierProperty("final")) {
                return false;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)reference.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            reference = (PsiReferenceExpression)qualifier;
        }
        return true;
    }

    private static boolean variableMayChange(PsiCodeBlock containingScope, PsiExpression qualifier, PsiVariable variable) {
        while (variable != null) {
            PsiVariable v;
            if (!variable.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(variable, (PsiElement)containingScope, false)) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) break;
            PsiReferenceExpression qualifierReference = (PsiReferenceExpression)qualifier;
            qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierReference.getQualifierExpression());
            PsiElement psiElement = qualifierReference.resolve();
            variable = psiElement instanceof PsiVariable ? (v = (PsiVariable)psiElement) : null;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean canUseAsNonFinal(PsiLocalVariable var) {
        if (var == null) {
            return false;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        return block != null && VariableAccessUtils.getVariableReferences((PsiVariable)var).stream().map(ref -> (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})).allMatch(context -> context == null || PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)block, (boolean)false));
    }

    public static boolean isVariableTypeChangeSafeForReference(@NotNull PsiType targetType, @NotNull PsiReferenceExpression reference) {
        PsiMember member;
        PsiReferenceExpression ref;
        PsiElement resolve;
        PsiElement castTypeElement2;
        if (targetType == null) {
            VariableAccessUtils.$$$reportNull$$$0(36);
        }
        if (reference == null) {
            VariableAccessUtils.$$$reportNull$$$0(37);
        }
        if (targetType instanceof PsiLambdaParameterType || PsiTypes.nullType().equals(targetType)) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent());
        if (PsiUtil.isAccessedForWriting((PsiExpression)reference)) {
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return false;
            }
            PsiType rValueType = rValue.getType();
            return rValueType != null && targetType.isAssignableFrom(rValueType);
        }
        while (parent instanceof PsiConditionalExpression) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)parent;
            PsiTypeElement checkTypeElement = instanceOf.getCheckType();
            if (checkTypeElement == null) {
                return false;
            }
            PsiType checkType = checkTypeElement.getType();
            return TypeConversionUtil.areTypesConvertible((PsiType)targetType, (PsiType)checkType);
        }
        if (parent instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression parentCast = (PsiTypeCastExpression)parent;
            PsiTypeElement castTypeElement2 = parentCast.getCastType();
            if (castTypeElement2 == null) {
                return false;
            }
            PsiType castType = castTypeElement2.getType();
            return TypeConversionUtil.areTypesConvertible((PsiType)targetType, (PsiType)castType);
        }
        if (parent instanceof PsiExpressionList && (castTypeElement2 = parent.getParent()) instanceof PsiCallExpression) {
            PsiCallExpression call = (PsiCallExpression)castTypeElement2;
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)reference, (Object)mark);
            PsiCallExpression callCopy = (PsiCallExpression)call.copy();
            PsiTreeUtil.releaseMark((PsiElement)reference, (Object)mark);
            PsiElement refCopy = PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)mark);
            if (refCopy == null) {
                return false;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
            PsiTypeCastExpression insertedCast = (PsiTypeCastExpression)refCopy.replace((PsiElement)factory.createExpressionFromText("(a)" + reference.getReferenceName(), refCopy));
            Objects.requireNonNull(insertedCast.getCastType()).replace((PsiElement)factory.createTypeElement(targetType));
            return callCopy.resolveMethod() == method;
        }
        return !(parent instanceof PsiReferenceExpression) || !((resolve = (ref = (PsiReferenceExpression)parent).resolve()) instanceof PsiMember) || !(member = (PsiMember)resolve).hasModifierProperty("private");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipFilter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/VariableAccessUtils";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/VariableAccessUtils";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableReferencesNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "variableIsAssignedFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "variableIsPassedAsMethodArgument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "variableIsUsedInArrayInitializer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "variableIsAssigned";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "variableIsReturned";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "variableValueIsUsed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "arrayContentsAreAssigned";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "variableIsUsedInInnerClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mayEvaluateToVariable";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferences";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferencesNoCache";
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "variableIsUsed";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "variableIsDecremented";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "variableIsIncremented";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "variableIsIncrementedOrDecremented";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "variableIsAssignedBeforeReference";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "variableIsAssignedAtPoint";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDirectChildWhichContainsElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isAnyVariableAssigned";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isLocalVariableCopy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredVariables";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isVariableTypeChangeSafeForReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22 -> new IllegalStateException(string);
        };
    }

    private static class VariableCollectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiVariable> usedVariables = new HashSet<PsiVariable>();

        private VariableCollectingVisitor() {
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                VariableCollectingVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            this.usedVariables.add(variable);
        }

        public Set<PsiVariable> getUsedVariables() {
            return this.usedVariables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/VariableAccessUtils$VariableCollectingVisitor", "visitReferenceExpression"));
        }
    }
}

