/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableNameGenerator {
    @NotNull
    private final JavaCodeStyleManager myManager;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final VariableKind myKind;
    @NonNls
    private final Set<String> candidates;
    @NonNls
    private final Set<String> skipNames;

    public VariableNameGenerator(@NotNull PsiElement context, @NotNull VariableKind kind) {
        if (context == null) {
            VariableNameGenerator.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            VariableNameGenerator.$$$reportNull$$$0(1);
        }
        this.candidates = new LinkedHashSet<String>();
        this.skipNames = new HashSet<String>();
        this.myManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
        this.myContext = context;
        this.myKind = kind;
    }

    @Contract(value="_ -> this")
    public VariableNameGenerator byType(@Nullable PsiType type) {
        if (type != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, null, type, true);
            this.candidates.addAll(Arrays.asList(info.names));
            if (type.equals(PsiTypes.intType())) {
                this.candidates.add("j");
                this.candidates.add("k");
            }
        }
        return this;
    }

    @Contract(value="_ -> this")
    public VariableNameGenerator byExpression(@Nullable PsiExpression expression) {
        if (expression != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, expression, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    @Contract(value="_ -> this")
    public VariableNameGenerator byCollectionName(@Nullable String name) {
        if (name != null) {
            PsiExpression expr = JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createExpressionFromText(name + "[0]", this.myContext);
            this.byExpression(expr);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public VariableNameGenerator byName(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, name, null, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    @Contract(value="_->this")
    public VariableNameGenerator skipNames(@NotNull @NotNull Collection<@NotNull String> names) {
        if (names == null) {
            VariableNameGenerator.$$$reportNull$$$0(2);
        }
        this.skipNames.addAll(names);
        return this;
    }

    @NotNull
    public String generate(boolean lookForward) {
        String suffixed = null;
        @NonNls Set<String> candidates = this.candidates.isEmpty() ? Collections.singleton("v") : this.candidates;
        for (String candidate : candidates) {
            String name = this.myManager.suggestUniqueVariableName(candidate, this.myContext, lookForward, this.skipNames);
            if (name.equals(candidate)) {
                String string = name;
                if (string == null) {
                    VariableNameGenerator.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (suffixed != null) continue;
            suffixed = name;
        }
        String string = suffixed;
        if (string == null) {
            VariableNameGenerator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<String> generateAll(boolean lookForward) {
        ArrayList<String> suffixed = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        @NonNls String defaultVariableName = "v";
        Iterator<String> iterator = (this.candidates.isEmpty() ? Collections.singleton("v") : this.candidates).iterator();
        while (iterator.hasNext()) {
            PsiNameIdentifierOwner owner;
            String candidate;
            PsiElement psiElement = this.myContext;
            String name = psiElement instanceof PsiNameIdentifierOwner && candidate.equals((owner = (PsiNameIdentifierOwner)psiElement).getName()) ? candidate : this.myManager.suggestUniqueVariableName(candidate, this.myContext, lookForward, this.skipNames);
            if (name.equals(candidate = iterator.next())) {
                result.add(name);
                continue;
            }
            suffixed.add(name);
        }
        result.addAll(suffixed);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            VariableNameGenerator.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/VariableNameGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/VariableNameGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

