/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SocketResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        return "SocketOpenedButNotSafelyClosed";
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"accept".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || !TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.net.ServerSocket")) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)methodCallExpression, "java.net.Socket");
        }
        if (expression instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, "java.net.Socket", "java.net.DatagramSocket", "java.net.ServerSocket") != null;
        }
        return false;
    }
}

