/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class ComparatorNotSerializableInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparator.not.serializable.problem.descriptor", new Object[0]);
        if (string == null) {
            ComparatorNotSerializableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return DelegatingFixFactory.createMakeSerializableFix((PsiClass)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ComparatorNotSerializableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/ComparatorNotSerializableInspection", "buildErrorString"));
    }

    private static class ComparatorNotSerializableVisitor
    extends BaseInspectionVisitor {
        private ComparatorNotSerializableVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ComparatorNotSerializableVisitor.$$$reportNull$$$0(0);
            }
            if (aClass instanceof PsiAnonymousClass || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Comparator") || SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/ComparatorNotSerializableInspection$ComparatorNotSerializableVisitor", "visitClass"));
        }
    }
}

