/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class ExternalizableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ExternalizableClassWithSerializationMethods";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        int ordinal = ClassUtils.getTypeOrdinal((PsiClass)infos[2]);
        if (hasReadObject && hasWriteObject) {
            String string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.both", ordinal);
            if (string == null) {
                ExternalizableWithSerializationMethodsInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (hasWriteObject) {
            String string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.write", ordinal);
            if (string == null) {
                ExternalizableWithSerializationMethodsInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.read", ordinal);
        if (string == null) {
            ExternalizableWithSerializationMethodsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ExternalizableDefinesSerializationMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection", "buildErrorString"));
    }

    private static class ExternalizableDefinesSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private ExternalizableDefinesSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExternalizableDefinesSerializationMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isAnnotationType() || !SerializationUtils.isExternalizable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection$ExternalizableDefinesSerializationMethodsVisitor", "visitClass"));
        }
    }
}

