/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SerialPersistentFieldsWithWrongSignatureInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serialpersistentfields.with.wrong.signature.problem.descriptor", new Object[0]);
        if (string == null) {
            SerialPersistentFieldsWithWrongSignatureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerialPersistentFieldsWithWrongSignatureVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerialPersistentFieldsWithWrongSignatureInspection", "buildErrorString"));
    }

    private static class SerialPersistentFieldsWithWrongSignatureVisitor
    extends BaseInspectionVisitor {
        private SerialPersistentFieldsWithWrongSignatureVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass containingClass;
            if (field == null) {
                SerialPersistentFieldsWithWrongSignatureVisitor.$$$reportNull$$$0(0);
            }
            if ((containingClass = field.getContainingClass()) == null || containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            this.visitVariable((PsiVariable)field, containingClass);
        }

        public void visitRecordComponent(@NotNull PsiRecordComponent recordComponent) {
            if (recordComponent == null) {
                SerialPersistentFieldsWithWrongSignatureVisitor.$$$reportNull$$$0(1);
            }
            this.visitVariable((PsiVariable)recordComponent, recordComponent.getContainingClass());
        }

        private void visitVariable(@NotNull PsiVariable variable, @Nullable PsiClass containingClass) {
            if (variable == null) {
                SerialPersistentFieldsWithWrongSignatureVisitor.$$$reportNull$$$0(2);
            }
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            if (!"serialPersistentFields".equals(variable.getName())) {
                return;
            }
            boolean rightReturnType = variable.getType().equalsToText("java.io.ObjectStreamField[]");
            if (rightReturnType && variable.hasModifierProperty("static") && variable.hasModifierProperty("private") && variable.hasModifierProperty("final")) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/SerialPersistentFieldsWithWrongSignatureInspection$SerialPersistentFieldsWithWrongSignatureVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRecordComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

