/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SerialVersionUIDNotStaticFinalInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SerialVersionUIDWithWrongSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.problem.descriptor", new Object[0]);
        if (string == null) {
            SerialVersionUIDNotStaticFinalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        boolean needToFix = (Boolean)infos[0];
        return needToFix ? new SerialVersionUIDNotStaticFinalFix() : null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerialVersionUIDNotStaticFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection", "buildErrorString"));
    }

    private static class SerialVersionUIDNotStaticFinalFix
    extends PsiUpdateModCommandQuickFix {
        private SerialVersionUIDNotStaticFinalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.quickfix", new Object[0]);
            if (string == null) {
                SerialVersionUIDNotStaticFinalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                SerialVersionUIDNotStaticFinalFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SerialVersionUIDNotStaticFinalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SerialVersionUIDNotStaticFinalFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)parent;
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("private", true);
            modifierList.setModifierProperty("static", true);
            modifierList.setModifierProperty("final", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SerialVersionUIDNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private SerialVersionUIDNotStaticFinalVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass containingClass;
            if (field == null) {
                SerialVersionUIDNotStaticFinalVisitor.$$$reportNull$$$0(0);
            }
            if ((containingClass = field.getContainingClass()) == null || containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            this.visitVariable((PsiVariable)field, containingClass);
        }

        public void visitRecordComponent(@NotNull PsiRecordComponent recordComponent) {
            if (recordComponent == null) {
                SerialVersionUIDNotStaticFinalVisitor.$$$reportNull$$$0(1);
            }
            this.visitVariable((PsiVariable)recordComponent, recordComponent.getContainingClass());
        }

        private void visitVariable(@NotNull PsiVariable field, @Nullable PsiClass containingClass) {
            if (field == null) {
                SerialVersionUIDNotStaticFinalVisitor.$$$reportNull$$$0(2);
            }
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            if (!"serialVersionUID".equals(field.getName())) {
                return;
            }
            boolean rightReturnType = PsiTypes.longType().equals((Object)field.getType());
            boolean isStaticField = field.hasModifierProperty("static");
            if (rightReturnType && isStaticField && field.hasModifierProperty("private") && field.hasModifierProperty("final")) {
                return;
            }
            PsiIdentifier identifier = field.getNameIdentifier();
            assert (identifier != null);
            this.registerError((PsiElement)identifier, rightReturnType && (!containingClass.isRecord() || isStaticField));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordComponent";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRecordComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

