/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class SerializableStoresNonSerializableInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiElement classOrLambda = (PsiElement)infos[0];
        PsiType type = (PsiType)infos[1];
        if (classOrLambda instanceof PsiClass) {
            PsiClass aClass = (PsiClass)classOrLambda;
            if (aClass instanceof PsiAnonymousClass) {
                String string = InspectionGadgetsBundle.message("serializable.anonymous.class.stores.non.serializable.problem.descriptor", type.getPresentableText());
                if (string == null) {
                    SerializableStoresNonSerializableInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("serializable.local.class.stores.non.serializable.problem.descriptor", type.getPresentableText(), aClass.getName());
            if (string == null) {
                SerializableStoresNonSerializableInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.lambda.stores.non.serializable.problem.descriptor", type.getPresentableText());
        if (string == null) {
            SerializableStoresNonSerializableInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableStoresNonSerializableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection", "buildErrorString"));
    }

    private static class SerializableStoresNonSerializableVisitor
    extends BaseInspectionVisitor {
        private SerializableStoresNonSerializableVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SerializableStoresNonSerializableVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiDeclarationStatement) && !(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            LocalVariableReferenceFinder visitor2 = new LocalVariableReferenceFinder((PsiElement)aClass);
            for (PsiElement child = aClass.getLBrace(); child != null; child = child.getNextSibling()) {
                child.accept((PsiElementVisitor)visitor2);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
            if (lambda == null) {
                SerializableStoresNonSerializableVisitor.$$$reportNull$$$0(1);
            }
            super.visitLambdaExpression(lambda);
            PsiType type = lambda.getFunctionalInterfaceType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            lambda.accept((PsiElementVisitor)new LocalVariableReferenceFinder((PsiElement)lambda));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection$SerializableStoresNonSerializableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class LocalVariableReferenceFinder
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final PsiElement myClassOrLambda;

            LocalVariableReferenceFinder(PsiElement classOrLambda) {
                if (classOrLambda == null) {
                    LocalVariableReferenceFinder.$$$reportNull$$$0(0);
                }
                this.myClassOrLambda = classOrLambda;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    LocalVariableReferenceFinder.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiType type = expression.getType();
                if (SerializationUtils.isProbablySerializable(type)) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!(variable.hasModifierProperty("final") || PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)variable) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)this.myClassOrLambda))) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)this.myClassOrLambda, (PsiElement)variable, (boolean)true)) {
                    return;
                }
                SerializableStoresNonSerializableVisitor.this.registerError((PsiElement)expression, new Object[]{this.myClassOrLambda, type});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classOrLambda";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection$SerializableStoresNonSerializableVisitor$LocalVariableReferenceFinder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

