/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class TransientFieldNotInitializedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            TransientFieldNotInitializedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection", "buildErrorString"));
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                ReadObjectInitializationVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasModifierProperty("static") || !field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null && !InitializationUtils.isInitializedInInitializer(field, containingClass) && !InitializationUtils.isInitializedInConstructors(field, containingClass)) {
                return;
            }
            if (SerializationUtils.hasReadObject(containingClass)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor", "visitField"));
        }
    }
}

