/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantExpressionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_RESULT_LENGTH_TO_DISPLAY = 40;
    private static final int MAX_EXPRESSION_LENGTH = 200;
    public boolean skipIfContainsReferenceExpression = false;
    public boolean reportOnlyCompileTimeConstants = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"skipIfContainsReferenceExpression", (String)InspectionGadgetsBundle.message("inspection.constant.expression.skip.non.literal", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(InspectionGadgetsBundle.message("inspection.constant.expression.skip.non.literal.description", new Object[0])), OptPane.checkbox((String)"reportOnlyCompileTimeConstants", (String)InspectionGadgetsBundle.message("inspection.constant.expression.report.compile.time", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(InspectionGadgetsBundle.message("inspection.constant.expression.report.compile.time.description", new Object[0]))});
        if (optPane == null) {
            ConstantExpressionInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ConstantExpressionInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.handle((PsiExpression)expression);
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.handle(expression);
            }

            private void handle(@NotNull PsiExpression expression) {
                String message;
                String valueText;
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (expression instanceof PsiLiteralExpression || expression instanceof PsiParenthesizedExpression || expression instanceof PsiTypeCastExpression) {
                    return;
                }
                Object value = this.computeConstant(expression);
                if (value == null) {
                    return;
                }
                if (value instanceof PsiField && !(value instanceof PsiEnumConstant)) {
                    return;
                }
                if (value instanceof PsiElement) {
                    PsiReferenceExpression ref;
                    PsiElement e = (PsiElement)value;
                    if (expression instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)expression).isReferenceTo(e)) {
                        return;
                    }
                }
                if ((valueText = ConstantExpressionInspection.getValueText(value)) == null || expression.textMatches((CharSequence)valueText)) {
                    return;
                }
                String string = message = valueText.length() > 40 ? InspectionGadgetsBundle.message("inspection.constant.expression.display.name", new Object[0]) : InspectionGadgetsBundle.message("inspection.constant.expression.message", valueText);
                if (ConstantExpressionInspection.this.skipIfContainsReferenceExpression && 1.hasReferences(expression)) {
                    if (isOnTheFly) {
                        holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ComputeConstantValueFix(expression, valueText)});
                    }
                } else {
                    holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[]{new ComputeConstantValueFix(expression, valueText)});
                }
            }

            @Nullable
            private Object computeConstant(PsiExpression expression) {
                if (expression.getTextLength() > 200 || expression.getType() == null) {
                    return null;
                }
                Object value = this.computeValue(expression);
                if (value == null) {
                    return null;
                }
                PsiExpression parent = 1.getParentExpression(expression);
                return parent != null && this.computeValue(parent) != null ? null : value;
            }

            private Object computeValue(PsiExpression expression) {
                if (expression instanceof PsiClassObjectAccessExpression) {
                    return null;
                }
                try {
                    Object value = ExpressionUtils.computeConstantExpression(expression, true);
                    if (value != null) {
                        return value;
                    }
                }
                catch (ConstantEvaluationOverflowException ignore) {
                    return null;
                }
                if (ConstantExpressionInspection.this.reportOnlyCompileTimeConstants) {
                    return null;
                }
                if (SideEffectChecker.mayHaveSideEffects(expression)) {
                    return null;
                }
                return CommonDataflow.computeValue(expression);
            }

            @Nullable
            private static PsiExpression getParentExpression(PsiExpression expression) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
                if (parent instanceof PsiExpressionList || parent instanceof PsiTemplate) {
                    parent = parent.getParent();
                }
                return (PsiExpression)ObjectUtils.tryCast((Object)parent, PsiExpression.class);
            }

            private static boolean hasReferences(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                return expression instanceof PsiReferenceExpression || PsiTreeUtil.getChildOfType((PsiElement)expression, PsiReferenceExpression.class) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/siyeh/ig/style/ConstantExpressionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handle";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasReferences";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static String getValueText(Object value) {
        Object newExpression;
        if (value instanceof String) {
            String string = (String)value;
            newExpression = "\"" + StringUtil.escapeStringCharacters((String)string) + "\"";
        } else if (value instanceof Character) {
            newExpression = "'" + StringUtil.escapeCharCharacters((String)value.toString()) + "'";
        } else if (value instanceof Long) {
            newExpression = value.toString() + "L";
        } else if (value instanceof Double) {
            Double d = (Double)value;
            double v = d;
            newExpression = Double.isNaN(v) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v));
        } else if (value instanceof Float) {
            Float f = (Float)value;
            float v = f.floatValue();
            newExpression = Float.isNaN(v) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + "f");
        } else if (value == null) {
            newExpression = "null";
        } else {
            if (value instanceof PsiField) {
                PsiField field = (PsiField)value;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return null;
                }
                return containingClass.getQualifiedName() + "." + field.getName();
            }
            if (value instanceof PsiType) {
                if (value instanceof PsiClassType) {
                    PsiClassType clsType = (PsiClassType)value;
                    return clsType.getCanonicalText() + ".class";
                }
                return null;
            }
            newExpression = String.valueOf(value);
        }
        return newExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ConstantExpressionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ConstantExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ComputeConstantValueFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;
        private final String myValueText;

        ComputeConstantValueFix(PsiExpression expression, String valueText) {
            this.myText = PsiExpressionTrimRenderer.render((PsiExpression)expression);
            this.myValueText = valueText;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myText.length() < 40) {
                String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.name", this.myText);
                if (string == null) {
                    ComputeConstantValueFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.name.short", new Object[0]);
            if (string == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.family.name", new Object[0]);
            if (string == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(5);
            }
            PsiExpression expression = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression, this.myValueText, new CommentTracker());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ConstantExpressionInspection$ComputeConstantValueFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ConstantExpressionInspection$ComputeConstantValueFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

