/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", infos);
        if (string == null) {
            ControlFlowStatementWithoutBracesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ControlFlowStatementFix((String)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection", "buildErrorString"));
    }

    private static class ControlFlowStatementFix
    extends PsiUpdateModCommandQuickFix {
        private final String myKeywordText;

        ControlFlowStatementFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.message", this.myKeywordText);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiStatement statementWithoutBraces;
            PsiStatement statement;
            if (project == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(4);
            }
            if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false)) instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                statementWithoutBraces = this.myKeywordText.equals("else") ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)statementWithoutBraces);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ControlFlowStatementVisitor
    extends ControlFlowStatementVisitorBase {
        private ControlFlowStatementVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body) {
            PsiIfStatement ifStatement;
            PsiElement psiElement;
            if (body instanceof PsiIfStatement && this.isVisibleHighlight((PsiElement)body) && (psiElement = body.getParent()) instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)psiElement).getElseBranch() == body) {
                return false;
            }
            return body != null && !(body instanceof PsiBlockStatement);
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body) {
            if ((body instanceof PsiLoopStatement || body instanceof PsiIfStatement) && body.textContains('\n')) {
                return new Pair((Object)body, (Object)body);
            }
            return null;
        }
    }
}

