/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ObjectsEqualsCanBeSimplifiedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OBJECTS_EQUALS = CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2);

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.OBJECTS_CLASS);
        if (set == null) {
            ObjectsEqualsCanBeSimplifiedInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ObjectsEqualsCanBeSimplifiedInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!OBJECTS_EQUALS.test(call)) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression arg1 = args[0];
                PsiExpression arg2 = args[1];
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                if (this.processPrimitives(nameElement, arg1, arg2)) {
                    return;
                }
                PsiClass argClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)arg1.getType());
                if (argClass == null) {
                    return;
                }
                if (NullabilityUtil.getExpressionNullability(arg1, true) == Nullability.NOT_NULL) {
                    PsiMethod[] equalsMethods;
                    for (PsiMethod method : equalsMethods = argClass.findMethodsByName("equals", true)) {
                        if (method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || TypeUtils.isJavaLangObject(Objects.requireNonNull(method.getParameterList().getParameter(0)).getType())) continue;
                        return;
                    }
                    @NlsSafe String message = JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"equals()"});
                    holder.registerProblem(nameElement, message, new LocalQuickFix[]{new ReplaceWithEqualsFix(false)});
                }
            }

            private boolean processPrimitives(PsiElement nameElement, PsiExpression arg1, PsiExpression arg2) {
                PsiType type1 = arg1.getType();
                PsiType type2 = arg2.getType();
                if (type1 instanceof PsiPrimitiveType && type1.equals(type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type1)) {
                    holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"=="}), new LocalQuickFix[]{new ReplaceWithEqualsFix(true)});
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ReplaceWithEqualsFix
    extends PsiUpdateModCommandQuickFix {
        final boolean myEquality;

        private ReplaceWithEqualsFix(boolean equality) {
            this.myEquality = equality;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"Objects.equals()", this.myEquality ? "==" : "equals()"});
            if (string == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = this.myEquality ? ct.text(args[0], 9) + "==" + ct.text(args[1], 9) : ct.text(args[0], 1) + ".equals(" + ct.text((PsiElement)args[1]) + ")";
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection$ReplaceWithEqualsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection$ReplaceWithEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

