/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class RedundantImplementsInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSerializable = false;
    public boolean ignoreCloneable = false;

    @NotNull
    public String getID() {
        return "RedundantInterfaceDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.implements.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantImplementsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSerializable", (String)InspectionGadgetsBundle.message("ignore.serializable.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreCloneable", (String)InspectionGadgetsBundle.message("ignore.cloneable.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantImplementsInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new RedundantImplementsFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantImplementsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/RedundantImplementsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantImplementsFix
    extends PsiUpdateModCommandQuickFix {
        private RedundantImplementsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.implements.remove.quickfix", new Object[0]);
            if (string == null) {
                RedundantImplementsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RedundantImplementsFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RedundantImplementsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RedundantImplementsFix.$$$reportNull$$$0(3);
            }
            startElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class RedundantImplementsVisitor
    extends BaseInspectionVisitor {
        private RedundantImplementsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                RedundantImplementsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isAnnotationType()) {
                return;
            }
            if (aClass.isInterface()) {
                this.checkInterface(aClass);
            } else {
                this.checkConcreteClass(aClass);
            }
        }

        private void checkInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement extendsElement : extendsElements = extendsList.getReferenceElements()) {
                this.checkExtendedInterface(extendsElement, extendsElements);
            }
        }

        private void checkConcreteClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsElements;
            PsiJavaCodeReferenceElement extendsElement;
            PsiReferenceList extendsList = aClass.getExtendsList();
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (extendsList == null || implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsElements = extendsList.getReferenceElements();
            if (extendsElements.length != 1) {
                if (aClass.isEnum()) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    extendsElement = factory.createReferenceElementByFQClassName("java.lang.Enum", aClass.getResolveScope());
                } else {
                    extendsElement = null;
                }
            } else {
                extendsElement = extendsElements[0];
            }
            for (PsiJavaCodeReferenceElement implementsElement : implementsElements = implementsList.getReferenceElements()) {
                this.checkImplementedClass(implementsElement, extendsElement, implementsElements);
            }
        }

        private void checkImplementedClass(PsiJavaCodeReferenceElement implementsElement, PsiJavaCodeReferenceElement extendsElement, PsiJavaCodeReferenceElement[] implementsElements) {
            PsiElement target = implementsElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass implementedClass = (PsiClass)target;
            if (!implementedClass.isInterface()) {
                return;
            }
            String qualifiedName = implementedClass.getQualifiedName();
            if (RedundantImplementsInspection.this.ignoreSerializable && "java.io.Serializable".equals(qualifiedName)) {
                return;
            }
            if (RedundantImplementsInspection.this.ignoreCloneable && "java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            if (extendsElement != null) {
                PsiElement extendsReferent = extendsElement.resolve();
                if (!(extendsReferent instanceof PsiClass)) {
                    return;
                }
                PsiClass extendedClass = (PsiClass)extendsReferent;
                if (extendedClass.isInheritor(implementedClass, true)) {
                    this.registerError((PsiElement)implementsElement, new Object[0]);
                    return;
                }
            }
            this.check(implementsElement, implementedClass, implementsElements);
        }

        private void checkExtendedInterface(PsiJavaCodeReferenceElement extendsElement, PsiJavaCodeReferenceElement[] extendsElements) {
            PsiClass extendedInterface;
            PsiElement target = extendsElement.resolve();
            if (!(target instanceof PsiClass) || !(extendedInterface = (PsiClass)target).isInterface()) {
                return;
            }
            this.check(extendsElement, extendedInterface, extendsElements);
        }

        private void check(PsiJavaCodeReferenceElement implementsElement, PsiClass implementedClass, PsiJavaCodeReferenceElement[] implementsElements) {
            for (PsiJavaCodeReferenceElement testImplementElement : implementsElements) {
                PsiClass testImplementedClass;
                PsiElement psiElement;
                if (testImplementElement.equals((Object)implementsElement) || !((psiElement = testImplementElement.resolve()) instanceof PsiClass) || !(testImplementedClass = (PsiClass)psiElement).isInheritor(implementedClass, true)) continue;
                this.registerError((PsiElement)implementsElement, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/style/RedundantImplementsInspection$RedundantImplementsVisitor", "visitClass"));
        }
    }
}

