/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.IfConditionalModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SimplifiableIfStatementInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean DONT_WARN_ON_TERNARY = true;
    public boolean DONT_WARN_ON_CHAINED_ID = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DONT_WARN_ON_TERNARY", (String)InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.option.dont.warn.on.ternary", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_WARN_ON_CHAINED_ID", (String)InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
                boolean infoLevel;
                IfConditionalModel model;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((model = IfConditionalModel.from(ifStatement, false)) == null) {
                    return;
                }
                ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
                if (generator == null) {
                    return;
                }
                String operator = generator.getTokenType();
                if (operator.isEmpty()) {
                    return;
                }
                boolean bl = infoLevel = operator.equals("?:") && (SimplifiableIfStatementInspection.this.DONT_WARN_ON_TERNARY || model.getThenExpression() instanceof PsiConditionalExpression || model.getElseExpression() instanceof PsiConditionalExpression) || SimplifiableIfStatementInspection.this.DONT_WARN_ON_CHAINED_ID && ControlFlowUtils.isElseIf(ifStatement);
                if (!isOnTheFly && infoLevel) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.message", operator), infoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new SimplifiableIfStatementFix(operator)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/style/SimplifiableIfStatementInspection$1", "visitIfStatement"));
            }
        };
    }

    public static void tryJoinDeclaration(PsiElement result) {
        if (!(result instanceof PsiExpressionStatement)) {
            return;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)result).getExpression(), PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return;
        }
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)result), PsiDeclarationStatement.class);
        if (declaration == null) {
            return;
        }
        PsiElement[] elements = declaration.getDeclaredElements();
        if (elements.length != 1) {
            return;
        }
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
        if (var == null || !ref.isReferenceTo((PsiElement)var)) {
            return;
        }
        PsiExpression rhs = assignment.getRExpression();
        assert (rhs != null);
        boolean readBeforeWritten = SyntaxTraverser.psiTraverser((PsiElement)rhs).filter(PsiReferenceExpression.class).filter(r -> r.isReferenceTo((PsiElement)var) && PsiUtil.isAccessedForReading((PsiExpression)r)).isNotEmpty();
        if (readBeforeWritten) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        var.setInitializer(ct.markUnchanged(rhs));
        ct.deleteAndRestoreComments(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class SimplifiableIfStatementFix
    extends PsiUpdateModCommandQuickFix {
        private final String myOperator;

        SimplifiableIfStatementFix(String operator) {
            this.myOperator = operator;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.name", this.myOperator);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.family.name", new Object[0]);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiIfStatement ifStatement;
            if (project == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(4);
            }
            if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) == null) {
                return;
            }
            IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
            if (model == null) {
                return;
            }
            ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
            if (generator == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String conditional = generator.generate(commentTracker);
            commentTracker.replace((PsiElement)model.getThenExpression(), conditional);
            PsiStatement branch = model.getElseBranch();
            if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)branch, (boolean)true) && !(branch instanceof PsiDeclarationStatement)) {
                commentTracker.delete((PsiElement)branch);
            }
            PsiElement result = commentTracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)model.getThenBranch());
            SimplifiableIfStatementInspection.tryJoinDeclaration(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

