/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnclearBinaryExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "UnclearExpression";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnclearBinaryExpressionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnclearBinaryExpressionVisitor();
    }

    public static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression || element instanceof PsiParenthesizedExpression;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnclearExpression(PsiExpression expression, PsiElement parent) {
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression nestedAssignment;
            IElementType nestedTokenType;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (parent instanceof PsiVariable ? !tokenType.equals(JavaTokenType.EQ) : parent instanceof PsiAssignmentExpression && !tokenType.equals(nestedTokenType = (nestedAssignment = (PsiAssignmentExpression)parent).getOperationTokenType())) {
                return true;
            }
            return UnclearBinaryExpressionInspection.isUnclearExpression(assignmentExpression.getRExpression(), (PsiElement)assignmentExpression);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return false;
            }
            return parent instanceof PsiConditionalExpression || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getCondition(), (PsiElement)conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getThenExpression(), (PsiElement)conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getElseExpression(), (PsiElement)conditionalExpression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            if (parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression) {
                return true;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                PsiType type = operand.getType();
                if (type == null || type.equalsToText("java.lang.String")) {
                    return false;
                }
                if (!UnclearBinaryExpressionInspection.isUnclearExpression(operand, (PsiElement)polyadicExpression)) continue;
                return true;
            }
        } else {
            if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                if (parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression) {
                    return true;
                }
                return UnclearBinaryExpressionInspection.isUnclearExpression(instanceOfExpression.getOperand(), (PsiElement)instanceOfExpression);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression nestedExpression = parenthesizedExpression.getExpression();
                return UnclearBinaryExpressionInspection.isUnclearExpression(nestedExpression, (PsiElement)parenthesizedExpression);
            }
        }
        return false;
    }

    public static void replaceElement(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression = (PsiExpression)element;
        String newExpressionText = UnclearBinaryExpressionInspection.createReplacementText(expression, new StringBuilder()).toString();
        PsiReplacementUtil.replaceExpression(expression, newExpressionText);
    }

    private static StringBuilder createReplacementText(@Nullable PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiPolyadicExpression;
            UnclearBinaryExpressionInspection.appendText((PsiExpression)polyadicExpression, parentheses, out);
        } else if (expression instanceof PsiParenthesizedExpression) {
            for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiExpression) {
                    PsiExpression unwrappedExpression = (PsiExpression)child;
                    UnclearBinaryExpressionInspection.createReplacementText(unwrappedExpression, out);
                    continue;
                }
                out.append(child.getText());
            }
        } else if (expression instanceof PsiInstanceOfExpression) {
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiPolyadicExpression || parent instanceof PsiConditionalExpression;
            UnclearBinaryExpressionInspection.appendText(expression, parentheses, out);
        } else if (expression instanceof PsiConditionalExpression) {
            PsiElement parent = expression.getParent();
            boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiInstanceOfExpression;
            UnclearBinaryExpressionInspection.appendText(expression, parentheses, out);
        } else if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = !UnclearBinaryExpressionInspection.isSimpleAssignment(assignmentExpression, parent);
            UnclearBinaryExpressionInspection.appendText((PsiExpression)assignmentExpression, parentheses, out);
        } else if (expression != null) {
            out.append(expression.getText());
        }
        return out;
    }

    private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent) {
        IElementType parentTokenType;
        if (parent instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent;
            parentTokenType = parentAssignmentExpression.getOperationTokenType();
        } else if (parent instanceof PsiVariable) {
            parentTokenType = JavaTokenType.EQ;
        } else {
            return false;
        }
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return parentTokenType.equals(tokenType);
    }

    private static void appendText(PsiExpression expression, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiExpression) {
                UnclearBinaryExpressionInspection.createReplacementText((PsiExpression)child, out);
                continue;
            }
            out.append(child.getText());
        }
        if (parentheses) {
            out.append(')');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection", "buildErrorString"));
    }

    private static class UnclearBinaryExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private UnclearBinaryExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unclear.binary.expression.quickfix", new Object[0]);
            if (string == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(3);
            }
            UnclearBinaryExpressionInspection.replaceElement(startElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnclearBinaryExpressionVisitor
    extends BaseInspectionVisitor {
        private UnclearBinaryExpressionVisitor() {
        }

        public void visitExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                UnclearBinaryExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitExpression(expression);
            PsiElement parent = expression.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent) || !UnclearBinaryExpressionInspection.isUnclearExpression(expression, parent)) {
                return;
            }
            if (ErrorUtil.containsDeepError((PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionVisitor", "visitExpression"));
        }
    }
}

