/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiThisExpression ? "unnecessary.qualifier.for.this.problem.descriptor" : "unnecessary.qualifier.for.super.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryQualifierForThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection", "buildErrorString"));
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                UnnecessaryQualifierForThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)thisExpression);
            if (containingClass == null || !containingClass.equals((Object)referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, thisExpression);
        }

        public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
            if (expression == null) {
                UnnecessaryQualifierForThisVisitor.$$$reportNull$$$0(1);
            }
            super.visitSuperExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement resolve = qualifier.resolve();
            if (!(resolve instanceof PsiClass)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiElement gParent = parent.getParent();
                PsiReferenceExpression copy = gParent instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)gParent.copy()).getMethodExpression() : (PsiReferenceExpression)parent.copy();
                PsiExpression copyQualifierExpression = copy.getQualifierExpression();
                assert (copyQualifierExpression != null);
                PsiReplacementUtil.replaceExpression(copyQualifierExpression, "super");
                if (copy.resolve() == ((PsiReferenceExpression)parent).resolve()) {
                    this.registerError((PsiElement)qualifier, expression);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement qualifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(1);
            }
            if (qualifier == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = qualifier.getParent();
            CommentTracker tracker = new CommentTracker();
            if (parent instanceof PsiThisExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiThisExpression)parent), "this", tracker);
            } else if (parent instanceof PsiSuperExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiSuperExpression)parent), "super", tracker);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

