/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.LanguageUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class UnnecessarySemicolonInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreAfterEnumConstants = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAfterEnumConstants", (String)InspectionGadgetsBundle.message("unnecessary.semicolon.ignore.after.enum.constants.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.semicolon.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySemicolonVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarySemicolonFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(2);
        }
        return !LanguageUtil.isInTemplateLanguageFile((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessarySemicolonInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessarySemicolonInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class UnnecessarySemicolonVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySemicolonVisitor() {
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(0);
            }
            this.checkTopLevelSemicolons((PsiElement)psiFile);
            super.visitFile(psiFile);
        }

        public void visitImportList(@NotNull PsiImportList list) {
            if (list == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(1);
            }
            this.checkTopLevelSemicolons((PsiElement)list);
            super.visitImportList(list);
        }

        public void visitModule(@NotNull PsiJavaModule module) {
            if (module == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(2);
            }
            this.checkTopLevelSemicolons((PsiElement)module);
            super.visitModule(module);
        }

        private void checkTopLevelSemicolons(PsiElement element) {
            PsiElement sibling = element.getFirstChild();
            while (sibling != null) {
                if (sibling instanceof PsiErrorElement) {
                    return;
                }
                if (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.SEMICOLON) && !PsiUtil.isFollowedByImport((PsiElement)sibling)) {
                    this.registerError(sibling, new Object[0]);
                }
                sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(3);
            }
            super.visitClass(aClass);
            if (!aClass.isEnum()) {
                this.checkTopLevelSemicolons((PsiElement)aClass);
            } else {
                boolean semicolonSeen = false;
                PsiElement sibling = aClass.getFirstChild();
                while (sibling != null) {
                    if (sibling instanceof PsiErrorElement) {
                        return;
                    }
                    if (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.SEMICOLON)) {
                        PsiElement element;
                        if (semicolonSeen) {
                            this.registerError(sibling, new Object[0]);
                        } else if (!UnnecessarySemicolonInspection.this.ignoreAfterEnumConstants && PsiUtil.isJavaToken((PsiElement)(element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling)), (IElementType)JavaTokenType.RBRACE)) {
                            this.registerError(sibling, new Object[0]);
                        }
                        semicolonSeen = true;
                    }
                    sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling);
                }
            }
        }

        public void visitEmptyStatement(@NotNull PsiEmptyStatement statement) {
            if (statement == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(4);
            }
            super.visitEmptyStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement semicolon = statement.getFirstChild();
                if (semicolon == null) {
                    return;
                }
                this.registerError(semicolon, new Object[0]);
            }
        }

        public void visitResourceList(@NotNull PsiResourceList resourceList) {
            PsiElement prev;
            if (resourceList == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(5);
            }
            super.visitResourceList(resourceList);
            PsiElement last = resourceList.getLastChild();
            if (PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RPARENTH) && PsiUtil.isJavaToken((PsiElement)(prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)last)), (IElementType)JavaTokenType.SEMICOLON)) {
                this.registerError(prev, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceList";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitImportList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEmptyStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitResourceList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnnecessarySemicolonFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.semicolon.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement semicolonElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(1);
            }
            if (semicolonElement == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(3);
            }
            if (semicolonElement instanceof PsiFile) {
                return;
            }
            PsiElement parent = semicolonElement.getParent();
            if (parent instanceof PsiEmptyStatement) {
                PsiElement lastChild = parent.getLastChild();
                if (lastChild instanceof PsiComment) {
                    parent.replace(lastChild);
                } else {
                    parent.delete();
                }
            } else {
                semicolonElement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semicolonElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

