/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class UnnecessarySuperConstructorInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "UnnecessaryCallToSuper";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySuperConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarySuperConstructorFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperConstructorInspection", "buildErrorString"));
    }

    private static class UnnecessarySuperConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessarySuperConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySuperConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement superCall, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessarySuperConstructorFix.$$$reportNull$$$0(1);
            }
            if (superCall == null) {
                UnnecessarySuperConstructorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarySuperConstructorFix.$$$reportNull$$$0(3);
            }
            PsiElement callStatement = superCall.getParent();
            assert (callStatement != null);
            callStatement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superCall";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessarySuperConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySuperConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiMethod method;
            PsiCodeBlock block;
            PsiExpressionStatement statement;
            PsiElement psiElement;
            if (call == null) {
                UnnecessarySuperConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            if (!(!methodExpression.isQualified() && "super".equals(methodExpression.getReferenceName()) && call.getArgumentList().isEmpty() && (psiElement = call.getParent()) instanceof PsiExpressionStatement && (psiElement = (statement = (PsiExpressionStatement)psiElement).getParent()) instanceof PsiCodeBlock && (psiElement = (block = (PsiCodeBlock)psiElement).getParent()) instanceof PsiMethod && (method = (PsiMethod)psiElement).isConstructor() && PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class) == null)) {
                return;
            }
            this.registerError((PsiElement)call, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorVisitor", "visitMethodCallExpression"));
        }
    }
}

