/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryToStringCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean notNullQualifierOnly = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"notNullQualifierOnly", (String)JavaAnalysisBundle.message((String)"inspection.redundant.tostring.option.notnull.qualifier", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryToStringCallInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryToStringCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        String text = (String)infos[0];
        return new UnnecessaryToStringCallFix(text);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryToStringCallVisitor();
    }

    @Contract(value="null -> false")
    private static boolean isRedundantToString(PsiMethodCallExpression call) {
        if (call == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        @NonNls String referenceName = methodExpression.getReferenceName();
        if (!"toString".equals(referenceName) || !call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
        if (qualifier == null) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type instanceof PsiArrayType) {
            return false;
        }
        if (qualifier instanceof PsiSuperExpression) {
            return false;
        }
        boolean throwable = TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Throwable");
        return !ExpressionUtils.isConversionToStringNecessary((PsiExpression)call, throwable, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class UnnecessaryToStringCallFix
    extends PsiUpdateModCommandQuickFix {
        @Nullable
        private final String replacementText;

        private UnnecessaryToStringCallFix(@Nullable String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            if (this.replacementText == null) {
                String string = InspectionGadgetsBundle.message("inspection.remove.redundant.call.fix.name", "toString");
                if (string == null) {
                    UnnecessaryToStringCallFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText});
            if (string == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(5);
            }
            if (!UnnecessaryToStringCallInspection.isRedundantToString(call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)startElement.getParent().getParent(), PsiMethodCallExpression.class))) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
            if (qualifier == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection$UnnecessaryToStringCallFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection$UnnecessaryToStringCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessaryToStringCallVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryToStringCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                UnnecessaryToStringCallVisitor.$$$reportNull$$$0(0);
            }
            if (!UnnecessaryToStringCallInspection.isRedundantToString(call)) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
            if (qualifier == null) {
                return;
            }
            if (UnnecessaryToStringCallInspection.this.notNullQualifierOnly && PsiTreeUtil.isAncestor((PsiElement)methodExpression, (PsiElement)qualifier, (boolean)true) && NullabilityUtil.getExpressionNullability(qualifier, true) != Nullability.NOT_NULL) {
                return;
            }
            this.registerError(referenceNameElement, qualifier.isPhysical() ? null : qualifier.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/style/UnnecessaryToStringCallInspection$UnnecessaryToStringCallVisitor", "visitMethodCallExpression"));
        }
    }
}

