/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor", new Object[0]);
            if (string == null) {
                UnqualifiedStaticUsageInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor1", new Object[0]);
        if (string == null) {
            UnqualifiedStaticUsageInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreStaticFieldAccesses", (String)InspectionGadgetsBundle.message("unqualified.static.usage.ignore.field.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreStaticMethodCalls", (String)InspectionGadgetsBundle.message("unqualified.static.usage.ignore.method.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreStaticAccessFromStaticContext", (String)InspectionGadgetsBundle.message("unqualified,static.usage.only.report.static.usages.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnqualifiedStaticUsageInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedStaticCallVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            return new UnqualifiedStaticAccessFix(false);
        }
        return new UnqualifiedStaticAccessFix(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnqualifiedStaticUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnqualifiedStaticCallVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedStaticCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                UnqualifiedStaticCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (!this.isUnqualifiedStaticAccess(methodExpression)) {
                return;
            }
            this.registerError((PsiElement)methodExpression, expression);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UnqualifiedStaticCallVisitor.$$$reportNull$$$0(1);
            }
            super.visitReferenceExpression(expression);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("final") && PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                return;
            }
            if (!this.isUnqualifiedStaticAccess(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean isUnqualifiedStaticAccess(PsiReferenceExpression expression) {
            PsiElement parent;
            PsiMember member;
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class)) != null && member.hasModifierProperty("static")) {
                return false;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (qualifierExpression != null) {
                return false;
            }
            JavaResolveResult resolveResult = expression.advancedResolve(false);
            PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
            if (currentFileResolveScope instanceof PsiImportStaticStatement) {
                return false;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiField) && !(element instanceof PsiMethod)) {
                return false;
            }
            PsiMember member2 = (PsiMember)element;
            if (member2 instanceof PsiEnumConstant && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiCaseLabelElementList && parent.getParent() instanceof PsiSwitchLabelStatementBase) {
                return false;
            }
            return member2.hasModifierProperty("static");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnqualifiedStaticAccessFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean m_fixField;

        UnqualifiedStaticAccessFix(boolean fixField) {
            this.m_fixField = fixField;
        }

        @NotNull
        public String getName() {
            if (this.m_fixField) {
                String string = InspectionGadgetsBundle.message("unqualified.static.usage.qualify.field.quickfix", new Object[0]);
                if (string == null) {
                    UnqualifiedStaticAccessFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("unqualified.static.usage.qualify.method.quickfix", new Object[0]);
            if (string == null) {
                UnqualifiedStaticAccessFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unqualified.static.access.fix.family.name", new Object[0]);
            if (string == null) {
                UnqualifiedStaticAccessFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnqualifiedStaticAccessFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                UnqualifiedStaticAccessFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                UnqualifiedStaticAccessFix.$$$reportNull$$$0(5);
            }
            PsiReferenceExpression expression = (PsiReferenceExpression)startElement;
            PsiMember member = (PsiMember)expression.resolve();
            assert (member != null);
            PsiClass containingClass = member.getContainingClass();
            assert (containingClass != null);
            String className = containingClass.getName();
            CommentTracker commentTracker = new CommentTracker();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, className + "." + commentTracker.text((PsiElement)expression), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticAccessFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnqualifiedStaticUsageInspection$UnqualifiedStaticAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

