/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.testFrameworks.AbstractAssertHint;
import com.siyeh.ig.testFrameworks.AssertHint;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssertWithoutMessageInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssertionsWithoutMessagesVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assert.without.message.problem.descriptor", new Object[0]);
        if (string == null) {
            AssertWithoutMessageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new AssertWithoutMessageFix((Boolean)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/AssertWithoutMessageInspection", "buildErrorString"));
    }

    private static class AssertionsWithoutMessagesVisitor
    extends BaseInspectionVisitor {
        private AssertionsWithoutMessagesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                AssertionsWithoutMessagesVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            AssertHint assertHint = AssertHint.create(expression, (Function1<? super String, Integer>)((Function1)methodName -> AbstractAssertHint.ASSERT_METHOD_2_PARAMETER_COUNT.get(methodName)));
            if (assertHint == null) {
                return;
            }
            PsiExpression message = assertHint.getMessage();
            if (message == null) {
                this.registerMethodCallError(expression, assertHint.isMessageOnFirstPosition());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/AssertWithoutMessageInspection$AssertionsWithoutMessagesVisitor", "visitMethodCallExpression"));
        }
    }

    private static final class AssertWithoutMessageFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myMessageIsOnFirstPosition;

        private AssertWithoutMessageFix(boolean messageIsOnFirstPosition) {
            this.myMessageIsOnFirstPosition = messageIsOnFirstPosition;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement createdMessageExpr;
            PsiMethodCallExpression methodCallExpr;
            if (project == null) {
                AssertWithoutMessageFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                AssertWithoutMessageFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                AssertWithoutMessageFix.$$$reportNull$$$0(2);
            }
            if ((methodCallExpr = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression newMessageExpr = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText("\"\"", (PsiElement)methodCallExpr);
            PsiExpressionList methodArgs = methodCallExpr.getArgumentList();
            if (this.myMessageIsOnFirstPosition) {
                PsiExpression[] methodArgExprs = methodArgs.getExpressions();
                PsiExpression firstMethodArgExpr = methodArgExprs.length > 0 ? methodArgExprs[0] : null;
                createdMessageExpr = methodArgs.addBefore((PsiElement)newMessageExpr, (PsiElement)firstMethodArgExpr);
            } else {
                createdMessageExpr = methodArgs.add((PsiElement)newMessageExpr);
            }
            updater.moveCaretTo(createdMessageExpr.getTextRange().getStartOffset() + 1);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("assert.without.message.quick.fix.family.name", new Object[0]);
            if (string == null) {
                AssertWithoutMessageFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/testFrameworks/AssertWithoutMessageInspection$AssertWithoutMessageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/testFrameworks/AssertWithoutMessageInspection$AssertWithoutMessageFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

