/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SimplifiableAssertionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final CallMatcher ARRAYS_EQUALS = CallMatcher.staticCall("java.util.Arrays", "equals").parameterCount(2);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos[0]);
        if (string == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new SimplifyAssertFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    private static boolean isAssertThatCouldBeFail(PsiExpression position, boolean checkTrue) {
        return (checkTrue ? "true" : "false").equals(position.getText());
    }

    private static boolean isAssertEqualsThatCouldBeAssertLiteral(AssertHint assertHint) {
        PsiExpression secondTestArgument;
        PsiExpression firstTestArgument = assertHint.getFirstArgument();
        return SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = assertHint.getSecondArgument()) || SimplifiableAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    private static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression) || expression2 == null) {
            return false;
        }
        String text = expression1.getText();
        if ("null".equals(text)) {
            return true;
        }
        if (!"true".equals(text) && !"false".equals(text)) {
            return false;
        }
        PsiType type = expression2.getType();
        return PsiTypes.booleanType().equals((Object)type);
    }

    private static boolean isEqualityComparison(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type = lhs.getType();
            return type != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type);
        }
        return EqualityCheck.from(expression) != null;
    }

    private static boolean isArrayEqualityComparison(PsiExpression expression) {
        return expression instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)expression);
    }

    private static boolean isInstanceOfMethodExistsWithMatchingParams(@NotNull AssertHint assertHint) {
        String version;
        PsiClass clazz;
        if (assertHint == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(1);
        }
        if ((clazz = assertHint.getMethod().getContainingClass()) == null || !"org.junit.jupiter.api.Assertions".equals(clazz.getQualifiedName())) {
            return false;
        }
        Module junitModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)assertHint.getOriginalExpression());
        if (junitModule != null && (version = JavaLibraryUtil.getLibraryVersion((Module)junitModule, (String)"org.junit.jupiter:junit-jupiter-api")) != null) {
            return VersionComparatorUtil.compare((String)version, (String)"5.8") >= 0;
        }
        PsiMethod[] methods = clazz.findMethodsByName("assertInstanceOf", true);
        PsiParameterList originalParameters = assertHint.getMethod().getParameterList();
        for (PsiMethod method : methods) {
            PsiParameterList parameters = method.getParameterList();
            if (parameters.getParametersCount() - 1 != originalParameters.getParametersCount()) continue;
            if (originalParameters.getParametersCount() == 1) {
                return true;
            }
            PsiParameter[] originalParams = originalParameters.getParameters();
            PsiParameter[] params = parameters.getParameters();
            if (!IntStream.range(1, originalParams.length).allMatch(i -> Objects.equals(originalParams[i].getType(), params[i + 1].getType()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isInstanceOfComparison(@NotNull PsiExpression expression) {
        if (expression == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(2);
        }
        return expression instanceof PsiInstanceOfExpression;
    }

    private static boolean isIdentityComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        if (!ComparisonUtils.isEqualityComparison((PsiExpression)binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertHint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfMethodExistsWithMatchingParams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfComparison";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class SimplifyAssertFix
    extends PsiUpdateModCommandQuickFix {
        private SimplifyAssertFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifyAssertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameIdentifier, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                SimplifyAssertFix.$$$reportNull$$$0(1);
            }
            if (methodNameIdentifier == null) {
                SimplifyAssertFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SimplifyAssertFix.$$$reportNull$$$0(3);
            }
            if ((parent = methodNameIdentifier.getParent()) == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            AssertHint assertHint = AssertHint.createAssertEqualsHint(callExpression);
            if (assertHint != null && SimplifiableAssertionInspection.isAssertEqualsThatCouldBeAssertLiteral(assertHint)) {
                SimplifyAssertFix.replaceAssertEqualsWithAssertLiteral(assertHint);
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(callExpression);
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = assertTrueFalseHint.isAssertTrue();
                PsiExpression argument = assertTrueFalseHint.getFirstArgument();
                if (ComparisonUtils.isNullComparison(argument)) {
                    SimplifyAssertFix.replaceAssertWithAssertNull(assertTrueFalseHint);
                } else if (SimplifiableAssertionInspection.isIdentityComparison(argument)) {
                    SimplifyAssertFix.replaceWithAssertSame(assertTrueFalseHint);
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(argument)) {
                    SimplifyAssertFix.replaceWithAssertEquals(assertTrueFalseHint, "assertEquals");
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(argument, !assertTrue)) {
                    SimplifyAssertFix.replaceWithFail(assertTrueFalseHint);
                } else if (SimplifiableAssertionInspection.isEqualityComparison(argument)) {
                    SimplifyAssertFix.replaceWithAssertEquals(assertTrueFalseHint, "assertNotEquals");
                } else if (assertTrue && SimplifiableAssertionInspection.isArrayEqualityComparison(argument)) {
                    SimplifyAssertFix.replaceWithAssertEquals(assertTrueFalseHint, "assertArrayEquals");
                } else if (BoolUtils.isNegation(argument)) {
                    SimplifyAssertFix.replaceWithNegatedBooleanAssertion(assertTrueFalseHint);
                } else if (assertTrue && SimplifiableAssertionInspection.isInstanceOfComparison(argument) && SimplifiableAssertionInspection.isInstanceOfMethodExistsWithMatchingParams(assertTrueFalseHint)) {
                    SimplifyAssertFix.replaceWithInstanceOfComparison(assertTrueFalseHint);
                }
            }
        }

        private static void addStaticImportOrQualifier(String methodName, AssertHint assertHint, StringBuilder out) {
            PsiMethodCallExpression originalMethodCall = (PsiMethodCallExpression)assertHint.getOriginalExpression();
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = assertHint.getMethod();
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className = containingClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                if (!ImportUtils.addStaticImport(className, methodName, (PsiElement)originalMethodCall)) {
                    out.append(className).append(".");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private static void replaceWithFail(AssertHint assertHint) {
            @NonNls StringBuilder newExpression = new StringBuilder();
            SimplifyAssertFix.addStaticImportOrQualifier("fail", assertHint, newExpression);
            newExpression.append("fail(");
            PsiExpression message = assertHint.getMessage();
            if (message != null) {
                newExpression.append(message.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression.toString());
        }

        private static void replaceWithAssertEquals(AssertHint assertHint, @NonNls String methodName) {
            PsiExpression temp;
            PsiExpression firstArgument = assertHint.getFirstArgument();
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (firstArgument instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)firstArgument;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else {
                EqualityCheck check = EqualityCheck.from(firstArgument);
                if (check != null) {
                    lhs = check.getLeft();
                    rhs = check.getRight();
                } else if (firstArgument instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)firstArgument)) {
                    PsiExpression[] args = ((PsiMethodCallExpression)firstArgument).getArgumentList().getExpressions();
                    lhs = args[0];
                    rhs = args[1];
                }
            }
            if (!ExpressionUtils.isEvaluatedAtCompileTime(lhs) && ExpressionUtils.isEvaluatedAtCompileTime(rhs)) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            if (!assertHint.isExpectedActualOrder()) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            StringBuilder buf = new StringBuilder();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)lhs)) {
                PsiPrimitiveType rhsUnboxedType = PsiPrimitiveType.getUnboxedType((PsiType)rhsType);
                if (SimplifyAssertFix.isPrimitiveAndBoxedWithOverloads(lhsType, rhsType) && rhsUnboxedType != null) {
                    buf.append(lhs.getText()).append(",(").append(rhsUnboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)lhsType);
                    if (SimplifyAssertFix.isPrimitiveAndBoxedWithOverloads(rhsType, lhsType) && unboxedType != null) {
                        buf.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                    } else {
                        buf.append(lhs.getText()).append(',').append(rhs.getText());
                    }
                }
            } else {
                buf.append(lhs.getText()).append(',').append(rhs.getText());
            }
            PsiExpression originalExpression = assertHint.getOriginalExpression();
            if (lhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)lhsType.getDeepComponentType()) || rhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)rhsType.getDeepComponentType())) {
                PsiMethod method;
                String noDelta = SimplifyAssertFix.compoundMethodCall(methodName, assertHint, buf.toString());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalExpression.getProject());
                PsiExpression expression = methodName.equals("assertNotEquals") ? null : factory.createExpressionFromText(noDelta, (PsiElement)originalExpression);
                PsiMethod psiMethod = method = expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).resolveMethod() : null;
                if (method == null || method.isDeprecated()) {
                    buf.append(",0.0");
                }
            }
            String newExpression = SimplifyAssertFix.compoundMethodCall(methodName, assertHint, buf.toString());
            PsiReplacementUtil.replaceExpressionAndShorten(originalExpression, newExpression);
        }

        private static boolean isPrimitiveAndBoxedWithOverloads(PsiType lhsType, PsiType rhsType) {
            if (lhsType instanceof PsiPrimitiveType && !PsiTypes.floatType().equals((Object)lhsType) && !PsiTypes.doubleType().equals((Object)lhsType)) {
                return rhsType instanceof PsiClassType;
            }
            return false;
        }

        private static void replaceWithNegatedBooleanAssertion(AssertHint assertHint) {
            PsiPrefixExpression expression = (PsiPrefixExpression)assertHint.getFirstArgument();
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
            if (operand == null) {
                return;
            }
            String newMethodName = assertHint.isAssertTrue() ? "assertFalse" : "assertTrue";
            String newExpression = SimplifyAssertFix.compoundMethodCall(newMethodName, assertHint, operand.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static void replaceAssertWithAssertNull(AssertHint assertHint) {
            String methodName;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)assertHint.getFirstArgument();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!ExpressionUtils.isEvaluatedAtCompileTime(lhs) && ExpressionUtils.isEvaluatedAtCompileTime(rhs)) {
                rhs = lhs;
            }
            @NonNls String memberName = "assertFalse".equals(methodName = assertHint.getMethod().getName()) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            String newExpression = SimplifyAssertFix.compoundMethodCall(memberName, assertHint, rhs.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static void replaceWithInstanceOfComparison(@NotNull AssertHint assertHint) {
            if (assertHint == null) {
                SimplifyAssertFix.$$$reportNull$$$0(4);
            }
            PsiInstanceOfExpression expression = (PsiInstanceOfExpression)assertHint.getFirstArgument();
            PsiExpression operand = expression.getOperand();
            PsiTypeElement type = expression.getCheckType();
            if (type == null) {
                return;
            }
            String newExpression = SimplifyAssertFix.compoundMethodCall("assertInstanceOf", assertHint, type.getText() + ".class," + operand.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static String compoundMethodCall(@NonNls String methodName, AssertHint assertHint, String args) {
            PsiExpression message = assertHint.getMessage();
            StringBuilder newExpression = new StringBuilder();
            SimplifyAssertFix.addStaticImportOrQualifier(methodName, assertHint, newExpression);
            newExpression.append(methodName).append('(');
            int index = assertHint.getArgIndex();
            if (message != null && index != 0) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(args);
            if (message != null && index == 0) {
                newExpression.append(',').append(message.getText());
            }
            newExpression.append(')');
            return newExpression.toString();
        }

        private static void replaceWithAssertSame(AssertHint assertHint) {
            PsiBinaryExpression firstArgument = (PsiBinaryExpression)assertHint.getFirstArgument();
            PsiExpression lhs = firstArgument.getLOperand();
            PsiExpression rhs = firstArgument.getROperand();
            IElementType tokenType = firstArgument.getOperationTokenType();
            if (!ExpressionUtils.isEvaluatedAtCompileTime(lhs) && ExpressionUtils.isEvaluatedAtCompileTime(rhs)) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            @NonNls String methodName = assertHint.getMethod().getName();
            @NonNls String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            String newExpression = SimplifyAssertFix.compoundMethodCall(memberName, assertHint, lhs.getText() + "," + rhs.getText());
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static void replaceAssertEqualsWithAssertLiteral(AssertHint assertHint) {
            String compareValue;
            String literalValue;
            PsiExpression secondTestArgument;
            PsiExpression firstTestArgument = assertHint.getFirstArgument();
            if (SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = assertHint.getSecondArgument())) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            @NonNls String methodName = "assert" + uppercaseLiteralValue;
            String newExpression = SimplifyAssertFix.compoundMethodCall(methodName, assertHint, compareValue);
            PsiReplacementUtil.replaceExpressionAndShorten(assertHint.getOriginalExpression(), newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifyAssertFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assertHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifyAssertFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithInstanceOfComparison";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SimplifiableJUnitAssertionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression);
            if (assertHint != null && SimplifiableAssertionInspection.isAssertEqualsThatCouldBeAssertLiteral(assertHint)) {
                this.registerMethodCallError(expression, SimplifiableJUnitAssertionVisitor.getReplacementMethodName(assertHint));
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(expression);
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = assertTrueFalseHint.isAssertTrue();
                PsiExpression firstArgument = assertTrueFalseHint.getFirstArgument();
                if (ComparisonUtils.isNullComparison(firstArgument)) {
                    this.registerMethodCallError(expression, assertTrue == SimplifiableJUnitAssertionVisitor.isEqEqExpression(firstArgument) ? "assertNull()" : "assertNotNull()");
                } else if (SimplifiableAssertionInspection.isIdentityComparison(firstArgument)) {
                    this.registerMethodCallError(expression, assertTrue == SimplifiableJUnitAssertionVisitor.isEqEqExpression(firstArgument) ? "assertSame()" : "assertNotSame()");
                } else if (SimplifiableAssertionInspection.isEqualityComparison(firstArgument)) {
                    if (assertTrue) {
                        this.registerMethodCallError(expression, "assertEquals()");
                    } else if (firstArgument instanceof PsiMethodCallExpression || SimplifiableJUnitAssertionVisitor.hasPrimitiveOverload(assertTrueFalseHint)) {
                        this.registerMethodCallError(expression, "assertNotEquals()");
                    }
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(firstArgument, !assertTrue)) {
                    this.registerMethodCallError(expression, "fail()");
                } else if (assertTrue && assertTrueFalseHint.isExpectedActualOrder() && SimplifiableAssertionInspection.isArrayEqualityComparison(firstArgument)) {
                    this.registerMethodCallError(expression, "assertArrayEquals()");
                } else if (BoolUtils.isNegation(firstArgument)) {
                    this.registerMethodCallError(expression, assertTrue ? "assertFalse()" : "assertTrue()");
                } else if (assertTrue && SimplifiableAssertionInspection.isInstanceOfComparison(firstArgument) && SimplifiableAssertionInspection.isInstanceOfMethodExistsWithMatchingParams(assertTrueFalseHint)) {
                    this.registerMethodCallError(expression, "assertInstanceOf()");
                }
            }
        }

        private static boolean hasPrimitiveOverload(AssertHint assertHint) {
            PsiClass containingClass = assertHint.getMethod().getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiMethod primitiveOverload = (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
                PsiMethod patternMethod = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createMethodFromText("public static void assertNotEquals(long a, long b){}", (PsiElement)containingClass);
                return new CachedValueProvider.Result((Object)containingClass.findMethodBySignature(patternMethod, true), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            return primitiveOverload != null;
        }

        @NonNls
        private static String getReplacementMethodName(AssertHint assertHint) {
            PsiLiteralExpression literalExpression;
            PsiExpression firstArgument = assertHint.getFirstArgument();
            PsiExpression secondArgument = assertHint.getSecondArgument();
            if (firstArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)firstArgument;
            } else if (secondArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)secondArgument;
            } else {
                return "";
            }
            Object value = literalExpression.getValue();
            if (value == Boolean.TRUE) {
                return "assertTrue()";
            }
            if (value == Boolean.FALSE) {
                return "assertFalse()";
            }
            if (value == null) {
                return "assertNull()";
            }
            return "";
        }

        private static boolean isEqEqExpression(PsiExpression argument) {
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifiableJUnitAssertionVisitor", "visitMethodCallExpression"));
        }
    }
}

