/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public final class SignalWithoutCorrespondingAwaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("signal.without.corresponding.await.problem.descriptor", new Object[0]);
        if (string == null) {
            SignalWithoutCorrespondingAwaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SignalWithoutCorrespondingAwaitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection", "buildErrorString"));
    }

    private static class SignalWithoutCorrespondingAwaitVisitor
    extends BaseInspectionVisitor {
        private SignalWithoutCorrespondingAwaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SignalWithoutCorrespondingAwaitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isSignalOrSignalAllCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression, (boolean)true)) {
                return;
            }
            if (SignalWithoutCorrespondingAwaitVisitor.containsAwaitCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean containsAwaitCall(PsiClass fieldClass, PsiField field) {
            ContainsAwaitVisitor visitor2 = new ContainsAwaitVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor2);
            return visitor2.containsAwait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection$SignalWithoutCorrespondingAwaitVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ContainsAwaitVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiField target;
        private boolean containsAwait;

        ContainsAwaitVisitor(PsiField target) {
            this.target = target;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContainsAwaitVisitor.$$$reportNull$$$0(0);
            }
            if (this.containsAwait) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ContainsAwaitVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isAwaitCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals((Object)referent)) {
                return;
            }
            this.containsAwait = true;
        }

        boolean containsAwait() {
            return this.containsAwait;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SignalWithoutCorrespondingAwaitInspection$ContainsAwaitVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

