/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticInitializerReferencesSubClassInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StaticInitializerReferencesSubClassInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkSubClassReferences((PsiMember)field);
            }

            public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.checkSubClassReferences((PsiMember)initializer);
            }

            private void checkSubClassReferences(PsiMember scope) {
                if (!scope.hasModifierProperty("static")) {
                    return;
                }
                PsiClass containingClass = scope.getContainingClass();
                Pair<PsiElement, PsiClass> pair = StaticInitializerReferencesSubClassInspection.findSubClassReference((PsiElement)scope, containingClass);
                if (pair != null) {
                    holder.registerProblem((PsiElement)pair.first, InspectionGadgetsBundle.message("referencing.subclass.0.from.superclass.1.initializer.might.lead.to.class.loading.deadlock", ((PsiClass)pair.second).getName(), containingClass.getName()), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/threading/StaticInitializerReferencesSubClassInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static Pair<PsiElement, PsiClass> findSubClassReference(@NotNull PsiElement scope, final @Nullable PsiClass baseClass) {
        if (scope == null) {
            StaticInitializerReferencesSubClassInspection.$$$reportNull$$$0(1);
        }
        if (baseClass == null || baseClass.isInterface()) {
            return null;
        }
        final Ref result = Ref.create();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiElement problemElement;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiMethod || element instanceof PsiReferenceParameterList || element instanceof PsiTypeElement || element instanceof PsiLambdaExpression) {
                    return;
                }
                PsiClass targetClass = StaticInitializerReferencesSubClassInspection.extractClass(element);
                if (targetClass != null && targetClass.isInheritor(baseClass, true) && !StaticInitializerReferencesSubClassInspection.hasSingleInitializationPlace(targetClass, baseClass) && (problemElement = StaticInitializerReferencesSubClassInspection.calcProblemElement(element)) != null) {
                    result.set((Object)Pair.create((Object)problemElement, (Object)targetClass));
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/StaticInitializerReferencesSubClassInspection$2", "visitElement"));
            }
        });
        return (Pair)result.get();
    }

    private static boolean hasSingleInitializationPlace(@NotNull PsiClass targetClass, @NotNull PsiClass baseClass) {
        if (targetClass == null) {
            StaticInitializerReferencesSubClassInspection.$$$reportNull$$$0(2);
        }
        if (baseClass == null) {
            StaticInitializerReferencesSubClassInspection.$$$reportNull$$$0(3);
        }
        if (!targetClass.hasModifierProperty("private")) {
            return false;
        }
        if (!targetClass.isInheritor(baseClass, false) && !baseClass.hasModifierProperty("private")) {
            return false;
        }
        PsiFile file = targetClass.getContainingFile();
        if (file == null) {
            return false;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)file);
        return ReferencesSearch.search((PsiElement)targetClass, (SearchScope)scope).forEach((Processor)new Processor<PsiReference>(){
            int count = 0;

            public boolean process(PsiReference reference) {
                return ++this.count < 2;
            }
        });
    }

    @Nullable
    private static PsiElement calcProblemElement(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiNewExpression exp = (PsiNewExpression)element;
            return StaticInitializerReferencesSubClassInspection.calcProblemElement((PsiElement)exp.getClassOrAnonymousClassReference());
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression exp = (PsiMethodCallExpression)element;
            return StaticInitializerReferencesSubClassInspection.calcProblemElement((PsiElement)exp.getMethodExpression());
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)element;
            return ref.getReferenceNameElement();
        }
        return element;
    }

    @Nullable
    private static PsiClass extractClass(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            PsiElement psiElement = ref.resolve();
            if (psiElement instanceof PsiClass) {
                PsiClass c = (PsiClass)psiElement;
                return c;
            }
        } else if (element instanceof PsiExpression) {
            PsiExpression exp = (PsiExpression)element;
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)exp.getType());
            return psiClass instanceof PsiAnonymousClass ? psiClass.getSuperClass() : psiClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/threading/StaticInitializerReferencesSubClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubClassReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSingleInitializationPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

