/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class SynchronizeOnLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SynchroniziationOnLockObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.problem.descriptor", type);
        if (string == null) {
            SynchronizeOnLockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnLockInspection", "buildErrorString"));
    }

    private static class SynchronizeOnLockVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLockVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnLockVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(lockExpression, "java.util.concurrent.locks.Lock", "java.util.concurrent.locks.ReadWriteLock");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)lockExpression, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizeOnLockInspection$SynchronizeOnLockVisitor", "visitSynchronizedStatement"));
        }
    }
}

